<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchEntry StructType
 * @subpackage Structs
 */
class SearchEntry extends AbstractStructBase
{
    /**
     * The PACKAGE_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $PACKAGE_OBJID;
    /**
     * The servicecode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $servicecode;
    /**
     * The servicetype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $servicetype;
    /**
     * The ratefilter
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 18
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ratefilter;
    /**
     * The guesttype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $guesttype;
    /**
     * The ratesegment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ratesegment;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $rate;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * The manualrate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $manualrate;
    /**
     * The interfaceuse
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 18
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $interfaceuse;
    /**
     * The packagetypestandard
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $packagetypestandard;
    /**
     * The packagetyperoomrate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $packagetyperoomrate;
    /**
     * The packagetypepackage
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $packagetypepackage;
    /**
     * The packagetypeflexrate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $packagetypeflexrate;
    /**
     * The packagetypedefbylos
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $packagetypedefbylos;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The SERVICE_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $SERVICE_OBJID;
    /**
     * The Package
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Package[]
     */
    public $Package;
    /**
     * The Rates
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Rates[]
     */
    public $Rates;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Service[]
     */
    public $Service;
    /**
     * Constructor method for SearchEntry
     * @uses SearchEntry::setPACKAGE_OBJID()
     * @uses SearchEntry::setServicecode()
     * @uses SearchEntry::setServicetype()
     * @uses SearchEntry::setRatefilter()
     * @uses SearchEntry::setGuesttype()
     * @uses SearchEntry::setRatesegment()
     * @uses SearchEntry::setRate()
     * @uses SearchEntry::setCurrency()
     * @uses SearchEntry::setManualrate()
     * @uses SearchEntry::setInterfaceuse()
     * @uses SearchEntry::setPackagetypestandard()
     * @uses SearchEntry::setPackagetyperoomrate()
     * @uses SearchEntry::setPackagetypepackage()
     * @uses SearchEntry::setPackagetypeflexrate()
     * @uses SearchEntry::setPackagetypedefbylos()
     * @uses SearchEntry::setDescription()
     * @uses SearchEntry::setSERVICE_OBJID()
     * @uses SearchEntry::setPackage()
     * @uses SearchEntry::setRates()
     * @uses SearchEntry::setService()
     * @param string $pACKAGE_OBJID
     * @param string $servicecode
     * @param string $servicetype
     * @param string $ratefilter
     * @param string $guesttype
     * @param string $ratesegment
     * @param string $rate
     * @param string $currency
     * @param string $manualrate
     * @param string $interfaceuse
     * @param string $packagetypestandard
     * @param string $packagetyperoomrate
     * @param string $packagetypepackage
     * @param string $packagetypeflexrate
     * @param string $packagetypedefbylos
     * @param string $description
     * @param string $sERVICE_OBJID
     * @param \StructType\Package[] $package
     * @param \StructType\Rates[] $rates
     * @param \StructType\Service[] $service
     */
    public function __construct($pACKAGE_OBJID = null, $servicecode = null, $servicetype = null, $ratefilter = null, $guesttype = null, $ratesegment = null, $rate = null, $currency = null, $manualrate = null, $interfaceuse = null, $packagetypestandard = null, $packagetyperoomrate = null, $packagetypepackage = null, $packagetypeflexrate = null, $packagetypedefbylos = null, $description = null, $sERVICE_OBJID = null, array $package = array(), array $rates = array(), array $service = array())
    {
        $this
            ->setPACKAGE_OBJID($pACKAGE_OBJID)
            ->setServicecode($servicecode)
            ->setServicetype($servicetype)
            ->setRatefilter($ratefilter)
            ->setGuesttype($guesttype)
            ->setRatesegment($ratesegment)
            ->setRate($rate)
            ->setCurrency($currency)
            ->setManualrate($manualrate)
            ->setInterfaceuse($interfaceuse)
            ->setPackagetypestandard($packagetypestandard)
            ->setPackagetyperoomrate($packagetyperoomrate)
            ->setPackagetypepackage($packagetypepackage)
            ->setPackagetypeflexrate($packagetypeflexrate)
            ->setPackagetypedefbylos($packagetypedefbylos)
            ->setDescription($description)
            ->setSERVICE_OBJID($sERVICE_OBJID)
            ->setPackage($package)
            ->setRates($rates)
            ->setService($service);
    }
    /**
     * Get PACKAGE_OBJID value
     * @return string
     */
    public function getPACKAGE_OBJID()
    {
        return $this->{'PACKAGE-OBJID'};
    }
    /**
     * Set PACKAGE_OBJID value
     * @param string $pACKAGE_OBJID
     * @return \StructType\SearchEntry
     */
    public function setPACKAGE_OBJID($pACKAGE_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($pACKAGE_OBJID) && !is_string($pACKAGE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pACKAGE_OBJID, true), gettype($pACKAGE_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($pACKAGE_OBJID) && !preg_match('/([0-9])*/', $pACKAGE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($pACKAGE_OBJID, true)), __LINE__);
        }
        $this->PACKAGE_OBJID = $this->{'PACKAGE-OBJID'} = $pACKAGE_OBJID;
        return $this;
    }
    /**
     * Get servicecode value
     * @return string
     */
    public function getServicecode()
    {
        return $this->servicecode;
    }
    /**
     * Set servicecode value
     * @param string $servicecode
     * @return \StructType\SearchEntry
     */
    public function setServicecode($servicecode = null)
    {
        // validation for constraint: string
        if (!is_null($servicecode) && !is_string($servicecode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicecode, true), gettype($servicecode)), __LINE__);
        }
        $this->servicecode = $servicecode;
        return $this;
    }
    /**
     * Get servicetype value
     * @return string
     */
    public function getServicetype()
    {
        return $this->servicetype;
    }
    /**
     * Set servicetype value
     * @param string $servicetype
     * @return \StructType\SearchEntry
     */
    public function setServicetype($servicetype = null)
    {
        // validation for constraint: string
        if (!is_null($servicetype) && !is_string($servicetype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicetype, true), gettype($servicetype)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($servicetype) && mb_strlen($servicetype) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($servicetype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($servicetype) && mb_strlen($servicetype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($servicetype)), __LINE__);
        }
        $this->servicetype = $servicetype;
        return $this;
    }
    /**
     * Get ratefilter value
     * @return string
     */
    public function getRatefilter()
    {
        return $this->ratefilter;
    }
    /**
     * Set ratefilter value
     * @param string $ratefilter
     * @return \StructType\SearchEntry
     */
    public function setRatefilter($ratefilter = null)
    {
        // validation for constraint: string
        if (!is_null($ratefilter) && !is_string($ratefilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratefilter, true), gettype($ratefilter)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($ratefilter) && mb_strlen($ratefilter) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($ratefilter)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ratefilter) && mb_strlen($ratefilter) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ratefilter)), __LINE__);
        }
        $this->ratefilter = $ratefilter;
        return $this;
    }
    /**
     * Get guesttype value
     * @return string
     */
    public function getGuesttype()
    {
        return $this->guesttype;
    }
    /**
     * Set guesttype value
     * @param string $guesttype
     * @return \StructType\SearchEntry
     */
    public function setGuesttype($guesttype = null)
    {
        // validation for constraint: string
        if (!is_null($guesttype) && !is_string($guesttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guesttype, true), gettype($guesttype)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($guesttype) && mb_strlen($guesttype) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($guesttype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($guesttype) && mb_strlen($guesttype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($guesttype)), __LINE__);
        }
        $this->guesttype = $guesttype;
        return $this;
    }
    /**
     * Get ratesegment value
     * @return string
     */
    public function getRatesegment()
    {
        return $this->ratesegment;
    }
    /**
     * Set ratesegment value
     * @param string $ratesegment
     * @return \StructType\SearchEntry
     */
    public function setRatesegment($ratesegment = null)
    {
        // validation for constraint: string
        if (!is_null($ratesegment) && !is_string($ratesegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratesegment, true), gettype($ratesegment)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($ratesegment) && mb_strlen($ratesegment) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($ratesegment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ratesegment) && mb_strlen($ratesegment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ratesegment)), __LINE__);
        }
        $this->ratesegment = $ratesegment;
        return $this;
    }
    /**
     * Get rate value
     * @return string
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\SearchEntry
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($rate) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($rate, true)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\SearchEntry
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get manualrate value
     * @return string
     */
    public function getManualrate()
    {
        return $this->manualrate;
    }
    /**
     * Set manualrate value
     * @param string $manualrate
     * @return \StructType\SearchEntry
     */
    public function setManualrate($manualrate = null)
    {
        // validation for constraint: string
        if (!is_null($manualrate) && !is_string($manualrate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manualrate, true), gettype($manualrate)), __LINE__);
        }
        $this->manualrate = $manualrate;
        return $this;
    }
    /**
     * Get interfaceuse value
     * @return string
     */
    public function getInterfaceuse()
    {
        return $this->interfaceuse;
    }
    /**
     * Set interfaceuse value
     * @param string $interfaceuse
     * @return \StructType\SearchEntry
     */
    public function setInterfaceuse($interfaceuse = null)
    {
        // validation for constraint: string
        if (!is_null($interfaceuse) && !is_string($interfaceuse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interfaceuse, true), gettype($interfaceuse)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($interfaceuse) && mb_strlen($interfaceuse) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($interfaceuse)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($interfaceuse) && mb_strlen($interfaceuse) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($interfaceuse)), __LINE__);
        }
        $this->interfaceuse = $interfaceuse;
        return $this;
    }
    /**
     * Get packagetypestandard value
     * @return string
     */
    public function getPackagetypestandard()
    {
        return $this->packagetypestandard;
    }
    /**
     * Set packagetypestandard value
     * @param string $packagetypestandard
     * @return \StructType\SearchEntry
     */
    public function setPackagetypestandard($packagetypestandard = null)
    {
        // validation for constraint: string
        if (!is_null($packagetypestandard) && !is_string($packagetypestandard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packagetypestandard, true), gettype($packagetypestandard)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($packagetypestandard) && !preg_match('/([-+]){0,1}([0-9])*/', $packagetypestandard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($packagetypestandard, true)), __LINE__);
        }
        $this->packagetypestandard = $packagetypestandard;
        return $this;
    }
    /**
     * Get packagetyperoomrate value
     * @return string
     */
    public function getPackagetyperoomrate()
    {
        return $this->packagetyperoomrate;
    }
    /**
     * Set packagetyperoomrate value
     * @param string $packagetyperoomrate
     * @return \StructType\SearchEntry
     */
    public function setPackagetyperoomrate($packagetyperoomrate = null)
    {
        // validation for constraint: string
        if (!is_null($packagetyperoomrate) && !is_string($packagetyperoomrate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packagetyperoomrate, true), gettype($packagetyperoomrate)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($packagetyperoomrate) && !preg_match('/([-+]){0,1}([0-9])*/', $packagetyperoomrate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($packagetyperoomrate, true)), __LINE__);
        }
        $this->packagetyperoomrate = $packagetyperoomrate;
        return $this;
    }
    /**
     * Get packagetypepackage value
     * @return string
     */
    public function getPackagetypepackage()
    {
        return $this->packagetypepackage;
    }
    /**
     * Set packagetypepackage value
     * @param string $packagetypepackage
     * @return \StructType\SearchEntry
     */
    public function setPackagetypepackage($packagetypepackage = null)
    {
        // validation for constraint: string
        if (!is_null($packagetypepackage) && !is_string($packagetypepackage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packagetypepackage, true), gettype($packagetypepackage)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($packagetypepackage) && !preg_match('/([-+]){0,1}([0-9])*/', $packagetypepackage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($packagetypepackage, true)), __LINE__);
        }
        $this->packagetypepackage = $packagetypepackage;
        return $this;
    }
    /**
     * Get packagetypeflexrate value
     * @return string
     */
    public function getPackagetypeflexrate()
    {
        return $this->packagetypeflexrate;
    }
    /**
     * Set packagetypeflexrate value
     * @param string $packagetypeflexrate
     * @return \StructType\SearchEntry
     */
    public function setPackagetypeflexrate($packagetypeflexrate = null)
    {
        // validation for constraint: string
        if (!is_null($packagetypeflexrate) && !is_string($packagetypeflexrate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packagetypeflexrate, true), gettype($packagetypeflexrate)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($packagetypeflexrate) && !preg_match('/([-+]){0,1}([0-9])*/', $packagetypeflexrate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($packagetypeflexrate, true)), __LINE__);
        }
        $this->packagetypeflexrate = $packagetypeflexrate;
        return $this;
    }
    /**
     * Get packagetypedefbylos value
     * @return string
     */
    public function getPackagetypedefbylos()
    {
        return $this->packagetypedefbylos;
    }
    /**
     * Set packagetypedefbylos value
     * @param string $packagetypedefbylos
     * @return \StructType\SearchEntry
     */
    public function setPackagetypedefbylos($packagetypedefbylos = null)
    {
        // validation for constraint: string
        if (!is_null($packagetypedefbylos) && !is_string($packagetypedefbylos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packagetypedefbylos, true), gettype($packagetypedefbylos)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($packagetypedefbylos) && !preg_match('/([-+]){0,1}([0-9])*/', $packagetypedefbylos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($packagetypedefbylos, true)), __LINE__);
        }
        $this->packagetypedefbylos = $packagetypedefbylos;
        return $this;
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\SearchEntry
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get SERVICE_OBJID value
     * @return string
     */
    public function getSERVICE_OBJID()
    {
        return $this->{'SERVICE-OBJID'};
    }
    /**
     * Set SERVICE_OBJID value
     * @param string $sERVICE_OBJID
     * @return \StructType\SearchEntry
     */
    public function setSERVICE_OBJID($sERVICE_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($sERVICE_OBJID) && !is_string($sERVICE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sERVICE_OBJID, true), gettype($sERVICE_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($sERVICE_OBJID) && !preg_match('/([0-9])*/', $sERVICE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($sERVICE_OBJID, true)), __LINE__);
        }
        $this->SERVICE_OBJID = $this->{'SERVICE-OBJID'} = $sERVICE_OBJID;
        return $this;
    }
    /**
     * Get Package value
     * @return \StructType\Package[]|null
     */
    public function getPackage()
    {
        return $this->Package;
    }
    /**
     * This method is responsible for validating the values passed to the setPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageForArrayConstraintsFromSetPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchEntryPackageItem) {
            // validation for constraint: itemType
            if (!$searchEntryPackageItem instanceof \StructType\Package) {
                $invalidValues[] = is_object($searchEntryPackageItem) ? get_class($searchEntryPackageItem) : sprintf('%s(%s)', gettype($searchEntryPackageItem), var_export($searchEntryPackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Package property can only contain items of type \StructType\Package, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Package value
     * @throws \InvalidArgumentException
     * @param \StructType\Package[] $package
     * @return \StructType\SearchEntry
     */
    public function setPackage(array $package = array())
    {
        // validation for constraint: array
        if ('' !== ($packageArrayErrorMessage = self::validatePackageForArrayConstraintsFromSetPackage($package))) {
            throw new \InvalidArgumentException($packageArrayErrorMessage, __LINE__);
        }
        $this->Package = $package;
        return $this;
    }
    /**
     * Add item to Package value
     * @throws \InvalidArgumentException
     * @param \StructType\Package $item
     * @return \StructType\SearchEntry
     */
    public function addToPackage(\StructType\Package $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Package) {
            throw new \InvalidArgumentException(sprintf('The Package property can only contain items of type \StructType\Package, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Package[] = $item;
        return $this;
    }
    /**
     * Get Rates value
     * @return \StructType\Rates[]|null
     */
    public function getRates()
    {
        return $this->Rates;
    }
    /**
     * This method is responsible for validating the values passed to the setRates method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRates method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRatesForArrayConstraintsFromSetRates(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchEntryRatesItem) {
            // validation for constraint: itemType
            if (!$searchEntryRatesItem instanceof \StructType\Rates) {
                $invalidValues[] = is_object($searchEntryRatesItem) ? get_class($searchEntryRatesItem) : sprintf('%s(%s)', gettype($searchEntryRatesItem), var_export($searchEntryRatesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Rates property can only contain items of type \StructType\Rates, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Rates value
     * @throws \InvalidArgumentException
     * @param \StructType\Rates[] $rates
     * @return \StructType\SearchEntry
     */
    public function setRates(array $rates = array())
    {
        // validation for constraint: array
        if ('' !== ($ratesArrayErrorMessage = self::validateRatesForArrayConstraintsFromSetRates($rates))) {
            throw new \InvalidArgumentException($ratesArrayErrorMessage, __LINE__);
        }
        $this->Rates = $rates;
        return $this;
    }
    /**
     * Add item to Rates value
     * @throws \InvalidArgumentException
     * @param \StructType\Rates $item
     * @return \StructType\SearchEntry
     */
    public function addToRates(\StructType\Rates $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Rates) {
            throw new \InvalidArgumentException(sprintf('The Rates property can only contain items of type \StructType\Rates, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Rates[] = $item;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\Service[]|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * This method is responsible for validating the values passed to the setService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceForArrayConstraintsFromSetService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchEntryServiceItem) {
            // validation for constraint: itemType
            if (!$searchEntryServiceItem instanceof \StructType\Service) {
                $invalidValues[] = is_object($searchEntryServiceItem) ? get_class($searchEntryServiceItem) : sprintf('%s(%s)', gettype($searchEntryServiceItem), var_export($searchEntryServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service property can only contain items of type \StructType\Service, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service value
     * @throws \InvalidArgumentException
     * @param \StructType\Service[] $service
     * @return \StructType\SearchEntry
     */
    public function setService(array $service = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceArrayErrorMessage = self::validateServiceForArrayConstraintsFromSetService($service))) {
            throw new \InvalidArgumentException($serviceArrayErrorMessage, __LINE__);
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Add item to Service value
     * @throws \InvalidArgumentException
     * @param \StructType\Service $item
     * @return \StructType\SearchEntry
     */
    public function addToService(\StructType\Service $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Service) {
            throw new \InvalidArgumentException(sprintf('The Service property can only contain items of type \StructType\Service, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service[] = $item;
        return $this;
    }
}
