<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_TRAIL_ATTACHMENT_TO_EXTERNAL_DOCUMENT_ADD_V001Request
 * StructType
 * @subpackage Structs
 */
class S_TRAIL_ATTACHMENT_TO_EXTERNAL_DOCUMENT_ADD_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The ExternalFile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ExternalFile
     */
    public $ExternalFile;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_TRAIL_ATTACHMENT_TO_EXTERNAL_DOCUMENT_ADD_V001Request
     * @uses S_TRAIL_ATTACHMENT_TO_EXTERNAL_DOCUMENT_ADD_V001Request::setAuthentication()
     * @uses S_TRAIL_ATTACHMENT_TO_EXTERNAL_DOCUMENT_ADD_V001Request::setExternalFile()
     * @uses S_TRAIL_ATTACHMENT_TO_EXTERNAL_DOCUMENT_ADD_V001Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\ExternalFile $externalFile
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\ExternalFile $externalFile = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setExternalFile($externalFile)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_TRAIL_ATTACHMENT_TO_EXTERNAL_DOCUMENT_ADD_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get ExternalFile value
     * @return \StructType\ExternalFile
     */
    public function getExternalFile()
    {
        return $this->ExternalFile;
    }
    /**
     * Set ExternalFile value
     * @param \StructType\ExternalFile $externalFile
     * @return \StructType\S_TRAIL_ATTACHMENT_TO_EXTERNAL_DOCUMENT_ADD_V001Request
     */
    public function setExternalFile(\StructType\ExternalFile $externalFile = null)
    {
        $this->ExternalFile = $externalFile;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_TRAIL_ATTACHMENT_TO_EXTERNAL_DOCUMENT_ADD_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
