<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V003Request
 * StructType
 * @subpackage Structs
 */
class S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V003Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The Room
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Room
     */
    public $Room;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V003Request
     * @uses S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V003Request::setAuthentication()
     * @uses S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V003Request::setRoom()
     * @uses S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V003Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\Room $room
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\Room $room = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setRoom($room)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V003Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get Room value
     * @return \StructType\Room
     */
    public function getRoom()
    {
        return $this->Room;
    }
    /**
     * Set Room value
     * @param \StructType\Room $room
     * @return \StructType\S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V003Request
     */
    public function setRoom(\StructType\Room $room = null)
    {
        $this->Room = $room;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V003Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
