<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001Response
 * StructType
 * @subpackage Structs
 */
class S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The MaintenanceRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MaintenanceRequest[]
     */
    public $MaintenanceRequest;
    /**
     * Constructor method for S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001Response
     * @uses S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001Response::setResult()
     * @uses S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001Response::setTransactionID()
     * @uses S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001Response::setMaintenanceRequest()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\MaintenanceRequest[] $maintenanceRequest
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $maintenanceRequest = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setMaintenanceRequest($maintenanceRequest);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get MaintenanceRequest value
     * @return \StructType\MaintenanceRequest[]|null
     */
    public function getMaintenanceRequest()
    {
        return $this->MaintenanceRequest;
    }
    /**
     * This method is responsible for validating the values passed to the setMaintenanceRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMaintenanceRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMaintenanceRequestForArrayConstraintsFromSetMaintenanceRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001ResponseMaintenanceRequestItem) {
            // validation for constraint: itemType
            if (!$s_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001ResponseMaintenanceRequestItem instanceof \StructType\MaintenanceRequest) {
                $invalidValues[] = is_object($s_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001ResponseMaintenanceRequestItem) ? get_class($s_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001ResponseMaintenanceRequestItem) : sprintf('%s(%s)', gettype($s_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001ResponseMaintenanceRequestItem), var_export($s_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001ResponseMaintenanceRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MaintenanceRequest property can only contain items of type \StructType\MaintenanceRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MaintenanceRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\MaintenanceRequest[] $maintenanceRequest
     * @return \StructType\S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001Response
     */
    public function setMaintenanceRequest(array $maintenanceRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($maintenanceRequestArrayErrorMessage = self::validateMaintenanceRequestForArrayConstraintsFromSetMaintenanceRequest($maintenanceRequest))) {
            throw new \InvalidArgumentException($maintenanceRequestArrayErrorMessage, __LINE__);
        }
        $this->MaintenanceRequest = $maintenanceRequest;
        return $this;
    }
    /**
     * Add item to MaintenanceRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\MaintenanceRequest $item
     * @return \StructType\S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001Response
     */
    public function addToMaintenanceRequest(\StructType\MaintenanceRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MaintenanceRequest) {
            throw new \InvalidArgumentException(sprintf('The MaintenanceRequest property can only contain items of type \StructType\MaintenanceRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MaintenanceRequest[] = $item;
        return $this;
    }
}
