<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_RESERVATION_CREATE_V001Request StructType
 * @subpackage Structs
 */
class S_RESERVATION_CREATE_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The RESERVATION
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RESERVATION
     */
    public $RESERVATION;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The ALLOTMENT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ALLOTMENT
     */
    public $ALLOTMENT;
    /**
     * Constructor method for S_RESERVATION_CREATE_V001Request
     * @uses S_RESERVATION_CREATE_V001Request::setAuthentication()
     * @uses S_RESERVATION_CREATE_V001Request::setRESERVATION()
     * @uses S_RESERVATION_CREATE_V001Request::setTransactionID()
     * @uses S_RESERVATION_CREATE_V001Request::setALLOTMENT()
     * @param \StructType\Authentication $authentication
     * @param \StructType\RESERVATION $rESERVATION
     * @param string $transactionID
     * @param \StructType\ALLOTMENT $aLLOTMENT
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\RESERVATION $rESERVATION = null, $transactionID = null, \StructType\ALLOTMENT $aLLOTMENT = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setRESERVATION($rESERVATION)
            ->setTransactionID($transactionID)
            ->setALLOTMENT($aLLOTMENT);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_RESERVATION_CREATE_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get RESERVATION value
     * @return \StructType\RESERVATION
     */
    public function getRESERVATION()
    {
        return $this->RESERVATION;
    }
    /**
     * Set RESERVATION value
     * @param \StructType\RESERVATION $rESERVATION
     * @return \StructType\S_RESERVATION_CREATE_V001Request
     */
    public function setRESERVATION(\StructType\RESERVATION $rESERVATION = null)
    {
        $this->RESERVATION = $rESERVATION;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_RESERVATION_CREATE_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get ALLOTMENT value
     * @return \StructType\ALLOTMENT|null
     */
    public function getALLOTMENT()
    {
        return $this->ALLOTMENT;
    }
    /**
     * Set ALLOTMENT value
     * @param \StructType\ALLOTMENT $aLLOTMENT
     * @return \StructType\S_RESERVATION_CREATE_V001Request
     */
    public function setALLOTMENT(\StructType\ALLOTMENT $aLLOTMENT = null)
    {
        $this->ALLOTMENT = $aLLOTMENT;
        return $this;
    }
}
