<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_PRODUCT_FEATURES_GET_V001Response StructType
 * @subpackage Structs
 */
class S_PRODUCT_FEATURES_GET_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The PRODUCT_FEATURES
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PRODUCT_FEATURES[]
     */
    public $PRODUCT_FEATURES;
    /**
     * Constructor method for S_PRODUCT_FEATURES_GET_V001Response
     * @uses S_PRODUCT_FEATURES_GET_V001Response::setResult()
     * @uses S_PRODUCT_FEATURES_GET_V001Response::setTransactionID()
     * @uses S_PRODUCT_FEATURES_GET_V001Response::setPRODUCT_FEATURES()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\PRODUCT_FEATURES[] $pRODUCT_FEATURES
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $pRODUCT_FEATURES = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setPRODUCT_FEATURES($pRODUCT_FEATURES);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_PRODUCT_FEATURES_GET_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_PRODUCT_FEATURES_GET_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get PRODUCT_FEATURES value
     * @return \StructType\PRODUCT_FEATURES[]|null
     */
    public function getPRODUCT_FEATURES()
    {
        return $this->{'PRODUCT-FEATURES'};
    }
    /**
     * This method is responsible for validating the values passed to the setPRODUCT_FEATURES method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPRODUCT_FEATURES method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePRODUCT_FEATURESForArrayConstraintsFromSetPRODUCT_FEATURES(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_PRODUCT_FEATURES_GET_V001ResponsePRODUCT_FEATURESItem) {
            // validation for constraint: itemType
            if (!$s_PRODUCT_FEATURES_GET_V001ResponsePRODUCT_FEATURESItem instanceof \StructType\PRODUCT_FEATURES) {
                $invalidValues[] = is_object($s_PRODUCT_FEATURES_GET_V001ResponsePRODUCT_FEATURESItem) ? get_class($s_PRODUCT_FEATURES_GET_V001ResponsePRODUCT_FEATURESItem) : sprintf('%s(%s)', gettype($s_PRODUCT_FEATURES_GET_V001ResponsePRODUCT_FEATURESItem), var_export($s_PRODUCT_FEATURES_GET_V001ResponsePRODUCT_FEATURESItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PRODUCT_FEATURES property can only contain items of type \StructType\PRODUCT_FEATURES, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PRODUCT_FEATURES value
     * @throws \InvalidArgumentException
     * @param \StructType\PRODUCT_FEATURES[] $pRODUCT_FEATURES
     * @return \StructType\S_PRODUCT_FEATURES_GET_V001Response
     */
    public function setPRODUCT_FEATURES(array $pRODUCT_FEATURES = array())
    {
        // validation for constraint: array
        if ('' !== ($pRODUCT_FEATURESArrayErrorMessage = self::validatePRODUCT_FEATURESForArrayConstraintsFromSetPRODUCT_FEATURES($pRODUCT_FEATURES))) {
            throw new \InvalidArgumentException($pRODUCT_FEATURESArrayErrorMessage, __LINE__);
        }
        $this->PRODUCT_FEATURES = $this->{'PRODUCT-FEATURES'} = $pRODUCT_FEATURES;
        return $this;
    }
    /**
     * Add item to PRODUCT_FEATURES value
     * @throws \InvalidArgumentException
     * @param \StructType\PRODUCT_FEATURES $item
     * @return \StructType\S_PRODUCT_FEATURES_GET_V001Response
     */
    public function addToPRODUCT_FEATURES(\StructType\PRODUCT_FEATURES $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PRODUCT_FEATURES) {
            throw new \InvalidArgumentException(sprintf('The PRODUCT_FEATURES property can only contain items of type \StructType\PRODUCT_FEATURES, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PRODUCT_FEATURES[] = $this->{'PRODUCT-FEATURES'}[] = $item;
        return $this;
    }
}
