<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_PERSON_GUEST_UNASSIGN_V001Request StructType
 * @subpackage Structs
 */
class S_PERSON_GUEST_UNASSIGN_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The PERSON
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PERSON_2
     */
    public $PERSON;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_PERSON_GUEST_UNASSIGN_V001Request
     * @uses S_PERSON_GUEST_UNASSIGN_V001Request::setAuthentication()
     * @uses S_PERSON_GUEST_UNASSIGN_V001Request::setPERSON()
     * @uses S_PERSON_GUEST_UNASSIGN_V001Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\PERSON_2 $pERSON
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\PERSON_2 $pERSON = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setPERSON($pERSON)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_PERSON_GUEST_UNASSIGN_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get PERSON value
     * @return \StructType\PERSON_2
     */
    public function getPERSON()
    {
        return $this->PERSON;
    }
    /**
     * Set PERSON value
     * @param \StructType\PERSON_2 $pERSON
     * @return \StructType\S_PERSON_GUEST_UNASSIGN_V001Request
     */
    public function setPERSON(\StructType\PERSON_2 $pERSON = null)
    {
        $this->PERSON = $pERSON;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_PERSON_GUEST_UNASSIGN_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
