<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_PERSON_ADD_SERVICE_V001Request StructType
 * @subpackage Structs
 */
class S_PERSON_ADD_SERVICE_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The PersonSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PersonSearch
     */
    public $PersonSearch;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The ServiceData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceData
     */
    public $ServiceData;
    /**
     * Constructor method for S_PERSON_ADD_SERVICE_V001Request
     * @uses S_PERSON_ADD_SERVICE_V001Request::setAuthentication()
     * @uses S_PERSON_ADD_SERVICE_V001Request::setPersonSearch()
     * @uses S_PERSON_ADD_SERVICE_V001Request::setTransactionID()
     * @uses S_PERSON_ADD_SERVICE_V001Request::setServiceData()
     * @param \StructType\Authentication $authentication
     * @param \StructType\PersonSearch $personSearch
     * @param string $transactionID
     * @param \StructType\ServiceData $serviceData
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\PersonSearch $personSearch = null, $transactionID = null, \StructType\ServiceData $serviceData = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setPersonSearch($personSearch)
            ->setTransactionID($transactionID)
            ->setServiceData($serviceData);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_PERSON_ADD_SERVICE_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get PersonSearch value
     * @return \StructType\PersonSearch
     */
    public function getPersonSearch()
    {
        return $this->PersonSearch;
    }
    /**
     * Set PersonSearch value
     * @param \StructType\PersonSearch $personSearch
     * @return \StructType\S_PERSON_ADD_SERVICE_V001Request
     */
    public function setPersonSearch(\StructType\PersonSearch $personSearch = null)
    {
        $this->PersonSearch = $personSearch;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_PERSON_ADD_SERVICE_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get ServiceData value
     * @return \StructType\ServiceData|null
     */
    public function getServiceData()
    {
        return $this->ServiceData;
    }
    /**
     * Set ServiceData value
     * @param \StructType\ServiceData $serviceData
     * @return \StructType\S_PERSON_ADD_SERVICE_V001Request
     */
    public function setServiceData(\StructType\ServiceData $serviceData = null)
    {
        $this->ServiceData = $serviceData;
        return $this;
    }
}
