<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_PAYMENT_POSTING_SEARCH_V001Response StructType
 * @subpackage Structs
 */
class S_PAYMENT_POSTING_SEARCH_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The PAYMENT_POSTINGS
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PAYMENT_POSTINGS[]
     */
    public $PAYMENT_POSTINGS;
    /**
     * Constructor method for S_PAYMENT_POSTING_SEARCH_V001Response
     * @uses S_PAYMENT_POSTING_SEARCH_V001Response::setResult()
     * @uses S_PAYMENT_POSTING_SEARCH_V001Response::setTransactionID()
     * @uses S_PAYMENT_POSTING_SEARCH_V001Response::setPAYMENT_POSTINGS()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\PAYMENT_POSTINGS[] $pAYMENT_POSTINGS
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $pAYMENT_POSTINGS = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setPAYMENT_POSTINGS($pAYMENT_POSTINGS);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_PAYMENT_POSTING_SEARCH_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_PAYMENT_POSTING_SEARCH_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get PAYMENT_POSTINGS value
     * @return \StructType\PAYMENT_POSTINGS[]|null
     */
    public function getPAYMENT_POSTINGS()
    {
        return $this->{'PAYMENT-POSTINGS'};
    }
    /**
     * This method is responsible for validating the values passed to the setPAYMENT_POSTINGS method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPAYMENT_POSTINGS method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePAYMENT_POSTINGSForArrayConstraintsFromSetPAYMENT_POSTINGS(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_PAYMENT_POSTING_SEARCH_V001ResponsePAYMENT_POSTINGSItem) {
            // validation for constraint: itemType
            if (!$s_PAYMENT_POSTING_SEARCH_V001ResponsePAYMENT_POSTINGSItem instanceof \StructType\PAYMENT_POSTINGS) {
                $invalidValues[] = is_object($s_PAYMENT_POSTING_SEARCH_V001ResponsePAYMENT_POSTINGSItem) ? get_class($s_PAYMENT_POSTING_SEARCH_V001ResponsePAYMENT_POSTINGSItem) : sprintf('%s(%s)', gettype($s_PAYMENT_POSTING_SEARCH_V001ResponsePAYMENT_POSTINGSItem), var_export($s_PAYMENT_POSTING_SEARCH_V001ResponsePAYMENT_POSTINGSItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PAYMENT_POSTINGS property can only contain items of type \StructType\PAYMENT_POSTINGS, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PAYMENT_POSTINGS value
     * @throws \InvalidArgumentException
     * @param \StructType\PAYMENT_POSTINGS[] $pAYMENT_POSTINGS
     * @return \StructType\S_PAYMENT_POSTING_SEARCH_V001Response
     */
    public function setPAYMENT_POSTINGS(array $pAYMENT_POSTINGS = array())
    {
        // validation for constraint: array
        if ('' !== ($pAYMENT_POSTINGSArrayErrorMessage = self::validatePAYMENT_POSTINGSForArrayConstraintsFromSetPAYMENT_POSTINGS($pAYMENT_POSTINGS))) {
            throw new \InvalidArgumentException($pAYMENT_POSTINGSArrayErrorMessage, __LINE__);
        }
        $this->PAYMENT_POSTINGS = $this->{'PAYMENT-POSTINGS'} = $pAYMENT_POSTINGS;
        return $this;
    }
    /**
     * Add item to PAYMENT_POSTINGS value
     * @throws \InvalidArgumentException
     * @param \StructType\PAYMENT_POSTINGS $item
     * @return \StructType\S_PAYMENT_POSTING_SEARCH_V001Response
     */
    public function addToPAYMENT_POSTINGS(\StructType\PAYMENT_POSTINGS $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PAYMENT_POSTINGS) {
            throw new \InvalidArgumentException(sprintf('The PAYMENT_POSTINGS property can only contain items of type \StructType\PAYMENT_POSTINGS, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PAYMENT_POSTINGS[] = $this->{'PAYMENT-POSTINGS'}[] = $item;
        return $this;
    }
}
