<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_PAYMENT_POSTING_SEARCH_V001Request StructType
 * @subpackage Structs
 */
class S_PAYMENT_POSTING_SEARCH_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The PAYMENT_POSTING_SEARCH
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PAYMENT_POSTING_SEARCH
     */
    public $PAYMENT_POSTING_SEARCH;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_PAYMENT_POSTING_SEARCH_V001Request
     * @uses S_PAYMENT_POSTING_SEARCH_V001Request::setAuthentication()
     * @uses S_PAYMENT_POSTING_SEARCH_V001Request::setPAYMENT_POSTING_SEARCH()
     * @uses S_PAYMENT_POSTING_SEARCH_V001Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\PAYMENT_POSTING_SEARCH $pAYMENT_POSTING_SEARCH
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\PAYMENT_POSTING_SEARCH $pAYMENT_POSTING_SEARCH = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setPAYMENT_POSTING_SEARCH($pAYMENT_POSTING_SEARCH)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_PAYMENT_POSTING_SEARCH_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get PAYMENT_POSTING_SEARCH value
     * @return \StructType\PAYMENT_POSTING_SEARCH
     */
    public function getPAYMENT_POSTING_SEARCH()
    {
        return $this->{'PAYMENT-POSTING-SEARCH'};
    }
    /**
     * Set PAYMENT_POSTING_SEARCH value
     * @param \StructType\PAYMENT_POSTING_SEARCH $pAYMENT_POSTING_SEARCH
     * @return \StructType\S_PAYMENT_POSTING_SEARCH_V001Request
     */
    public function setPAYMENT_POSTING_SEARCH(\StructType\PAYMENT_POSTING_SEARCH $pAYMENT_POSTING_SEARCH = null)
    {
        $this->PAYMENT_POSTING_SEARCH = $this->{'PAYMENT-POSTING-SEARCH'} = $pAYMENT_POSTING_SEARCH;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_PAYMENT_POSTING_SEARCH_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
