<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_PAYMENT_COMMIT_V001Response StructType
 * @subpackage Structs
 */
class S_PAYMENT_COMMIT_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The PaymentCommit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentCommit[]
     */
    public $PaymentCommit;
    /**
     * Constructor method for S_PAYMENT_COMMIT_V001Response
     * @uses S_PAYMENT_COMMIT_V001Response::setResult()
     * @uses S_PAYMENT_COMMIT_V001Response::setTransactionID()
     * @uses S_PAYMENT_COMMIT_V001Response::setPaymentCommit()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\PaymentCommit[] $paymentCommit
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $paymentCommit = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setPaymentCommit($paymentCommit);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_PAYMENT_COMMIT_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_PAYMENT_COMMIT_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get PaymentCommit value
     * @return \StructType\PaymentCommit[]|null
     */
    public function getPaymentCommit()
    {
        return $this->PaymentCommit;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentCommit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentCommit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentCommitForArrayConstraintsFromSetPaymentCommit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_PAYMENT_COMMIT_V001ResponsePaymentCommitItem) {
            // validation for constraint: itemType
            if (!$s_PAYMENT_COMMIT_V001ResponsePaymentCommitItem instanceof \StructType\PaymentCommit) {
                $invalidValues[] = is_object($s_PAYMENT_COMMIT_V001ResponsePaymentCommitItem) ? get_class($s_PAYMENT_COMMIT_V001ResponsePaymentCommitItem) : sprintf('%s(%s)', gettype($s_PAYMENT_COMMIT_V001ResponsePaymentCommitItem), var_export($s_PAYMENT_COMMIT_V001ResponsePaymentCommitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentCommit property can only contain items of type \StructType\PaymentCommit, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentCommit value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentCommit[] $paymentCommit
     * @return \StructType\S_PAYMENT_COMMIT_V001Response
     */
    public function setPaymentCommit(array $paymentCommit = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentCommitArrayErrorMessage = self::validatePaymentCommitForArrayConstraintsFromSetPaymentCommit($paymentCommit))) {
            throw new \InvalidArgumentException($paymentCommitArrayErrorMessage, __LINE__);
        }
        $this->PaymentCommit = $paymentCommit;
        return $this;
    }
    /**
     * Add item to PaymentCommit value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentCommit $item
     * @return \StructType\S_PAYMENT_COMMIT_V001Response
     */
    public function addToPaymentCommit(\StructType\PaymentCommit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentCommit) {
            throw new \InvalidArgumentException(sprintf('The PaymentCommit property can only contain items of type \StructType\PaymentCommit, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentCommit[] = $item;
        return $this;
    }
}
