<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_PAYMENT_ABORT_V001Request StructType
 * @subpackage Structs
 */
class S_PAYMENT_ABORT_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The PaymentAbort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaymentAbort
     */
    public $PaymentAbort;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_PAYMENT_ABORT_V001Request
     * @uses S_PAYMENT_ABORT_V001Request::setAuthentication()
     * @uses S_PAYMENT_ABORT_V001Request::setPaymentAbort()
     * @uses S_PAYMENT_ABORT_V001Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\PaymentAbort $paymentAbort
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\PaymentAbort $paymentAbort = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setPaymentAbort($paymentAbort)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_PAYMENT_ABORT_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get PaymentAbort value
     * @return \StructType\PaymentAbort
     */
    public function getPaymentAbort()
    {
        return $this->PaymentAbort;
    }
    /**
     * Set PaymentAbort value
     * @param \StructType\PaymentAbort $paymentAbort
     * @return \StructType\S_PAYMENT_ABORT_V001Request
     */
    public function setPaymentAbort(\StructType\PaymentAbort $paymentAbort = null)
    {
        $this->PaymentAbort = $paymentAbort;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_PAYMENT_ABORT_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
