<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_NOTIFICATION_UNREGISTER_V001Request StructType
 * @subpackage Structs
 */
class S_NOTIFICATION_UNREGISTER_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The NOTIFICATION_UNREGISTER
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\NOTIFICATION_UNREGISTER
     */
    public $NOTIFICATION_UNREGISTER;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_NOTIFICATION_UNREGISTER_V001Request
     * @uses S_NOTIFICATION_UNREGISTER_V001Request::setAuthentication()
     * @uses S_NOTIFICATION_UNREGISTER_V001Request::setNOTIFICATION_UNREGISTER()
     * @uses S_NOTIFICATION_UNREGISTER_V001Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\NOTIFICATION_UNREGISTER $nOTIFICATION_UNREGISTER
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\NOTIFICATION_UNREGISTER $nOTIFICATION_UNREGISTER = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setNOTIFICATION_UNREGISTER($nOTIFICATION_UNREGISTER)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_NOTIFICATION_UNREGISTER_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get NOTIFICATION_UNREGISTER value
     * @return \StructType\NOTIFICATION_UNREGISTER
     */
    public function getNOTIFICATION_UNREGISTER()
    {
        return $this->{'NOTIFICATION-UNREGISTER'};
    }
    /**
     * Set NOTIFICATION_UNREGISTER value
     * @param \StructType\NOTIFICATION_UNREGISTER $nOTIFICATION_UNREGISTER
     * @return \StructType\S_NOTIFICATION_UNREGISTER_V001Request
     */
    public function setNOTIFICATION_UNREGISTER(\StructType\NOTIFICATION_UNREGISTER $nOTIFICATION_UNREGISTER = null)
    {
        $this->NOTIFICATION_UNREGISTER = $this->{'NOTIFICATION-UNREGISTER'} = $nOTIFICATION_UNREGISTER;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_NOTIFICATION_UNREGISTER_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
