<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_NOTIFICATION_REGISTRATION_SEARCH_V001Response StructType
 * @subpackage Structs
 */
class S_NOTIFICATION_REGISTRATION_SEARCH_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The NOTIFICATION_REGISTRATIONS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\NOTIFICATION_REGISTRATIONS
     */
    public $NOTIFICATION_REGISTRATIONS;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_NOTIFICATION_REGISTRATION_SEARCH_V001Response
     * @uses S_NOTIFICATION_REGISTRATION_SEARCH_V001Response::setResult()
     * @uses S_NOTIFICATION_REGISTRATION_SEARCH_V001Response::setNOTIFICATION_REGISTRATIONS()
     * @uses S_NOTIFICATION_REGISTRATION_SEARCH_V001Response::setTransactionID()
     * @param \StructType\Result $result
     * @param \StructType\NOTIFICATION_REGISTRATIONS $nOTIFICATION_REGISTRATIONS
     * @param string $transactionID
     */
    public function __construct(\StructType\Result $result = null, \StructType\NOTIFICATION_REGISTRATIONS $nOTIFICATION_REGISTRATIONS = null, $transactionID = null)
    {
        $this
            ->setResult($result)
            ->setNOTIFICATION_REGISTRATIONS($nOTIFICATION_REGISTRATIONS)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_NOTIFICATION_REGISTRATION_SEARCH_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get NOTIFICATION_REGISTRATIONS value
     * @return \StructType\NOTIFICATION_REGISTRATIONS
     */
    public function getNOTIFICATION_REGISTRATIONS()
    {
        return $this->{'NOTIFICATION-REGISTRATIONS'};
    }
    /**
     * Set NOTIFICATION_REGISTRATIONS value
     * @param \StructType\NOTIFICATION_REGISTRATIONS $nOTIFICATION_REGISTRATIONS
     * @return \StructType\S_NOTIFICATION_REGISTRATION_SEARCH_V001Response
     */
    public function setNOTIFICATION_REGISTRATIONS(\StructType\NOTIFICATION_REGISTRATIONS $nOTIFICATION_REGISTRATIONS = null)
    {
        $this->NOTIFICATION_REGISTRATIONS = $this->{'NOTIFICATION-REGISTRATIONS'} = $nOTIFICATION_REGISTRATIONS;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_NOTIFICATION_REGISTRATION_SEARCH_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
