<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_HOTEL_SEARCH_V01Response StructType
 * @subpackage Structs
 */
class S_HOTEL_SEARCH_V01Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The Hotel
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Hotel[]
     */
    public $Hotel;
    /**
     * Constructor method for S_HOTEL_SEARCH_V01Response
     * @uses S_HOTEL_SEARCH_V01Response::setResult()
     * @uses S_HOTEL_SEARCH_V01Response::setTransactionID()
     * @uses S_HOTEL_SEARCH_V01Response::setHotel()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\Hotel[] $hotel
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $hotel = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setHotel($hotel);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_HOTEL_SEARCH_V01Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_HOTEL_SEARCH_V01Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get Hotel value
     * @return \StructType\Hotel[]|null
     */
    public function getHotel()
    {
        return $this->Hotel;
    }
    /**
     * This method is responsible for validating the values passed to the setHotel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelForArrayConstraintsFromSetHotel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_HOTEL_SEARCH_V01ResponseHotelItem) {
            // validation for constraint: itemType
            if (!$s_HOTEL_SEARCH_V01ResponseHotelItem instanceof \StructType\Hotel) {
                $invalidValues[] = is_object($s_HOTEL_SEARCH_V01ResponseHotelItem) ? get_class($s_HOTEL_SEARCH_V01ResponseHotelItem) : sprintf('%s(%s)', gettype($s_HOTEL_SEARCH_V01ResponseHotelItem), var_export($s_HOTEL_SEARCH_V01ResponseHotelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Hotel property can only contain items of type \StructType\Hotel, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Hotel value
     * @throws \InvalidArgumentException
     * @param \StructType\Hotel[] $hotel
     * @return \StructType\S_HOTEL_SEARCH_V01Response
     */
    public function setHotel(array $hotel = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelArrayErrorMessage = self::validateHotelForArrayConstraintsFromSetHotel($hotel))) {
            throw new \InvalidArgumentException($hotelArrayErrorMessage, __LINE__);
        }
        $this->Hotel = $hotel;
        return $this;
    }
    /**
     * Add item to Hotel value
     * @throws \InvalidArgumentException
     * @param \StructType\Hotel $item
     * @return \StructType\S_HOTEL_SEARCH_V01Response
     */
    public function addToHotel(\StructType\Hotel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Hotel) {
            throw new \InvalidArgumentException(sprintf('The Hotel property can only contain items of type \StructType\Hotel, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Hotel[] = $item;
        return $this;
    }
}
