<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_GUEST_SEARCH_V008Request StructType
 * @subpackage Structs
 */
class S_GUEST_SEARCH_V008Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The GUESTSEARCH
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\GUESTSEARCH_1
     */
    public $GUESTSEARCH;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_GUEST_SEARCH_V008Request
     * @uses S_GUEST_SEARCH_V008Request::setAuthentication()
     * @uses S_GUEST_SEARCH_V008Request::setGUESTSEARCH()
     * @uses S_GUEST_SEARCH_V008Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\GUESTSEARCH_1 $gUESTSEARCH
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\GUESTSEARCH_1 $gUESTSEARCH = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setGUESTSEARCH($gUESTSEARCH)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_GUEST_SEARCH_V008Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get GUESTSEARCH value
     * @return \StructType\GUESTSEARCH_1
     */
    public function getGUESTSEARCH()
    {
        return $this->GUESTSEARCH;
    }
    /**
     * Set GUESTSEARCH value
     * @param \StructType\GUESTSEARCH_1 $gUESTSEARCH
     * @return \StructType\S_GUEST_SEARCH_V008Request
     */
    public function setGUESTSEARCH(\StructType\GUESTSEARCH_1 $gUESTSEARCH = null)
    {
        $this->GUESTSEARCH = $gUESTSEARCH;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_GUEST_SEARCH_V008Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
