<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_GUEST_IN_HOUSE_SEARCH_V002Response StructType
 * @subpackage Structs
 */
class S_GUEST_IN_HOUSE_SEARCH_V002Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The NamelistGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NamelistGroup[]
     */
    public $NamelistGroup;
    /**
     * Constructor method for S_GUEST_IN_HOUSE_SEARCH_V002Response
     * @uses S_GUEST_IN_HOUSE_SEARCH_V002Response::setResult()
     * @uses S_GUEST_IN_HOUSE_SEARCH_V002Response::setTransactionID()
     * @uses S_GUEST_IN_HOUSE_SEARCH_V002Response::setNamelistGroup()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\NamelistGroup[] $namelistGroup
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $namelistGroup = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setNamelistGroup($namelistGroup);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_GUEST_IN_HOUSE_SEARCH_V002Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_GUEST_IN_HOUSE_SEARCH_V002Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get NamelistGroup value
     * @return \StructType\NamelistGroup[]|null
     */
    public function getNamelistGroup()
    {
        return $this->NamelistGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setNamelistGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNamelistGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNamelistGroupForArrayConstraintsFromSetNamelistGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_GUEST_IN_HOUSE_SEARCH_V002ResponseNamelistGroupItem) {
            // validation for constraint: itemType
            if (!$s_GUEST_IN_HOUSE_SEARCH_V002ResponseNamelistGroupItem instanceof \StructType\NamelistGroup) {
                $invalidValues[] = is_object($s_GUEST_IN_HOUSE_SEARCH_V002ResponseNamelistGroupItem) ? get_class($s_GUEST_IN_HOUSE_SEARCH_V002ResponseNamelistGroupItem) : sprintf('%s(%s)', gettype($s_GUEST_IN_HOUSE_SEARCH_V002ResponseNamelistGroupItem), var_export($s_GUEST_IN_HOUSE_SEARCH_V002ResponseNamelistGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NamelistGroup property can only contain items of type \StructType\NamelistGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NamelistGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\NamelistGroup[] $namelistGroup
     * @return \StructType\S_GUEST_IN_HOUSE_SEARCH_V002Response
     */
    public function setNamelistGroup(array $namelistGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($namelistGroupArrayErrorMessage = self::validateNamelistGroupForArrayConstraintsFromSetNamelistGroup($namelistGroup))) {
            throw new \InvalidArgumentException($namelistGroupArrayErrorMessage, __LINE__);
        }
        $this->NamelistGroup = $namelistGroup;
        return $this;
    }
    /**
     * Add item to NamelistGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\NamelistGroup $item
     * @return \StructType\S_GUEST_IN_HOUSE_SEARCH_V002Response
     */
    public function addToNamelistGroup(\StructType\NamelistGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NamelistGroup) {
            throw new \InvalidArgumentException(sprintf('The NamelistGroup property can only contain items of type \StructType\NamelistGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NamelistGroup[] = $item;
        return $this;
    }
}
