<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_GO_HOTEL_SEARCH_V001Request StructType
 * @subpackage Structs
 */
class S_GO_HOTEL_SEARCH_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The HotelSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\HotelSearch
     */
    public $HotelSearch;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_GO_HOTEL_SEARCH_V001Request
     * @uses S_GO_HOTEL_SEARCH_V001Request::setAuthentication()
     * @uses S_GO_HOTEL_SEARCH_V001Request::setHotelSearch()
     * @uses S_GO_HOTEL_SEARCH_V001Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\HotelSearch $hotelSearch
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\HotelSearch $hotelSearch = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setHotelSearch($hotelSearch)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_GO_HOTEL_SEARCH_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get HotelSearch value
     * @return \StructType\HotelSearch
     */
    public function getHotelSearch()
    {
        return $this->HotelSearch;
    }
    /**
     * Set HotelSearch value
     * @param \StructType\HotelSearch $hotelSearch
     * @return \StructType\S_GO_HOTEL_SEARCH_V001Request
     */
    public function setHotelSearch(\StructType\HotelSearch $hotelSearch = null)
    {
        $this->HotelSearch = $hotelSearch;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_GO_HOTEL_SEARCH_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
