<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_GO_CONFIG_V002Response StructType
 * @subpackage Structs
 */
class S_GO_CONFIG_V002Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The Leaf
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Leaf[]
     */
    public $Leaf;
    /**
     * Constructor method for S_GO_CONFIG_V002Response
     * @uses S_GO_CONFIG_V002Response::setResult()
     * @uses S_GO_CONFIG_V002Response::setTransactionID()
     * @uses S_GO_CONFIG_V002Response::setLeaf()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\Leaf[] $leaf
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $leaf = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setLeaf($leaf);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_GO_CONFIG_V002Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_GO_CONFIG_V002Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get Leaf value
     * @return \StructType\Leaf[]|null
     */
    public function getLeaf()
    {
        return $this->Leaf;
    }
    /**
     * This method is responsible for validating the values passed to the setLeaf method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLeaf method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLeafForArrayConstraintsFromSetLeaf(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_GO_CONFIG_V002ResponseLeafItem) {
            // validation for constraint: itemType
            if (!$s_GO_CONFIG_V002ResponseLeafItem instanceof \StructType\Leaf) {
                $invalidValues[] = is_object($s_GO_CONFIG_V002ResponseLeafItem) ? get_class($s_GO_CONFIG_V002ResponseLeafItem) : sprintf('%s(%s)', gettype($s_GO_CONFIG_V002ResponseLeafItem), var_export($s_GO_CONFIG_V002ResponseLeafItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Leaf property can only contain items of type \StructType\Leaf, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Leaf value
     * @throws \InvalidArgumentException
     * @param \StructType\Leaf[] $leaf
     * @return \StructType\S_GO_CONFIG_V002Response
     */
    public function setLeaf(array $leaf = array())
    {
        // validation for constraint: array
        if ('' !== ($leafArrayErrorMessage = self::validateLeafForArrayConstraintsFromSetLeaf($leaf))) {
            throw new \InvalidArgumentException($leafArrayErrorMessage, __LINE__);
        }
        $this->Leaf = $leaf;
        return $this;
    }
    /**
     * Add item to Leaf value
     * @throws \InvalidArgumentException
     * @param \StructType\Leaf $item
     * @return \StructType\S_GO_CONFIG_V002Response
     */
    public function addToLeaf(\StructType\Leaf $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Leaf) {
            throw new \InvalidArgumentException(sprintf('The Leaf property can only contain items of type \StructType\Leaf, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Leaf[] = $item;
        return $this;
    }
}
