<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_EVENT_RESERVATION_SERVICE_ADD_V001Response StructType
 * @subpackage Structs
 */
class S_EVENT_RESERVATION_SERVICE_ADD_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The EventRes
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EventRes[]
     */
    public $EventRes;
    /**
     * Constructor method for S_EVENT_RESERVATION_SERVICE_ADD_V001Response
     * @uses S_EVENT_RESERVATION_SERVICE_ADD_V001Response::setResult()
     * @uses S_EVENT_RESERVATION_SERVICE_ADD_V001Response::setTransactionID()
     * @uses S_EVENT_RESERVATION_SERVICE_ADD_V001Response::setEventRes()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\EventRes[] $eventRes
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $eventRes = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setEventRes($eventRes);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_EVENT_RESERVATION_SERVICE_ADD_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_EVENT_RESERVATION_SERVICE_ADD_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get EventRes value
     * @return \StructType\EventRes[]|null
     */
    public function getEventRes()
    {
        return $this->EventRes;
    }
    /**
     * This method is responsible for validating the values passed to the setEventRes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEventRes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventResForArrayConstraintsFromSetEventRes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_EVENT_RESERVATION_SERVICE_ADD_V001ResponseEventResItem) {
            // validation for constraint: itemType
            if (!$s_EVENT_RESERVATION_SERVICE_ADD_V001ResponseEventResItem instanceof \StructType\EventRes) {
                $invalidValues[] = is_object($s_EVENT_RESERVATION_SERVICE_ADD_V001ResponseEventResItem) ? get_class($s_EVENT_RESERVATION_SERVICE_ADD_V001ResponseEventResItem) : sprintf('%s(%s)', gettype($s_EVENT_RESERVATION_SERVICE_ADD_V001ResponseEventResItem), var_export($s_EVENT_RESERVATION_SERVICE_ADD_V001ResponseEventResItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EventRes property can only contain items of type \StructType\EventRes, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EventRes value
     * @throws \InvalidArgumentException
     * @param \StructType\EventRes[] $eventRes
     * @return \StructType\S_EVENT_RESERVATION_SERVICE_ADD_V001Response
     */
    public function setEventRes(array $eventRes = array())
    {
        // validation for constraint: array
        if ('' !== ($eventResArrayErrorMessage = self::validateEventResForArrayConstraintsFromSetEventRes($eventRes))) {
            throw new \InvalidArgumentException($eventResArrayErrorMessage, __LINE__);
        }
        $this->EventRes = $eventRes;
        return $this;
    }
    /**
     * Add item to EventRes value
     * @throws \InvalidArgumentException
     * @param \StructType\EventRes $item
     * @return \StructType\S_EVENT_RESERVATION_SERVICE_ADD_V001Response
     */
    public function addToEventRes(\StructType\EventRes $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EventRes) {
            throw new \InvalidArgumentException(sprintf('The EventRes property can only contain items of type \StructType\EventRes, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EventRes[] = $item;
        return $this;
    }
}
