<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_DISCOUNT_GET_V001Response StructType
 * @subpackage Structs
 */
class S_DISCOUNT_GET_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The DISCOUNT
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DISCOUNT[]
     */
    public $DISCOUNT;
    /**
     * Constructor method for S_DISCOUNT_GET_V001Response
     * @uses S_DISCOUNT_GET_V001Response::setResult()
     * @uses S_DISCOUNT_GET_V001Response::setTransactionID()
     * @uses S_DISCOUNT_GET_V001Response::setDISCOUNT()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\DISCOUNT[] $dISCOUNT
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $dISCOUNT = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setDISCOUNT($dISCOUNT);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_DISCOUNT_GET_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_DISCOUNT_GET_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get DISCOUNT value
     * @return \StructType\DISCOUNT[]|null
     */
    public function getDISCOUNT()
    {
        return $this->DISCOUNT;
    }
    /**
     * This method is responsible for validating the values passed to the setDISCOUNT method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDISCOUNT method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDISCOUNTForArrayConstraintsFromSetDISCOUNT(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_DISCOUNT_GET_V001ResponseDISCOUNTItem) {
            // validation for constraint: itemType
            if (!$s_DISCOUNT_GET_V001ResponseDISCOUNTItem instanceof \StructType\DISCOUNT) {
                $invalidValues[] = is_object($s_DISCOUNT_GET_V001ResponseDISCOUNTItem) ? get_class($s_DISCOUNT_GET_V001ResponseDISCOUNTItem) : sprintf('%s(%s)', gettype($s_DISCOUNT_GET_V001ResponseDISCOUNTItem), var_export($s_DISCOUNT_GET_V001ResponseDISCOUNTItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DISCOUNT property can only contain items of type \StructType\DISCOUNT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DISCOUNT value
     * @throws \InvalidArgumentException
     * @param \StructType\DISCOUNT[] $dISCOUNT
     * @return \StructType\S_DISCOUNT_GET_V001Response
     */
    public function setDISCOUNT(array $dISCOUNT = array())
    {
        // validation for constraint: array
        if ('' !== ($dISCOUNTArrayErrorMessage = self::validateDISCOUNTForArrayConstraintsFromSetDISCOUNT($dISCOUNT))) {
            throw new \InvalidArgumentException($dISCOUNTArrayErrorMessage, __LINE__);
        }
        $this->DISCOUNT = $dISCOUNT;
        return $this;
    }
    /**
     * Add item to DISCOUNT value
     * @throws \InvalidArgumentException
     * @param \StructType\DISCOUNT $item
     * @return \StructType\S_DISCOUNT_GET_V001Response
     */
    public function addToDISCOUNT(\StructType\DISCOUNT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DISCOUNT) {
            throw new \InvalidArgumentException(sprintf('The DISCOUNT property can only contain items of type \StructType\DISCOUNT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DISCOUNT[] = $item;
        return $this;
    }
}
