<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_CRITERIA_GET_V001Response StructType
 * @subpackage Structs
 */
class S_CRITERIA_GET_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The TrailCriteria
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TrailCriteria[]
     */
    public $TrailCriteria;
    /**
     * Constructor method for S_CRITERIA_GET_V001Response
     * @uses S_CRITERIA_GET_V001Response::setResult()
     * @uses S_CRITERIA_GET_V001Response::setTransactionID()
     * @uses S_CRITERIA_GET_V001Response::setTrailCriteria()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\TrailCriteria[] $trailCriteria
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $trailCriteria = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setTrailCriteria($trailCriteria);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_CRITERIA_GET_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_CRITERIA_GET_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get TrailCriteria value
     * @return \StructType\TrailCriteria[]|null
     */
    public function getTrailCriteria()
    {
        return $this->TrailCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setTrailCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrailCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrailCriteriaForArrayConstraintsFromSetTrailCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_CRITERIA_GET_V001ResponseTrailCriteriaItem) {
            // validation for constraint: itemType
            if (!$s_CRITERIA_GET_V001ResponseTrailCriteriaItem instanceof \StructType\TrailCriteria) {
                $invalidValues[] = is_object($s_CRITERIA_GET_V001ResponseTrailCriteriaItem) ? get_class($s_CRITERIA_GET_V001ResponseTrailCriteriaItem) : sprintf('%s(%s)', gettype($s_CRITERIA_GET_V001ResponseTrailCriteriaItem), var_export($s_CRITERIA_GET_V001ResponseTrailCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TrailCriteria property can only contain items of type \StructType\TrailCriteria, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TrailCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\TrailCriteria[] $trailCriteria
     * @return \StructType\S_CRITERIA_GET_V001Response
     */
    public function setTrailCriteria(array $trailCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($trailCriteriaArrayErrorMessage = self::validateTrailCriteriaForArrayConstraintsFromSetTrailCriteria($trailCriteria))) {
            throw new \InvalidArgumentException($trailCriteriaArrayErrorMessage, __LINE__);
        }
        $this->TrailCriteria = $trailCriteria;
        return $this;
    }
    /**
     * Add item to TrailCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\TrailCriteria $item
     * @return \StructType\S_CRITERIA_GET_V001Response
     */
    public function addToTrailCriteria(\StructType\TrailCriteria $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TrailCriteria) {
            throw new \InvalidArgumentException(sprintf('The TrailCriteria property can only contain items of type \StructType\TrailCriteria, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TrailCriteria[] = $item;
        return $this;
    }
}
