<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_BENCHMARK_V001Response StructType
 * @subpackage Structs
 */
class S_BENCHMARK_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The ProfileInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProfileInfo[]
     */
    public $ProfileInfo;
    /**
     * Constructor method for S_BENCHMARK_V001Response
     * @uses S_BENCHMARK_V001Response::setResult()
     * @uses S_BENCHMARK_V001Response::setTransactionID()
     * @uses S_BENCHMARK_V001Response::setProfileInfo()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\ProfileInfo[] $profileInfo
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $profileInfo = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setProfileInfo($profileInfo);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_BENCHMARK_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_BENCHMARK_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get ProfileInfo value
     * @return \StructType\ProfileInfo[]|null
     */
    public function getProfileInfo()
    {
        return $this->ProfileInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setProfileInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProfileInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProfileInfoForArrayConstraintsFromSetProfileInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_BENCHMARK_V001ResponseProfileInfoItem) {
            // validation for constraint: itemType
            if (!$s_BENCHMARK_V001ResponseProfileInfoItem instanceof \StructType\ProfileInfo) {
                $invalidValues[] = is_object($s_BENCHMARK_V001ResponseProfileInfoItem) ? get_class($s_BENCHMARK_V001ResponseProfileInfoItem) : sprintf('%s(%s)', gettype($s_BENCHMARK_V001ResponseProfileInfoItem), var_export($s_BENCHMARK_V001ResponseProfileInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProfileInfo property can only contain items of type \StructType\ProfileInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProfileInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ProfileInfo[] $profileInfo
     * @return \StructType\S_BENCHMARK_V001Response
     */
    public function setProfileInfo(array $profileInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($profileInfoArrayErrorMessage = self::validateProfileInfoForArrayConstraintsFromSetProfileInfo($profileInfo))) {
            throw new \InvalidArgumentException($profileInfoArrayErrorMessage, __LINE__);
        }
        $this->ProfileInfo = $profileInfo;
        return $this;
    }
    /**
     * Add item to ProfileInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ProfileInfo $item
     * @return \StructType\S_BENCHMARK_V001Response
     */
    public function addToProfileInfo(\StructType\ProfileInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProfileInfo) {
            throw new \InvalidArgumentException(sprintf('The ProfileInfo property can only contain items of type \StructType\ProfileInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProfileInfo[] = $item;
        return $this;
    }
}
