<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ACCOUNT_SETTLE_V001Response StructType
 * @subpackage Structs
 */
class S_ACCOUNT_SETTLE_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The INVOICE
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\INVOICE[]
     */
    public $INVOICE;
    /**
     * Constructor method for S_ACCOUNT_SETTLE_V001Response
     * @uses S_ACCOUNT_SETTLE_V001Response::setResult()
     * @uses S_ACCOUNT_SETTLE_V001Response::setTransactionID()
     * @uses S_ACCOUNT_SETTLE_V001Response::setINVOICE()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\INVOICE[] $iNVOICE
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $iNVOICE = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setINVOICE($iNVOICE);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_ACCOUNT_SETTLE_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ACCOUNT_SETTLE_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get INVOICE value
     * @return \StructType\INVOICE[]|null
     */
    public function getINVOICE()
    {
        return $this->INVOICE;
    }
    /**
     * This method is responsible for validating the values passed to the setINVOICE method
     * This method is willingly generated in order to preserve the one-line inline validation within the setINVOICE method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateINVOICEForArrayConstraintsFromSetINVOICE(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_ACCOUNT_SETTLE_V001ResponseINVOICEItem) {
            // validation for constraint: itemType
            if (!$s_ACCOUNT_SETTLE_V001ResponseINVOICEItem instanceof \StructType\INVOICE) {
                $invalidValues[] = is_object($s_ACCOUNT_SETTLE_V001ResponseINVOICEItem) ? get_class($s_ACCOUNT_SETTLE_V001ResponseINVOICEItem) : sprintf('%s(%s)', gettype($s_ACCOUNT_SETTLE_V001ResponseINVOICEItem), var_export($s_ACCOUNT_SETTLE_V001ResponseINVOICEItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The INVOICE property can only contain items of type \StructType\INVOICE, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE[] $iNVOICE
     * @return \StructType\S_ACCOUNT_SETTLE_V001Response
     */
    public function setINVOICE(array $iNVOICE = array())
    {
        // validation for constraint: array
        if ('' !== ($iNVOICEArrayErrorMessage = self::validateINVOICEForArrayConstraintsFromSetINVOICE($iNVOICE))) {
            throw new \InvalidArgumentException($iNVOICEArrayErrorMessage, __LINE__);
        }
        $this->INVOICE = $iNVOICE;
        return $this;
    }
    /**
     * Add item to INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE $item
     * @return \StructType\S_ACCOUNT_SETTLE_V001Response
     */
    public function addToINVOICE(\StructType\INVOICE $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\INVOICE) {
            throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of type \StructType\INVOICE, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->INVOICE[] = $item;
        return $this;
    }
}
