<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoominglistSearch StructType
 * @subpackage Structs
 */
class RoominglistSearch extends AbstractStructBase
{
    /**
     * The ROOMINGLIST_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ROOMINGLIST_OBJID;
    /**
     * Constructor method for RoominglistSearch
     * @uses RoominglistSearch::setROOMINGLIST_OBJID()
     * @param string $rOOMINGLIST_OBJID
     */
    public function __construct($rOOMINGLIST_OBJID = null)
    {
        $this
            ->setROOMINGLIST_OBJID($rOOMINGLIST_OBJID);
    }
    /**
     * Get ROOMINGLIST_OBJID value
     * @return string
     */
    public function getROOMINGLIST_OBJID()
    {
        return $this->{'ROOMINGLIST-OBJID'};
    }
    /**
     * Set ROOMINGLIST_OBJID value
     * @param string $rOOMINGLIST_OBJID
     * @return \StructType\RoominglistSearch
     */
    public function setROOMINGLIST_OBJID($rOOMINGLIST_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rOOMINGLIST_OBJID) && !is_string($rOOMINGLIST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOOMINGLIST_OBJID, true), gettype($rOOMINGLIST_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rOOMINGLIST_OBJID) && !preg_match('/([0-9])*/', $rOOMINGLIST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rOOMINGLIST_OBJID, true)), __LINE__);
        }
        $this->ROOMINGLIST_OBJID = $this->{'ROOMINGLIST-OBJID'} = $rOOMINGLIST_OBJID;
        return $this;
    }
}
