<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomStateSearchAndModify StructType
 * @subpackage Structs
 */
class RoomStateSearchAndModify extends AbstractStructBase
{
    /**
     * The ROOM_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ROOM_OBJID;
    /**
     * The Room
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Room
     */
    public $Room;
    /**
     * Constructor method for RoomStateSearchAndModify
     * @uses RoomStateSearchAndModify::setROOM_OBJID()
     * @uses RoomStateSearchAndModify::setRoom()
     * @param string $rOOM_OBJID
     * @param \StructType\Room $room
     */
    public function __construct($rOOM_OBJID = null, \StructType\Room $room = null)
    {
        $this
            ->setROOM_OBJID($rOOM_OBJID)
            ->setRoom($room);
    }
    /**
     * Get ROOM_OBJID value
     * @return string
     */
    public function getROOM_OBJID()
    {
        return $this->{'ROOM-OBJID'};
    }
    /**
     * Set ROOM_OBJID value
     * @param string $rOOM_OBJID
     * @return \StructType\RoomStateSearchAndModify
     */
    public function setROOM_OBJID($rOOM_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rOOM_OBJID) && !is_string($rOOM_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOOM_OBJID, true), gettype($rOOM_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rOOM_OBJID) && !preg_match('/([0-9])*/', $rOOM_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rOOM_OBJID, true)), __LINE__);
        }
        $this->ROOM_OBJID = $this->{'ROOM-OBJID'} = $rOOM_OBJID;
        return $this;
    }
    /**
     * Get Room value
     * @return \StructType\Room
     */
    public function getRoom()
    {
        return $this->Room;
    }
    /**
     * Set Room value
     * @param \StructType\Room $room
     * @return \StructType\RoomStateSearchAndModify
     */
    public function setRoom(\StructType\Room $room = null)
    {
        $this->Room = $room;
        return $this;
    }
}
