<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for roomState StructType
 * @subpackage Structs
 */
class RoomState extends AbstractStructBase
{
    /**
     * The ROOM_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ROOM_OBJID;
    /**
     * The room
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $room;
    /**
     * The floor
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $floor;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $category;
    /**
     * The housekeeping
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $housekeeping;
    /**
     * The maintenance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $maintenance;
    /**
     * The bookingdata
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Bookingdata[]
     */
    public $bookingdata;
    /**
     * Constructor method for roomState
     * @uses RoomState::setROOM_OBJID()
     * @uses RoomState::setRoom()
     * @uses RoomState::setFloor()
     * @uses RoomState::setStatus()
     * @uses RoomState::setCategory()
     * @uses RoomState::setHousekeeping()
     * @uses RoomState::setMaintenance()
     * @uses RoomState::setBookingdata()
     * @param string $rOOM_OBJID
     * @param string $room
     * @param string $floor
     * @param string $status
     * @param string $category
     * @param string $housekeeping
     * @param string $maintenance
     * @param \StructType\Bookingdata[] $bookingdata
     */
    public function __construct($rOOM_OBJID = null, $room = null, $floor = null, $status = null, $category = null, $housekeeping = null, $maintenance = null, array $bookingdata = array())
    {
        $this
            ->setROOM_OBJID($rOOM_OBJID)
            ->setRoom($room)
            ->setFloor($floor)
            ->setStatus($status)
            ->setCategory($category)
            ->setHousekeeping($housekeeping)
            ->setMaintenance($maintenance)
            ->setBookingdata($bookingdata);
    }
    /**
     * Get ROOM_OBJID value
     * @return string
     */
    public function getROOM_OBJID()
    {
        return $this->{'ROOM-OBJID'};
    }
    /**
     * Set ROOM_OBJID value
     * @param string $rOOM_OBJID
     * @return \StructType\RoomState
     */
    public function setROOM_OBJID($rOOM_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rOOM_OBJID) && !is_string($rOOM_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOOM_OBJID, true), gettype($rOOM_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rOOM_OBJID) && !preg_match('/([0-9])*/', $rOOM_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rOOM_OBJID, true)), __LINE__);
        }
        $this->ROOM_OBJID = $this->{'ROOM-OBJID'} = $rOOM_OBJID;
        return $this;
    }
    /**
     * Get room value
     * @return string
     */
    public function getRoom()
    {
        return $this->room;
    }
    /**
     * Set room value
     * @param string $room
     * @return \StructType\RoomState
     */
    public function setRoom($room = null)
    {
        // validation for constraint: string
        if (!is_null($room) && !is_string($room)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($room, true), gettype($room)), __LINE__);
        }
        $this->room = $room;
        return $this;
    }
    /**
     * Get floor value
     * @return string
     */
    public function getFloor()
    {
        return $this->floor;
    }
    /**
     * Set floor value
     * @param string $floor
     * @return \StructType\RoomState
     */
    public function setFloor($floor = null)
    {
        // validation for constraint: string
        if (!is_null($floor) && !is_string($floor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($floor, true), gettype($floor)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($floor) && mb_strlen($floor) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($floor)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($floor) && mb_strlen($floor) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($floor)), __LINE__);
        }
        $this->floor = $floor;
        return $this;
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\RoomState
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get category value
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\RoomState
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get housekeeping value
     * @return string
     */
    public function getHousekeeping()
    {
        return $this->housekeeping;
    }
    /**
     * Set housekeeping value
     * @param string $housekeeping
     * @return \StructType\RoomState
     */
    public function setHousekeeping($housekeeping = null)
    {
        // validation for constraint: string
        if (!is_null($housekeeping) && !is_string($housekeeping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($housekeeping, true), gettype($housekeeping)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($housekeeping) && mb_strlen($housekeeping) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($housekeeping)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($housekeeping) && mb_strlen($housekeeping) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($housekeeping)), __LINE__);
        }
        $this->housekeeping = $housekeeping;
        return $this;
    }
    /**
     * Get maintenance value
     * @return string
     */
    public function getMaintenance()
    {
        return $this->maintenance;
    }
    /**
     * Set maintenance value
     * @param string $maintenance
     * @return \StructType\RoomState
     */
    public function setMaintenance($maintenance = null)
    {
        // validation for constraint: string
        if (!is_null($maintenance) && !is_string($maintenance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maintenance, true), gettype($maintenance)), __LINE__);
        }
        $this->maintenance = $maintenance;
        return $this;
    }
    /**
     * Get bookingdata value
     * @return \StructType\Bookingdata[]|null
     */
    public function getBookingdata()
    {
        return $this->bookingdata;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingdata method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingdata method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingdataForArrayConstraintsFromSetBookingdata(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomStateBookingdataItem) {
            // validation for constraint: itemType
            if (!$roomStateBookingdataItem instanceof \StructType\Bookingdata) {
                $invalidValues[] = is_object($roomStateBookingdataItem) ? get_class($roomStateBookingdataItem) : sprintf('%s(%s)', gettype($roomStateBookingdataItem), var_export($roomStateBookingdataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bookingdata property can only contain items of type \StructType\Bookingdata, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bookingdata value
     * @throws \InvalidArgumentException
     * @param \StructType\Bookingdata[] $bookingdata
     * @return \StructType\RoomState
     */
    public function setBookingdata(array $bookingdata = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingdataArrayErrorMessage = self::validateBookingdataForArrayConstraintsFromSetBookingdata($bookingdata))) {
            throw new \InvalidArgumentException($bookingdataArrayErrorMessage, __LINE__);
        }
        $this->bookingdata = $bookingdata;
        return $this;
    }
    /**
     * Add item to bookingdata value
     * @throws \InvalidArgumentException
     * @param \StructType\Bookingdata $item
     * @return \StructType\RoomState
     */
    public function addToBookingdata(\StructType\Bookingdata $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Bookingdata) {
            throw new \InvalidArgumentException(sprintf('The bookingdata property can only contain items of type \StructType\Bookingdata, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bookingdata[] = $item;
        return $this;
    }
}
