<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomReservation StructType
 * @subpackage Structs
 */
class RoomReservation extends AbstractStructBase
{
    /**
     * The ROOM_RESERVATION_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ROOM_RESERVATION_OBJID;
    /**
     * The ServiceReservation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ServiceReservation[]
     */
    public $ServiceReservation;
    /**
     * The EquipmentReservation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EquipmentReservation[]
     */
    public $EquipmentReservation;
    /**
     * Constructor method for RoomReservation
     * @uses RoomReservation::setROOM_RESERVATION_OBJID()
     * @uses RoomReservation::setServiceReservation()
     * @uses RoomReservation::setEquipmentReservation()
     * @param string $rOOM_RESERVATION_OBJID
     * @param \StructType\ServiceReservation[] $serviceReservation
     * @param \StructType\EquipmentReservation[] $equipmentReservation
     */
    public function __construct($rOOM_RESERVATION_OBJID = null, array $serviceReservation = array(), array $equipmentReservation = array())
    {
        $this
            ->setROOM_RESERVATION_OBJID($rOOM_RESERVATION_OBJID)
            ->setServiceReservation($serviceReservation)
            ->setEquipmentReservation($equipmentReservation);
    }
    /**
     * Get ROOM_RESERVATION_OBJID value
     * @return string
     */
    public function getROOM_RESERVATION_OBJID()
    {
        return $this->{'ROOM-RESERVATION-OBJID'};
    }
    /**
     * Set ROOM_RESERVATION_OBJID value
     * @param string $rOOM_RESERVATION_OBJID
     * @return \StructType\RoomReservation
     */
    public function setROOM_RESERVATION_OBJID($rOOM_RESERVATION_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rOOM_RESERVATION_OBJID) && !is_string($rOOM_RESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOOM_RESERVATION_OBJID, true), gettype($rOOM_RESERVATION_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rOOM_RESERVATION_OBJID) && !preg_match('/([0-9])*/', $rOOM_RESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rOOM_RESERVATION_OBJID, true)), __LINE__);
        }
        $this->ROOM_RESERVATION_OBJID = $this->{'ROOM-RESERVATION-OBJID'} = $rOOM_RESERVATION_OBJID;
        return $this;
    }
    /**
     * Get ServiceReservation value
     * @return \StructType\ServiceReservation[]|null
     */
    public function getServiceReservation()
    {
        return $this->ServiceReservation;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceReservation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceReservationForArrayConstraintsFromSetServiceReservation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomReservationServiceReservationItem) {
            // validation for constraint: itemType
            if (!$roomReservationServiceReservationItem instanceof \StructType\ServiceReservation) {
                $invalidValues[] = is_object($roomReservationServiceReservationItem) ? get_class($roomReservationServiceReservationItem) : sprintf('%s(%s)', gettype($roomReservationServiceReservationItem), var_export($roomReservationServiceReservationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceReservation property can only contain items of type \StructType\ServiceReservation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceReservation[] $serviceReservation
     * @return \StructType\RoomReservation
     */
    public function setServiceReservation(array $serviceReservation = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceReservationArrayErrorMessage = self::validateServiceReservationForArrayConstraintsFromSetServiceReservation($serviceReservation))) {
            throw new \InvalidArgumentException($serviceReservationArrayErrorMessage, __LINE__);
        }
        $this->ServiceReservation = $serviceReservation;
        return $this;
    }
    /**
     * Add item to ServiceReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceReservation $item
     * @return \StructType\RoomReservation
     */
    public function addToServiceReservation(\StructType\ServiceReservation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceReservation) {
            throw new \InvalidArgumentException(sprintf('The ServiceReservation property can only contain items of type \StructType\ServiceReservation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceReservation[] = $item;
        return $this;
    }
    /**
     * Get EquipmentReservation value
     * @return \StructType\EquipmentReservation[]|null
     */
    public function getEquipmentReservation()
    {
        return $this->EquipmentReservation;
    }
    /**
     * This method is responsible for validating the values passed to the setEquipmentReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEquipmentReservation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEquipmentReservationForArrayConstraintsFromSetEquipmentReservation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomReservationEquipmentReservationItem) {
            // validation for constraint: itemType
            if (!$roomReservationEquipmentReservationItem instanceof \StructType\EquipmentReservation) {
                $invalidValues[] = is_object($roomReservationEquipmentReservationItem) ? get_class($roomReservationEquipmentReservationItem) : sprintf('%s(%s)', gettype($roomReservationEquipmentReservationItem), var_export($roomReservationEquipmentReservationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EquipmentReservation property can only contain items of type \StructType\EquipmentReservation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EquipmentReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\EquipmentReservation[] $equipmentReservation
     * @return \StructType\RoomReservation
     */
    public function setEquipmentReservation(array $equipmentReservation = array())
    {
        // validation for constraint: array
        if ('' !== ($equipmentReservationArrayErrorMessage = self::validateEquipmentReservationForArrayConstraintsFromSetEquipmentReservation($equipmentReservation))) {
            throw new \InvalidArgumentException($equipmentReservationArrayErrorMessage, __LINE__);
        }
        $this->EquipmentReservation = $equipmentReservation;
        return $this;
    }
    /**
     * Add item to EquipmentReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\EquipmentReservation $item
     * @return \StructType\RoomReservation
     */
    public function addToEquipmentReservation(\StructType\EquipmentReservation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EquipmentReservation) {
            throw new \InvalidArgumentException(sprintf('The EquipmentReservation property can only contain items of type \StructType\EquipmentReservation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EquipmentReservation[] = $item;
        return $this;
    }
}
