<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomRes StructType
 * @subpackage Structs
 */
class RoomRes extends AbstractStructBase
{
    /**
     * The RoomServiceRes
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RoomServiceRes[]
     */
    public $RoomServiceRes;
    /**
     * Constructor method for RoomRes
     * @uses RoomRes::setRoomServiceRes()
     * @param \StructType\RoomServiceRes[] $roomServiceRes
     */
    public function __construct(array $roomServiceRes = array())
    {
        $this
            ->setRoomServiceRes($roomServiceRes);
    }
    /**
     * Get RoomServiceRes value
     * @return \StructType\RoomServiceRes[]|null
     */
    public function getRoomServiceRes()
    {
        return $this->RoomServiceRes;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomServiceRes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomServiceRes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomServiceResForArrayConstraintsFromSetRoomServiceRes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomResRoomServiceResItem) {
            // validation for constraint: itemType
            if (!$roomResRoomServiceResItem instanceof \StructType\RoomServiceRes) {
                $invalidValues[] = is_object($roomResRoomServiceResItem) ? get_class($roomResRoomServiceResItem) : sprintf('%s(%s)', gettype($roomResRoomServiceResItem), var_export($roomResRoomServiceResItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomServiceRes property can only contain items of type \StructType\RoomServiceRes, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomServiceRes value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomServiceRes[] $roomServiceRes
     * @return \StructType\RoomRes
     */
    public function setRoomServiceRes(array $roomServiceRes = array())
    {
        // validation for constraint: array
        if ('' !== ($roomServiceResArrayErrorMessage = self::validateRoomServiceResForArrayConstraintsFromSetRoomServiceRes($roomServiceRes))) {
            throw new \InvalidArgumentException($roomServiceResArrayErrorMessage, __LINE__);
        }
        $this->RoomServiceRes = $roomServiceRes;
        return $this;
    }
    /**
     * Add item to RoomServiceRes value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomServiceRes $item
     * @return \StructType\RoomRes
     */
    public function addToRoomServiceRes(\StructType\RoomServiceRes $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomServiceRes) {
            throw new \InvalidArgumentException(sprintf('The RoomServiceRes property can only contain items of type \StructType\RoomServiceRes, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RoomServiceRes[] = $item;
        return $this;
    }
}
