<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomOOO StructType
 * @subpackage Structs
 */
class RoomOOO extends AbstractStructBase
{
    /**
     * The ROOM_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ROOM_OBJID;
    /**
     * The ROOMBOOKING_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ROOMBOOKING_OBJID;
    /**
     * The room
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $room;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $category;
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The lockingreason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $lockingreason;
    /**
     * The roomlocation
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $roomlocation;
    /**
     * The housekeeping
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $housekeeping;
    /**
     * The maintenance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $maintenance;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $phone;
    /**
     * The beds
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $beds;
    /**
     * The extrabeds
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $extrabeds;
    /**
     * The building
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $building;
    /**
     * Constructor method for RoomOOO
     * @uses RoomOOO::setROOM_OBJID()
     * @uses RoomOOO::setROOMBOOKING_OBJID()
     * @uses RoomOOO::setRoom()
     * @uses RoomOOO::setCategory()
     * @uses RoomOOO::setDatefrom()
     * @uses RoomOOO::setDateto()
     * @uses RoomOOO::setLockingreason()
     * @uses RoomOOO::setRoomlocation()
     * @uses RoomOOO::setHousekeeping()
     * @uses RoomOOO::setMaintenance()
     * @uses RoomOOO::setPhone()
     * @uses RoomOOO::setBeds()
     * @uses RoomOOO::setExtrabeds()
     * @uses RoomOOO::setBuilding()
     * @param string $rOOM_OBJID
     * @param string $rOOMBOOKING_OBJID
     * @param string $room
     * @param string $category
     * @param string $datefrom
     * @param string $dateto
     * @param string $lockingreason
     * @param string $roomlocation
     * @param string $housekeeping
     * @param string $maintenance
     * @param string $phone
     * @param string $beds
     * @param string $extrabeds
     * @param string $building
     */
    public function __construct($rOOM_OBJID = null, $rOOMBOOKING_OBJID = null, $room = null, $category = null, $datefrom = null, $dateto = null, $lockingreason = null, $roomlocation = null, $housekeeping = null, $maintenance = null, $phone = null, $beds = null, $extrabeds = null, $building = null)
    {
        $this
            ->setROOM_OBJID($rOOM_OBJID)
            ->setROOMBOOKING_OBJID($rOOMBOOKING_OBJID)
            ->setRoom($room)
            ->setCategory($category)
            ->setDatefrom($datefrom)
            ->setDateto($dateto)
            ->setLockingreason($lockingreason)
            ->setRoomlocation($roomlocation)
            ->setHousekeeping($housekeeping)
            ->setMaintenance($maintenance)
            ->setPhone($phone)
            ->setBeds($beds)
            ->setExtrabeds($extrabeds)
            ->setBuilding($building);
    }
    /**
     * Get ROOM_OBJID value
     * @return string
     */
    public function getROOM_OBJID()
    {
        return $this->{'ROOM-OBJID'};
    }
    /**
     * Set ROOM_OBJID value
     * @param string $rOOM_OBJID
     * @return \StructType\RoomOOO
     */
    public function setROOM_OBJID($rOOM_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rOOM_OBJID) && !is_string($rOOM_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOOM_OBJID, true), gettype($rOOM_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rOOM_OBJID) && !preg_match('/([0-9])*/', $rOOM_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rOOM_OBJID, true)), __LINE__);
        }
        $this->ROOM_OBJID = $this->{'ROOM-OBJID'} = $rOOM_OBJID;
        return $this;
    }
    /**
     * Get ROOMBOOKING_OBJID value
     * @return string
     */
    public function getROOMBOOKING_OBJID()
    {
        return $this->{'ROOMBOOKING-OBJID'};
    }
    /**
     * Set ROOMBOOKING_OBJID value
     * @param string $rOOMBOOKING_OBJID
     * @return \StructType\RoomOOO
     */
    public function setROOMBOOKING_OBJID($rOOMBOOKING_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rOOMBOOKING_OBJID) && !is_string($rOOMBOOKING_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOOMBOOKING_OBJID, true), gettype($rOOMBOOKING_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rOOMBOOKING_OBJID) && !preg_match('/([0-9])*/', $rOOMBOOKING_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rOOMBOOKING_OBJID, true)), __LINE__);
        }
        $this->ROOMBOOKING_OBJID = $this->{'ROOMBOOKING-OBJID'} = $rOOMBOOKING_OBJID;
        return $this;
    }
    /**
     * Get room value
     * @return string
     */
    public function getRoom()
    {
        return $this->room;
    }
    /**
     * Set room value
     * @param string $room
     * @return \StructType\RoomOOO
     */
    public function setRoom($room = null)
    {
        // validation for constraint: string
        if (!is_null($room) && !is_string($room)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($room, true), gettype($room)), __LINE__);
        }
        $this->room = $room;
        return $this;
    }
    /**
     * Get category value
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\RoomOOO
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get datefrom value
     * @return string
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\RoomOOO
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get dateto value
     * @return string
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\RoomOOO
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get lockingreason value
     * @return string
     */
    public function getLockingreason()
    {
        return $this->lockingreason;
    }
    /**
     * Set lockingreason value
     * @param string $lockingreason
     * @return \StructType\RoomOOO
     */
    public function setLockingreason($lockingreason = null)
    {
        // validation for constraint: string
        if (!is_null($lockingreason) && !is_string($lockingreason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockingreason, true), gettype($lockingreason)), __LINE__);
        }
        $this->lockingreason = $lockingreason;
        return $this;
    }
    /**
     * Get roomlocation value
     * @return string
     */
    public function getRoomlocation()
    {
        return $this->roomlocation;
    }
    /**
     * Set roomlocation value
     * @param string $roomlocation
     * @return \StructType\RoomOOO
     */
    public function setRoomlocation($roomlocation = null)
    {
        // validation for constraint: string
        if (!is_null($roomlocation) && !is_string($roomlocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomlocation, true), gettype($roomlocation)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($roomlocation) && mb_strlen($roomlocation) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($roomlocation)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($roomlocation) && mb_strlen($roomlocation) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($roomlocation)), __LINE__);
        }
        $this->roomlocation = $roomlocation;
        return $this;
    }
    /**
     * Get housekeeping value
     * @return string
     */
    public function getHousekeeping()
    {
        return $this->housekeeping;
    }
    /**
     * Set housekeeping value
     * @param string $housekeeping
     * @return \StructType\RoomOOO
     */
    public function setHousekeeping($housekeeping = null)
    {
        // validation for constraint: string
        if (!is_null($housekeeping) && !is_string($housekeeping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($housekeeping, true), gettype($housekeeping)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($housekeeping) && mb_strlen($housekeeping) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($housekeeping)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($housekeeping) && mb_strlen($housekeeping) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($housekeeping)), __LINE__);
        }
        $this->housekeeping = $housekeeping;
        return $this;
    }
    /**
     * Get maintenance value
     * @return string
     */
    public function getMaintenance()
    {
        return $this->maintenance;
    }
    /**
     * Set maintenance value
     * @param string $maintenance
     * @return \StructType\RoomOOO
     */
    public function setMaintenance($maintenance = null)
    {
        // validation for constraint: string
        if (!is_null($maintenance) && !is_string($maintenance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maintenance, true), gettype($maintenance)), __LINE__);
        }
        $this->maintenance = $maintenance;
        return $this;
    }
    /**
     * Get phone value
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\RoomOOO
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get beds value
     * @return string
     */
    public function getBeds()
    {
        return $this->beds;
    }
    /**
     * Set beds value
     * @param string $beds
     * @return \StructType\RoomOOO
     */
    public function setBeds($beds = null)
    {
        // validation for constraint: string
        if (!is_null($beds) && !is_string($beds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beds, true), gettype($beds)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($beds) && !preg_match('/([-+]){0,1}([0-9])*/', $beds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($beds, true)), __LINE__);
        }
        $this->beds = $beds;
        return $this;
    }
    /**
     * Get extrabeds value
     * @return string
     */
    public function getExtrabeds()
    {
        return $this->extrabeds;
    }
    /**
     * Set extrabeds value
     * @param string $extrabeds
     * @return \StructType\RoomOOO
     */
    public function setExtrabeds($extrabeds = null)
    {
        // validation for constraint: string
        if (!is_null($extrabeds) && !is_string($extrabeds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extrabeds, true), gettype($extrabeds)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($extrabeds) && !preg_match('/([-+]){0,1}([0-9])*/', $extrabeds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($extrabeds, true)), __LINE__);
        }
        $this->extrabeds = $extrabeds;
        return $this;
    }
    /**
     * Get building value
     * @return string
     */
    public function getBuilding()
    {
        return $this->building;
    }
    /**
     * Set building value
     * @param string $building
     * @return \StructType\RoomOOO
     */
    public function setBuilding($building = null)
    {
        // validation for constraint: string
        if (!is_null($building) && !is_string($building)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($building, true), gettype($building)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($building) && mb_strlen($building) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($building)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($building) && mb_strlen($building) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($building)), __LINE__);
        }
        $this->building = $building;
        return $this;
    }
}
