<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomMaintenanceStatus StructType
 * @subpackage Structs
 */
class RoomMaintenanceStatus extends AbstractStructBase
{
    /**
     * The ROOMMAINTENANCESTATUS_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ROOMMAINTENANCESTATUS_OBJID;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $date;
    /**
     * The time
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $time;
    /**
     * The staffno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 8
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $staffno;
    /**
     * The user
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $user;
    /**
     * The maintenancestatus
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $maintenancestatus;
    /**
     * The priority
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $priority;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 86
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $comment;
    /**
     * The modificationoperator
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $modificationoperator;
    /**
     * The modificationdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $modificationdate;
    /**
     * The modificationtime
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $modificationtime;
    /**
     * The isdone
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $isdone;
    /**
     * The hasimages
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hasimages;
    /**
     * The ImageManager
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ImageManager[]
     */
    public $ImageManager;
    /**
     * Constructor method for RoomMaintenanceStatus
     * @uses RoomMaintenanceStatus::setROOMMAINTENANCESTATUS_OBJID()
     * @uses RoomMaintenanceStatus::setDate()
     * @uses RoomMaintenanceStatus::setTime()
     * @uses RoomMaintenanceStatus::setStaffno()
     * @uses RoomMaintenanceStatus::setUser()
     * @uses RoomMaintenanceStatus::setMaintenancestatus()
     * @uses RoomMaintenanceStatus::setPriority()
     * @uses RoomMaintenanceStatus::setComment()
     * @uses RoomMaintenanceStatus::setModificationoperator()
     * @uses RoomMaintenanceStatus::setModificationdate()
     * @uses RoomMaintenanceStatus::setModificationtime()
     * @uses RoomMaintenanceStatus::setIsdone()
     * @uses RoomMaintenanceStatus::setHasimages()
     * @uses RoomMaintenanceStatus::setImageManager()
     * @param string $rOOMMAINTENANCESTATUS_OBJID
     * @param string $date
     * @param string $time
     * @param string $staffno
     * @param string $user
     * @param string $maintenancestatus
     * @param string $priority
     * @param string $comment
     * @param string $modificationoperator
     * @param string $modificationdate
     * @param string $modificationtime
     * @param string $isdone
     * @param string $hasimages
     * @param \StructType\ImageManager[] $imageManager
     */
    public function __construct($rOOMMAINTENANCESTATUS_OBJID = null, $date = null, $time = null, $staffno = null, $user = null, $maintenancestatus = null, $priority = null, $comment = null, $modificationoperator = null, $modificationdate = null, $modificationtime = null, $isdone = null, $hasimages = null, array $imageManager = array())
    {
        $this
            ->setROOMMAINTENANCESTATUS_OBJID($rOOMMAINTENANCESTATUS_OBJID)
            ->setDate($date)
            ->setTime($time)
            ->setStaffno($staffno)
            ->setUser($user)
            ->setMaintenancestatus($maintenancestatus)
            ->setPriority($priority)
            ->setComment($comment)
            ->setModificationoperator($modificationoperator)
            ->setModificationdate($modificationdate)
            ->setModificationtime($modificationtime)
            ->setIsdone($isdone)
            ->setHasimages($hasimages)
            ->setImageManager($imageManager);
    }
    /**
     * Get ROOMMAINTENANCESTATUS_OBJID value
     * @return string
     */
    public function getROOMMAINTENANCESTATUS_OBJID()
    {
        return $this->{'ROOMMAINTENANCESTATUS-OBJID'};
    }
    /**
     * Set ROOMMAINTENANCESTATUS_OBJID value
     * @param string $rOOMMAINTENANCESTATUS_OBJID
     * @return \StructType\RoomMaintenanceStatus
     */
    public function setROOMMAINTENANCESTATUS_OBJID($rOOMMAINTENANCESTATUS_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rOOMMAINTENANCESTATUS_OBJID) && !is_string($rOOMMAINTENANCESTATUS_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOOMMAINTENANCESTATUS_OBJID, true), gettype($rOOMMAINTENANCESTATUS_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rOOMMAINTENANCESTATUS_OBJID) && !preg_match('/([0-9])*/', $rOOMMAINTENANCESTATUS_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rOOMMAINTENANCESTATUS_OBJID, true)), __LINE__);
        }
        $this->ROOMMAINTENANCESTATUS_OBJID = $this->{'ROOMMAINTENANCESTATUS-OBJID'} = $rOOMMAINTENANCESTATUS_OBJID;
        return $this;
    }
    /**
     * Get date value
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\RoomMaintenanceStatus
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($date) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($date, true)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get time value
     * @return string
     */
    public function getTime()
    {
        return $this->time;
    }
    /**
     * Set time value
     * @param string $time
     * @return \StructType\RoomMaintenanceStatus
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time, true), gettype($time)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($time) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($time, true)), __LINE__);
        }
        $this->time = $time;
        return $this;
    }
    /**
     * Get staffno value
     * @return string
     */
    public function getStaffno()
    {
        return $this->staffno;
    }
    /**
     * Set staffno value
     * @param string $staffno
     * @return \StructType\RoomMaintenanceStatus
     */
    public function setStaffno($staffno = null)
    {
        // validation for constraint: string
        if (!is_null($staffno) && !is_string($staffno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($staffno, true), gettype($staffno)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($staffno) && mb_strlen($staffno) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($staffno)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($staffno) && mb_strlen($staffno) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($staffno)), __LINE__);
        }
        $this->staffno = $staffno;
        return $this;
    }
    /**
     * Get user value
     * @return string
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param string $user
     * @return \StructType\RoomMaintenanceStatus
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get maintenancestatus value
     * @return string
     */
    public function getMaintenancestatus()
    {
        return $this->maintenancestatus;
    }
    /**
     * Set maintenancestatus value
     * @param string $maintenancestatus
     * @return \StructType\RoomMaintenanceStatus
     */
    public function setMaintenancestatus($maintenancestatus = null)
    {
        // validation for constraint: string
        if (!is_null($maintenancestatus) && !is_string($maintenancestatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maintenancestatus, true), gettype($maintenancestatus)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($maintenancestatus) && mb_strlen($maintenancestatus) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($maintenancestatus)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($maintenancestatus) && mb_strlen($maintenancestatus) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($maintenancestatus)), __LINE__);
        }
        $this->maintenancestatus = $maintenancestatus;
        return $this;
    }
    /**
     * Get priority value
     * @return string
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @param string $priority
     * @return \StructType\RoomMaintenanceStatus
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: string
        if (!is_null($priority) && !is_string($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($priority) && !preg_match('/([-+]){0,1}([0-9])*/', $priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($priority, true)), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get comment value
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\RoomMaintenanceStatus
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        // validation for constraint: maxLength(86)
        if (!is_null($comment) && mb_strlen($comment) > 86) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 86', mb_strlen($comment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($comment) && mb_strlen($comment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get modificationoperator value
     * @return string
     */
    public function getModificationoperator()
    {
        return $this->modificationoperator;
    }
    /**
     * Set modificationoperator value
     * @param string $modificationoperator
     * @return \StructType\RoomMaintenanceStatus
     */
    public function setModificationoperator($modificationoperator = null)
    {
        // validation for constraint: string
        if (!is_null($modificationoperator) && !is_string($modificationoperator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modificationoperator, true), gettype($modificationoperator)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($modificationoperator) && mb_strlen($modificationoperator) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($modificationoperator)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($modificationoperator) && mb_strlen($modificationoperator) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($modificationoperator)), __LINE__);
        }
        $this->modificationoperator = $modificationoperator;
        return $this;
    }
    /**
     * Get modificationdate value
     * @return string
     */
    public function getModificationdate()
    {
        return $this->modificationdate;
    }
    /**
     * Set modificationdate value
     * @param string $modificationdate
     * @return \StructType\RoomMaintenanceStatus
     */
    public function setModificationdate($modificationdate = null)
    {
        // validation for constraint: string
        if (!is_null($modificationdate) && !is_string($modificationdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modificationdate, true), gettype($modificationdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($modificationdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $modificationdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($modificationdate, true)), __LINE__);
        }
        $this->modificationdate = $modificationdate;
        return $this;
    }
    /**
     * Get modificationtime value
     * @return string
     */
    public function getModificationtime()
    {
        return $this->modificationtime;
    }
    /**
     * Set modificationtime value
     * @param string $modificationtime
     * @return \StructType\RoomMaintenanceStatus
     */
    public function setModificationtime($modificationtime = null)
    {
        // validation for constraint: string
        if (!is_null($modificationtime) && !is_string($modificationtime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modificationtime, true), gettype($modificationtime)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($modificationtime) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $modificationtime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($modificationtime, true)), __LINE__);
        }
        $this->modificationtime = $modificationtime;
        return $this;
    }
    /**
     * Get isdone value
     * @return string
     */
    public function getIsdone()
    {
        return $this->isdone;
    }
    /**
     * Set isdone value
     * @param string $isdone
     * @return \StructType\RoomMaintenanceStatus
     */
    public function setIsdone($isdone = null)
    {
        // validation for constraint: string
        if (!is_null($isdone) && !is_string($isdone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isdone, true), gettype($isdone)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($isdone) && !preg_match('/([-+]){0,1}([0-9])*/', $isdone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($isdone, true)), __LINE__);
        }
        $this->isdone = $isdone;
        return $this;
    }
    /**
     * Get hasimages value
     * @return string
     */
    public function getHasimages()
    {
        return $this->hasimages;
    }
    /**
     * Set hasimages value
     * @param string $hasimages
     * @return \StructType\RoomMaintenanceStatus
     */
    public function setHasimages($hasimages = null)
    {
        // validation for constraint: string
        if (!is_null($hasimages) && !is_string($hasimages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hasimages, true), gettype($hasimages)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hasimages) && !preg_match('/([-+]){0,1}([0-9])*/', $hasimages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hasimages, true)), __LINE__);
        }
        $this->hasimages = $hasimages;
        return $this;
    }
    /**
     * Get ImageManager value
     * @return \StructType\ImageManager[]|null
     */
    public function getImageManager()
    {
        return $this->ImageManager;
    }
    /**
     * This method is responsible for validating the values passed to the setImageManager method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImageManager method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImageManagerForArrayConstraintsFromSetImageManager(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomMaintenanceStatusImageManagerItem) {
            // validation for constraint: itemType
            if (!$roomMaintenanceStatusImageManagerItem instanceof \StructType\ImageManager) {
                $invalidValues[] = is_object($roomMaintenanceStatusImageManagerItem) ? get_class($roomMaintenanceStatusImageManagerItem) : sprintf('%s(%s)', gettype($roomMaintenanceStatusImageManagerItem), var_export($roomMaintenanceStatusImageManagerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ImageManager property can only contain items of type \StructType\ImageManager, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ImageManager value
     * @throws \InvalidArgumentException
     * @param \StructType\ImageManager[] $imageManager
     * @return \StructType\RoomMaintenanceStatus
     */
    public function setImageManager(array $imageManager = array())
    {
        // validation for constraint: array
        if ('' !== ($imageManagerArrayErrorMessage = self::validateImageManagerForArrayConstraintsFromSetImageManager($imageManager))) {
            throw new \InvalidArgumentException($imageManagerArrayErrorMessage, __LINE__);
        }
        $this->ImageManager = $imageManager;
        return $this;
    }
    /**
     * Add item to ImageManager value
     * @throws \InvalidArgumentException
     * @param \StructType\ImageManager $item
     * @return \StructType\RoomMaintenanceStatus
     */
    public function addToImageManager(\StructType\ImageManager $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ImageManager) {
            throw new \InvalidArgumentException(sprintf('The ImageManager property can only contain items of type \StructType\ImageManager, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ImageManager[] = $item;
        return $this;
    }
}
