<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomBookingFree StructType
 * @subpackage Structs
 */
class RoomBookingFree extends AbstractStructBase
{
    /**
     * The ROOMBOOKING_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ROOMBOOKING_OBJID;
    /**
     * Constructor method for RoomBookingFree
     * @uses RoomBookingFree::setROOMBOOKING_OBJID()
     * @param string $rOOMBOOKING_OBJID
     */
    public function __construct($rOOMBOOKING_OBJID = null)
    {
        $this
            ->setROOMBOOKING_OBJID($rOOMBOOKING_OBJID);
    }
    /**
     * Get ROOMBOOKING_OBJID value
     * @return string
     */
    public function getROOMBOOKING_OBJID()
    {
        return $this->{'ROOMBOOKING-OBJID'};
    }
    /**
     * Set ROOMBOOKING_OBJID value
     * @param string $rOOMBOOKING_OBJID
     * @return \StructType\RoomBookingFree
     */
    public function setROOMBOOKING_OBJID($rOOMBOOKING_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rOOMBOOKING_OBJID) && !is_string($rOOMBOOKING_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOOMBOOKING_OBJID, true), gettype($rOOMBOOKING_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rOOMBOOKING_OBJID) && !preg_match('/([0-9])*/', $rOOMBOOKING_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rOOMBOOKING_OBJID, true)), __LINE__);
        }
        $this->ROOMBOOKING_OBJID = $this->{'ROOMBOOKING-OBJID'} = $rOOMBOOKING_OBJID;
        return $this;
    }
}
