<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Result StructType
 * @subpackage Structs
 */
class Result extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - base: string
     * - pattern: false
     * @var string
     */
    public $Success;
    /**
     * The ErrorMsg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMsg;
    /**
     * The MSG_LIST
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MSG_LIST
     */
    public $MSG_LIST;
    /**
     * Constructor method for Result
     * @uses Result::setSuccess()
     * @uses Result::setErrorMsg()
     * @uses Result::setMSG_LIST()
     * @param string $success
     * @param string $errorMsg
     * @param \StructType\MSG_LIST $mSG_LIST
     */
    public function __construct($success = null, $errorMsg = null, \StructType\MSG_LIST $mSG_LIST = null)
    {
        $this
            ->setSuccess($success)
            ->setErrorMsg($errorMsg)
            ->setMSG_LIST($mSG_LIST);
    }
    /**
     * Get Success value
     * @return string|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param string $success
     * @return \StructType\Result
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: string
        if (!is_null($success) && !is_string($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        // validation for constraint: pattern(false)
        if (!is_null($success) && !preg_match('/false/', $success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression false', var_export($success, true)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMsg value
     * @return string|null
     */
    public function getErrorMsg()
    {
        return $this->ErrorMsg;
    }
    /**
     * Set ErrorMsg value
     * @param string $errorMsg
     * @return \StructType\Result
     */
    public function setErrorMsg($errorMsg = null)
    {
        // validation for constraint: string
        if (!is_null($errorMsg) && !is_string($errorMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMsg, true), gettype($errorMsg)), __LINE__);
        }
        $this->ErrorMsg = $errorMsg;
        return $this;
    }
    /**
     * Get MSG_LIST value
     * @return \StructType\MSG_LIST|null
     */
    public function getMSG_LIST()
    {
        return $this->{'MSG-LIST'};
    }
    /**
     * Set MSG_LIST value
     * @param \StructType\MSG_LIST $mSG_LIST
     * @return \StructType\Result
     */
    public function setMSG_LIST(\StructType\MSG_LIST $mSG_LIST = null)
    {
        $this->MSG_LIST = $this->{'MSG-LIST'} = $mSG_LIST;
        return $this;
    }
}
