<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reservation StructType
 * @subpackage Structs
 */
class Reservation_1 extends AbstractStructBase
{
    /**
     * The RESERVATION_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $RESERVATION_OBJID;
    /**
     * The resno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $resno;
    /**
     * The subno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $subno;
    /**
     * The restype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $restype;
    /**
     * The groupnumber
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $groupnumber;
    /**
     * The cancellationdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $cancellationdate;
    /**
     * The noofrooms
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofrooms;
    /**
     * The noofnights
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofnights;
    /**
     * The arrival
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $arrival;
    /**
     * The arrivaltime
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $arrivaltime;
    /**
     * The departure
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $departure;
    /**
     * The departuretime
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $departuretime;
    /**
     * The gdsresnumber
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $gdsresnumber;
    /**
     * The centralid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $centralid;
    /**
     * The externalid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $externalid;
    /**
     * The externalkey
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $externalkey;
    /**
     * The externalreference
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $externalreference;
    /**
     * The ratecategory
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ratecategory;
    /**
     * The ratesegment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ratesegment;
    /**
     * The resmedium
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $resmedium;
    /**
     * The ressource
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ressource;
    /**
     * The forecastnoofadults
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $forecastnoofadults;
    /**
     * The forecastnoofchildren
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $forecastnoofchildren;
    /**
     * The forecastnoofpax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $forecastnoofpax;
    /**
     * The forecastrategross
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $forecastrategross;
    /**
     * The forecastratenet
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $forecastratenet;
    /**
     * The deposit
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $deposit;
    /**
     * The hasautoservice
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hasautoservice;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * The commentcentral
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $commentcentral;
    /**
     * The commenttechnical
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $commenttechnical;
    /**
     * The noofpax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofpax;
    /**
     * The noofchildren
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofchildren;
    /**
     * The noofadults
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofadults;
    /**
     * The paymentinstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $paymentinstructions;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $service;
    /**
     * The RoomAdd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RoomAdd
     */
    public $RoomAdd;
    /**
     * The DepositInCreditWithForecast
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\DepositInCreditWithForecast
     */
    public $DepositInCreditWithForecast;
    /**
     * The DepositInWithForecast
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\DepositInWithForecast
     */
    public $DepositInWithForecast;
    /**
     * The DepositInWithPayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\DepositInWithPayment
     */
    public $DepositInWithPayment;
    /**
     * The DepositInWithService
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\DepositInWithService
     */
    public $DepositInWithService;
    /**
     * The PostPrePayment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PostPrePayment[]
     */
    public $PostPrePayment;
    /**
     * The Rooms
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Rooms_1[]
     */
    public $Rooms;
    /**
     * The RESERVATION_CENTRALID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $RESERVATION_CENTRALID;
    /**
     * The ResGroupReservations
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ResGroupReservations[]
     */
    public $ResGroupReservations;
    /**
     * The Orderer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Orderer_1[]
     */
    public $Orderer;
    /**
     * The TravelAgency
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TravelAgency_1[]
     */
    public $TravelAgency;
    /**
     * The TravelPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TravelPoint_1[]
     */
    public $TravelPoint;
    /**
     * Constructor method for Reservation
     * @uses Reservation_1::setRESERVATION_OBJID()
     * @uses Reservation_1::setResno()
     * @uses Reservation_1::setSubno()
     * @uses Reservation_1::setRestype()
     * @uses Reservation_1::setGroupnumber()
     * @uses Reservation_1::setCancellationdate()
     * @uses Reservation_1::setNoofrooms()
     * @uses Reservation_1::setNoofnights()
     * @uses Reservation_1::setArrival()
     * @uses Reservation_1::setArrivaltime()
     * @uses Reservation_1::setDeparture()
     * @uses Reservation_1::setDeparturetime()
     * @uses Reservation_1::setGdsresnumber()
     * @uses Reservation_1::setCentralid()
     * @uses Reservation_1::setExternalid()
     * @uses Reservation_1::setExternalkey()
     * @uses Reservation_1::setExternalreference()
     * @uses Reservation_1::setRatecategory()
     * @uses Reservation_1::setRatesegment()
     * @uses Reservation_1::setResmedium()
     * @uses Reservation_1::setRessource()
     * @uses Reservation_1::setForecastnoofadults()
     * @uses Reservation_1::setForecastnoofchildren()
     * @uses Reservation_1::setForecastnoofpax()
     * @uses Reservation_1::setForecastrategross()
     * @uses Reservation_1::setForecastratenet()
     * @uses Reservation_1::setDeposit()
     * @uses Reservation_1::setHasautoservice()
     * @uses Reservation_1::setCurrency()
     * @uses Reservation_1::setCommentcentral()
     * @uses Reservation_1::setCommenttechnical()
     * @uses Reservation_1::setNoofpax()
     * @uses Reservation_1::setNoofchildren()
     * @uses Reservation_1::setNoofadults()
     * @uses Reservation_1::setPaymentinstructions()
     * @uses Reservation_1::setService()
     * @uses Reservation_1::setRoomAdd()
     * @uses Reservation_1::setDepositInCreditWithForecast()
     * @uses Reservation_1::setDepositInWithForecast()
     * @uses Reservation_1::setDepositInWithPayment()
     * @uses Reservation_1::setDepositInWithService()
     * @uses Reservation_1::setPostPrePayment()
     * @uses Reservation_1::setRooms()
     * @uses Reservation_1::setRESERVATION_CENTRALID()
     * @uses Reservation_1::setResGroupReservations()
     * @uses Reservation_1::setOrderer()
     * @uses Reservation_1::setTravelAgency()
     * @uses Reservation_1::setTravelPoint()
     * @param string $rESERVATION_OBJID
     * @param string $resno
     * @param string $subno
     * @param string $restype
     * @param string $groupnumber
     * @param string $cancellationdate
     * @param string $noofrooms
     * @param string $noofnights
     * @param string $arrival
     * @param string $arrivaltime
     * @param string $departure
     * @param string $departuretime
     * @param string $gdsresnumber
     * @param string $centralid
     * @param string $externalid
     * @param string $externalkey
     * @param string $externalreference
     * @param string $ratecategory
     * @param string $ratesegment
     * @param string $resmedium
     * @param string $ressource
     * @param string $forecastnoofadults
     * @param string $forecastnoofchildren
     * @param string $forecastnoofpax
     * @param string $forecastrategross
     * @param string $forecastratenet
     * @param string $deposit
     * @param string $hasautoservice
     * @param string $currency
     * @param string $commentcentral
     * @param string $commenttechnical
     * @param string $noofpax
     * @param string $noofchildren
     * @param string $noofadults
     * @param string $paymentinstructions
     * @param string $service
     * @param \StructType\RoomAdd $roomAdd
     * @param \StructType\DepositInCreditWithForecast $depositInCreditWithForecast
     * @param \StructType\DepositInWithForecast $depositInWithForecast
     * @param \StructType\DepositInWithPayment $depositInWithPayment
     * @param \StructType\DepositInWithService $depositInWithService
     * @param \StructType\PostPrePayment[] $postPrePayment
     * @param \StructType\Rooms_1[] $rooms
     * @param string $rESERVATION_CENTRALID
     * @param \StructType\ResGroupReservations[] $resGroupReservations
     * @param \StructType\Orderer_1[] $orderer
     * @param \StructType\TravelAgency_1[] $travelAgency
     * @param \StructType\TravelPoint_1[] $travelPoint
     */
    public function __construct($rESERVATION_OBJID = null, $resno = null, $subno = null, $restype = null, $groupnumber = null, $cancellationdate = null, $noofrooms = null, $noofnights = null, $arrival = null, $arrivaltime = null, $departure = null, $departuretime = null, $gdsresnumber = null, $centralid = null, $externalid = null, $externalkey = null, $externalreference = null, $ratecategory = null, $ratesegment = null, $resmedium = null, $ressource = null, $forecastnoofadults = null, $forecastnoofchildren = null, $forecastnoofpax = null, $forecastrategross = null, $forecastratenet = null, $deposit = null, $hasautoservice = null, $currency = null, $commentcentral = null, $commenttechnical = null, $noofpax = null, $noofchildren = null, $noofadults = null, $paymentinstructions = null, $service = null, \StructType\RoomAdd $roomAdd = null, \StructType\DepositInCreditWithForecast $depositInCreditWithForecast = null, \StructType\DepositInWithForecast $depositInWithForecast = null, \StructType\DepositInWithPayment $depositInWithPayment = null, \StructType\DepositInWithService $depositInWithService = null, array $postPrePayment = array(), array $rooms = array(), $rESERVATION_CENTRALID = null, array $resGroupReservations = array(), array $orderer = array(), array $travelAgency = array(), array $travelPoint = array())
    {
        $this
            ->setRESERVATION_OBJID($rESERVATION_OBJID)
            ->setResno($resno)
            ->setSubno($subno)
            ->setRestype($restype)
            ->setGroupnumber($groupnumber)
            ->setCancellationdate($cancellationdate)
            ->setNoofrooms($noofrooms)
            ->setNoofnights($noofnights)
            ->setArrival($arrival)
            ->setArrivaltime($arrivaltime)
            ->setDeparture($departure)
            ->setDeparturetime($departuretime)
            ->setGdsresnumber($gdsresnumber)
            ->setCentralid($centralid)
            ->setExternalid($externalid)
            ->setExternalkey($externalkey)
            ->setExternalreference($externalreference)
            ->setRatecategory($ratecategory)
            ->setRatesegment($ratesegment)
            ->setResmedium($resmedium)
            ->setRessource($ressource)
            ->setForecastnoofadults($forecastnoofadults)
            ->setForecastnoofchildren($forecastnoofchildren)
            ->setForecastnoofpax($forecastnoofpax)
            ->setForecastrategross($forecastrategross)
            ->setForecastratenet($forecastratenet)
            ->setDeposit($deposit)
            ->setHasautoservice($hasautoservice)
            ->setCurrency($currency)
            ->setCommentcentral($commentcentral)
            ->setCommenttechnical($commenttechnical)
            ->setNoofpax($noofpax)
            ->setNoofchildren($noofchildren)
            ->setNoofadults($noofadults)
            ->setPaymentinstructions($paymentinstructions)
            ->setService($service)
            ->setRoomAdd($roomAdd)
            ->setDepositInCreditWithForecast($depositInCreditWithForecast)
            ->setDepositInWithForecast($depositInWithForecast)
            ->setDepositInWithPayment($depositInWithPayment)
            ->setDepositInWithService($depositInWithService)
            ->setPostPrePayment($postPrePayment)
            ->setRooms($rooms)
            ->setRESERVATION_CENTRALID($rESERVATION_CENTRALID)
            ->setResGroupReservations($resGroupReservations)
            ->setOrderer($orderer)
            ->setTravelAgency($travelAgency)
            ->setTravelPoint($travelPoint);
    }
    /**
     * Get RESERVATION_OBJID value
     * @return string
     */
    public function getRESERVATION_OBJID()
    {
        return $this->{'RESERVATION-OBJID'};
    }
    /**
     * Set RESERVATION_OBJID value
     * @param string $rESERVATION_OBJID
     * @return \StructType\Reservation_1
     */
    public function setRESERVATION_OBJID($rESERVATION_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rESERVATION_OBJID) && !is_string($rESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rESERVATION_OBJID, true), gettype($rESERVATION_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rESERVATION_OBJID) && !preg_match('/([0-9])*/', $rESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rESERVATION_OBJID, true)), __LINE__);
        }
        $this->RESERVATION_OBJID = $this->{'RESERVATION-OBJID'} = $rESERVATION_OBJID;
        return $this;
    }
    /**
     * Get resno value
     * @return string
     */
    public function getResno()
    {
        return $this->resno;
    }
    /**
     * Set resno value
     * @param string $resno
     * @return \StructType\Reservation_1
     */
    public function setResno($resno = null)
    {
        // validation for constraint: string
        if (!is_null($resno) && !is_string($resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resno, true), gettype($resno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($resno) && !preg_match('/([-+]){0,1}([0-9])*/', $resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($resno, true)), __LINE__);
        }
        $this->resno = $resno;
        return $this;
    }
    /**
     * Get subno value
     * @return string
     */
    public function getSubno()
    {
        return $this->subno;
    }
    /**
     * Set subno value
     * @param string $subno
     * @return \StructType\Reservation_1
     */
    public function setSubno($subno = null)
    {
        // validation for constraint: string
        if (!is_null($subno) && !is_string($subno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subno, true), gettype($subno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($subno) && !preg_match('/([-+]){0,1}([0-9])*/', $subno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($subno, true)), __LINE__);
        }
        $this->subno = $subno;
        return $this;
    }
    /**
     * Get restype value
     * @return string
     */
    public function getRestype()
    {
        return $this->restype;
    }
    /**
     * Set restype value
     * @param string $restype
     * @return \StructType\Reservation_1
     */
    public function setRestype($restype = null)
    {
        // validation for constraint: string
        if (!is_null($restype) && !is_string($restype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restype, true), gettype($restype)), __LINE__);
        }
        $this->restype = $restype;
        return $this;
    }
    /**
     * Get groupnumber value
     * @return string
     */
    public function getGroupnumber()
    {
        return $this->groupnumber;
    }
    /**
     * Set groupnumber value
     * @param string $groupnumber
     * @return \StructType\Reservation_1
     */
    public function setGroupnumber($groupnumber = null)
    {
        // validation for constraint: string
        if (!is_null($groupnumber) && !is_string($groupnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupnumber, true), gettype($groupnumber)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($groupnumber) && !preg_match('/([-+]){0,1}([0-9])*/', $groupnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($groupnumber, true)), __LINE__);
        }
        $this->groupnumber = $groupnumber;
        return $this;
    }
    /**
     * Get cancellationdate value
     * @return string
     */
    public function getCancellationdate()
    {
        return $this->cancellationdate;
    }
    /**
     * Set cancellationdate value
     * @param string $cancellationdate
     * @return \StructType\Reservation_1
     */
    public function setCancellationdate($cancellationdate = null)
    {
        // validation for constraint: string
        if (!is_null($cancellationdate) && !is_string($cancellationdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancellationdate, true), gettype($cancellationdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($cancellationdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $cancellationdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($cancellationdate, true)), __LINE__);
        }
        $this->cancellationdate = $cancellationdate;
        return $this;
    }
    /**
     * Get noofrooms value
     * @return string
     */
    public function getNoofrooms()
    {
        return $this->noofrooms;
    }
    /**
     * Set noofrooms value
     * @param string $noofrooms
     * @return \StructType\Reservation_1
     */
    public function setNoofrooms($noofrooms = null)
    {
        // validation for constraint: string
        if (!is_null($noofrooms) && !is_string($noofrooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofrooms, true), gettype($noofrooms)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofrooms) && !preg_match('/([-+]){0,1}([0-9])*/', $noofrooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofrooms, true)), __LINE__);
        }
        $this->noofrooms = $noofrooms;
        return $this;
    }
    /**
     * Get noofnights value
     * @return string
     */
    public function getNoofnights()
    {
        return $this->noofnights;
    }
    /**
     * Set noofnights value
     * @param string $noofnights
     * @return \StructType\Reservation_1
     */
    public function setNoofnights($noofnights = null)
    {
        // validation for constraint: string
        if (!is_null($noofnights) && !is_string($noofnights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofnights, true), gettype($noofnights)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofnights) && !preg_match('/([-+]){0,1}([0-9])*/', $noofnights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofnights, true)), __LINE__);
        }
        $this->noofnights = $noofnights;
        return $this;
    }
    /**
     * Get arrival value
     * @return string
     */
    public function getArrival()
    {
        return $this->arrival;
    }
    /**
     * Set arrival value
     * @param string $arrival
     * @return \StructType\Reservation_1
     */
    public function setArrival($arrival = null)
    {
        // validation for constraint: string
        if (!is_null($arrival) && !is_string($arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrival, true), gettype($arrival)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($arrival) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($arrival, true)), __LINE__);
        }
        $this->arrival = $arrival;
        return $this;
    }
    /**
     * Get arrivaltime value
     * @return string
     */
    public function getArrivaltime()
    {
        return $this->arrivaltime;
    }
    /**
     * Set arrivaltime value
     * @param string $arrivaltime
     * @return \StructType\Reservation_1
     */
    public function setArrivaltime($arrivaltime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivaltime) && !is_string($arrivaltime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivaltime, true), gettype($arrivaltime)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($arrivaltime) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $arrivaltime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($arrivaltime, true)), __LINE__);
        }
        $this->arrivaltime = $arrivaltime;
        return $this;
    }
    /**
     * Get departure value
     * @return string
     */
    public function getDeparture()
    {
        return $this->departure;
    }
    /**
     * Set departure value
     * @param string $departure
     * @return \StructType\Reservation_1
     */
    public function setDeparture($departure = null)
    {
        // validation for constraint: string
        if (!is_null($departure) && !is_string($departure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departure, true), gettype($departure)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($departure) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $departure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($departure, true)), __LINE__);
        }
        $this->departure = $departure;
        return $this;
    }
    /**
     * Get departuretime value
     * @return string
     */
    public function getDeparturetime()
    {
        return $this->departuretime;
    }
    /**
     * Set departuretime value
     * @param string $departuretime
     * @return \StructType\Reservation_1
     */
    public function setDeparturetime($departuretime = null)
    {
        // validation for constraint: string
        if (!is_null($departuretime) && !is_string($departuretime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departuretime, true), gettype($departuretime)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($departuretime) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $departuretime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($departuretime, true)), __LINE__);
        }
        $this->departuretime = $departuretime;
        return $this;
    }
    /**
     * Get gdsresnumber value
     * @return string
     */
    public function getGdsresnumber()
    {
        return $this->gdsresnumber;
    }
    /**
     * Set gdsresnumber value
     * @param string $gdsresnumber
     * @return \StructType\Reservation_1
     */
    public function setGdsresnumber($gdsresnumber = null)
    {
        // validation for constraint: string
        if (!is_null($gdsresnumber) && !is_string($gdsresnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gdsresnumber, true), gettype($gdsresnumber)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($gdsresnumber) && mb_strlen($gdsresnumber) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($gdsresnumber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($gdsresnumber) && mb_strlen($gdsresnumber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($gdsresnumber)), __LINE__);
        }
        $this->gdsresnumber = $gdsresnumber;
        return $this;
    }
    /**
     * Get centralid value
     * @return string
     */
    public function getCentralid()
    {
        return $this->centralid;
    }
    /**
     * Set centralid value
     * @param string $centralid
     * @return \StructType\Reservation_1
     */
    public function setCentralid($centralid = null)
    {
        // validation for constraint: string
        if (!is_null($centralid) && !is_string($centralid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($centralid, true), gettype($centralid)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($centralid) && !preg_match('/([0-9])*/', $centralid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($centralid, true)), __LINE__);
        }
        $this->centralid = $centralid;
        return $this;
    }
    /**
     * Get externalid value
     * @return string
     */
    public function getExternalid()
    {
        return $this->externalid;
    }
    /**
     * Set externalid value
     * @param string $externalid
     * @return \StructType\Reservation_1
     */
    public function setExternalid($externalid = null)
    {
        // validation for constraint: string
        if (!is_null($externalid) && !is_string($externalid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalid, true), gettype($externalid)), __LINE__);
        }
        $this->externalid = $externalid;
        return $this;
    }
    /**
     * Get externalkey value
     * @return string
     */
    public function getExternalkey()
    {
        return $this->externalkey;
    }
    /**
     * Set externalkey value
     * @param string $externalkey
     * @return \StructType\Reservation_1
     */
    public function setExternalkey($externalkey = null)
    {
        // validation for constraint: string
        if (!is_null($externalkey) && !is_string($externalkey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalkey, true), gettype($externalkey)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($externalkey) && mb_strlen($externalkey) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($externalkey)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($externalkey) && mb_strlen($externalkey) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($externalkey)), __LINE__);
        }
        $this->externalkey = $externalkey;
        return $this;
    }
    /**
     * Get externalreference value
     * @return string
     */
    public function getExternalreference()
    {
        return $this->externalreference;
    }
    /**
     * Set externalreference value
     * @param string $externalreference
     * @return \StructType\Reservation_1
     */
    public function setExternalreference($externalreference = null)
    {
        // validation for constraint: string
        if (!is_null($externalreference) && !is_string($externalreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalreference, true), gettype($externalreference)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($externalreference) && mb_strlen($externalreference) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($externalreference)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($externalreference) && mb_strlen($externalreference) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($externalreference)), __LINE__);
        }
        $this->externalreference = $externalreference;
        return $this;
    }
    /**
     * Get ratecategory value
     * @return string
     */
    public function getRatecategory()
    {
        return $this->ratecategory;
    }
    /**
     * Set ratecategory value
     * @param string $ratecategory
     * @return \StructType\Reservation_1
     */
    public function setRatecategory($ratecategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratecategory) && !is_string($ratecategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratecategory, true), gettype($ratecategory)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($ratecategory) && mb_strlen($ratecategory) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($ratecategory)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ratecategory) && mb_strlen($ratecategory) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ratecategory)), __LINE__);
        }
        $this->ratecategory = $ratecategory;
        return $this;
    }
    /**
     * Get ratesegment value
     * @return string
     */
    public function getRatesegment()
    {
        return $this->ratesegment;
    }
    /**
     * Set ratesegment value
     * @param string $ratesegment
     * @return \StructType\Reservation_1
     */
    public function setRatesegment($ratesegment = null)
    {
        // validation for constraint: string
        if (!is_null($ratesegment) && !is_string($ratesegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratesegment, true), gettype($ratesegment)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($ratesegment) && mb_strlen($ratesegment) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($ratesegment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ratesegment) && mb_strlen($ratesegment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ratesegment)), __LINE__);
        }
        $this->ratesegment = $ratesegment;
        return $this;
    }
    /**
     * Get resmedium value
     * @return string
     */
    public function getResmedium()
    {
        return $this->resmedium;
    }
    /**
     * Set resmedium value
     * @param string $resmedium
     * @return \StructType\Reservation_1
     */
    public function setResmedium($resmedium = null)
    {
        // validation for constraint: string
        if (!is_null($resmedium) && !is_string($resmedium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resmedium, true), gettype($resmedium)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($resmedium) && mb_strlen($resmedium) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($resmedium)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($resmedium) && mb_strlen($resmedium) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($resmedium)), __LINE__);
        }
        $this->resmedium = $resmedium;
        return $this;
    }
    /**
     * Get ressource value
     * @return string
     */
    public function getRessource()
    {
        return $this->ressource;
    }
    /**
     * Set ressource value
     * @param string $ressource
     * @return \StructType\Reservation_1
     */
    public function setRessource($ressource = null)
    {
        // validation for constraint: string
        if (!is_null($ressource) && !is_string($ressource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ressource, true), gettype($ressource)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($ressource) && mb_strlen($ressource) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($ressource)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ressource) && mb_strlen($ressource) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ressource)), __LINE__);
        }
        $this->ressource = $ressource;
        return $this;
    }
    /**
     * Get forecastnoofadults value
     * @return string
     */
    public function getForecastnoofadults()
    {
        return $this->forecastnoofadults;
    }
    /**
     * Set forecastnoofadults value
     * @param string $forecastnoofadults
     * @return \StructType\Reservation_1
     */
    public function setForecastnoofadults($forecastnoofadults = null)
    {
        // validation for constraint: string
        if (!is_null($forecastnoofadults) && !is_string($forecastnoofadults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastnoofadults, true), gettype($forecastnoofadults)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($forecastnoofadults) && !preg_match('/([-+]){0,1}([0-9])*/', $forecastnoofadults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($forecastnoofadults, true)), __LINE__);
        }
        $this->forecastnoofadults = $forecastnoofadults;
        return $this;
    }
    /**
     * Get forecastnoofchildren value
     * @return string
     */
    public function getForecastnoofchildren()
    {
        return $this->forecastnoofchildren;
    }
    /**
     * Set forecastnoofchildren value
     * @param string $forecastnoofchildren
     * @return \StructType\Reservation_1
     */
    public function setForecastnoofchildren($forecastnoofchildren = null)
    {
        // validation for constraint: string
        if (!is_null($forecastnoofchildren) && !is_string($forecastnoofchildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastnoofchildren, true), gettype($forecastnoofchildren)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($forecastnoofchildren) && !preg_match('/([-+]){0,1}([0-9])*/', $forecastnoofchildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($forecastnoofchildren, true)), __LINE__);
        }
        $this->forecastnoofchildren = $forecastnoofchildren;
        return $this;
    }
    /**
     * Get forecastnoofpax value
     * @return string
     */
    public function getForecastnoofpax()
    {
        return $this->forecastnoofpax;
    }
    /**
     * Set forecastnoofpax value
     * @param string $forecastnoofpax
     * @return \StructType\Reservation_1
     */
    public function setForecastnoofpax($forecastnoofpax = null)
    {
        // validation for constraint: string
        if (!is_null($forecastnoofpax) && !is_string($forecastnoofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastnoofpax, true), gettype($forecastnoofpax)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($forecastnoofpax) && !preg_match('/([-+]){0,1}([0-9])*/', $forecastnoofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($forecastnoofpax, true)), __LINE__);
        }
        $this->forecastnoofpax = $forecastnoofpax;
        return $this;
    }
    /**
     * Get forecastrategross value
     * @return string
     */
    public function getForecastrategross()
    {
        return $this->forecastrategross;
    }
    /**
     * Set forecastrategross value
     * @param string $forecastrategross
     * @return \StructType\Reservation_1
     */
    public function setForecastrategross($forecastrategross = null)
    {
        // validation for constraint: string
        if (!is_null($forecastrategross) && !is_string($forecastrategross)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastrategross, true), gettype($forecastrategross)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($forecastrategross) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $forecastrategross)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($forecastrategross, true)), __LINE__);
        }
        $this->forecastrategross = $forecastrategross;
        return $this;
    }
    /**
     * Get forecastratenet value
     * @return string
     */
    public function getForecastratenet()
    {
        return $this->forecastratenet;
    }
    /**
     * Set forecastratenet value
     * @param string $forecastratenet
     * @return \StructType\Reservation_1
     */
    public function setForecastratenet($forecastratenet = null)
    {
        // validation for constraint: string
        if (!is_null($forecastratenet) && !is_string($forecastratenet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastratenet, true), gettype($forecastratenet)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($forecastratenet) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $forecastratenet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($forecastratenet, true)), __LINE__);
        }
        $this->forecastratenet = $forecastratenet;
        return $this;
    }
    /**
     * Get deposit value
     * @return string
     */
    public function getDeposit()
    {
        return $this->deposit;
    }
    /**
     * Set deposit value
     * @param string $deposit
     * @return \StructType\Reservation_1
     */
    public function setDeposit($deposit = null)
    {
        // validation for constraint: string
        if (!is_null($deposit) && !is_string($deposit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deposit, true), gettype($deposit)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($deposit) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $deposit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($deposit, true)), __LINE__);
        }
        $this->deposit = $deposit;
        return $this;
    }
    /**
     * Get hasautoservice value
     * @return string
     */
    public function getHasautoservice()
    {
        return $this->hasautoservice;
    }
    /**
     * Set hasautoservice value
     * @param string $hasautoservice
     * @return \StructType\Reservation_1
     */
    public function setHasautoservice($hasautoservice = null)
    {
        // validation for constraint: string
        if (!is_null($hasautoservice) && !is_string($hasautoservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hasautoservice, true), gettype($hasautoservice)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hasautoservice) && !preg_match('/([-+]){0,1}([0-9])*/', $hasautoservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hasautoservice, true)), __LINE__);
        }
        $this->hasautoservice = $hasautoservice;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\Reservation_1
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get commentcentral value
     * @return string
     */
    public function getCommentcentral()
    {
        return $this->commentcentral;
    }
    /**
     * Set commentcentral value
     * @param string $commentcentral
     * @return \StructType\Reservation_1
     */
    public function setCommentcentral($commentcentral = null)
    {
        // validation for constraint: string
        if (!is_null($commentcentral) && !is_string($commentcentral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commentcentral, true), gettype($commentcentral)), __LINE__);
        }
        $this->commentcentral = $commentcentral;
        return $this;
    }
    /**
     * Get commenttechnical value
     * @return string
     */
    public function getCommenttechnical()
    {
        return $this->commenttechnical;
    }
    /**
     * Set commenttechnical value
     * @param string $commenttechnical
     * @return \StructType\Reservation_1
     */
    public function setCommenttechnical($commenttechnical = null)
    {
        // validation for constraint: string
        if (!is_null($commenttechnical) && !is_string($commenttechnical)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commenttechnical, true), gettype($commenttechnical)), __LINE__);
        }
        $this->commenttechnical = $commenttechnical;
        return $this;
    }
    /**
     * Get noofpax value
     * @return string
     */
    public function getNoofpax()
    {
        return $this->noofpax;
    }
    /**
     * Set noofpax value
     * @param string $noofpax
     * @return \StructType\Reservation_1
     */
    public function setNoofpax($noofpax = null)
    {
        // validation for constraint: string
        if (!is_null($noofpax) && !is_string($noofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofpax, true), gettype($noofpax)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofpax) && !preg_match('/([-+]){0,1}([0-9])*/', $noofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofpax, true)), __LINE__);
        }
        $this->noofpax = $noofpax;
        return $this;
    }
    /**
     * Get noofchildren value
     * @return string
     */
    public function getNoofchildren()
    {
        return $this->noofchildren;
    }
    /**
     * Set noofchildren value
     * @param string $noofchildren
     * @return \StructType\Reservation_1
     */
    public function setNoofchildren($noofchildren = null)
    {
        // validation for constraint: string
        if (!is_null($noofchildren) && !is_string($noofchildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofchildren, true), gettype($noofchildren)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofchildren) && !preg_match('/([-+]){0,1}([0-9])*/', $noofchildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofchildren, true)), __LINE__);
        }
        $this->noofchildren = $noofchildren;
        return $this;
    }
    /**
     * Get noofadults value
     * @return string
     */
    public function getNoofadults()
    {
        return $this->noofadults;
    }
    /**
     * Set noofadults value
     * @param string $noofadults
     * @return \StructType\Reservation_1
     */
    public function setNoofadults($noofadults = null)
    {
        // validation for constraint: string
        if (!is_null($noofadults) && !is_string($noofadults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofadults, true), gettype($noofadults)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofadults) && !preg_match('/([-+]){0,1}([0-9])*/', $noofadults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofadults, true)), __LINE__);
        }
        $this->noofadults = $noofadults;
        return $this;
    }
    /**
     * Get paymentinstructions value
     * @return string
     */
    public function getPaymentinstructions()
    {
        return $this->paymentinstructions;
    }
    /**
     * Set paymentinstructions value
     * @param string $paymentinstructions
     * @return \StructType\Reservation_1
     */
    public function setPaymentinstructions($paymentinstructions = null)
    {
        // validation for constraint: string
        if (!is_null($paymentinstructions) && !is_string($paymentinstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentinstructions, true), gettype($paymentinstructions)), __LINE__);
        }
        $this->paymentinstructions = $paymentinstructions;
        return $this;
    }
    /**
     * Get service value
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \StructType\Reservation_1
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get RoomAdd value
     * @return \StructType\RoomAdd
     */
    public function getRoomAdd()
    {
        return $this->RoomAdd;
    }
    /**
     * Set RoomAdd value
     * @param \StructType\RoomAdd $roomAdd
     * @return \StructType\Reservation_1
     */
    public function setRoomAdd(\StructType\RoomAdd $roomAdd = null)
    {
        $this->RoomAdd = $roomAdd;
        return $this;
    }
    /**
     * Get DepositInCreditWithForecast value
     * @return \StructType\DepositInCreditWithForecast
     */
    public function getDepositInCreditWithForecast()
    {
        return $this->DepositInCreditWithForecast;
    }
    /**
     * Set DepositInCreditWithForecast value
     * @param \StructType\DepositInCreditWithForecast $depositInCreditWithForecast
     * @return \StructType\Reservation_1
     */
    public function setDepositInCreditWithForecast(\StructType\DepositInCreditWithForecast $depositInCreditWithForecast = null)
    {
        $this->DepositInCreditWithForecast = $depositInCreditWithForecast;
        return $this;
    }
    /**
     * Get DepositInWithForecast value
     * @return \StructType\DepositInWithForecast
     */
    public function getDepositInWithForecast()
    {
        return $this->DepositInWithForecast;
    }
    /**
     * Set DepositInWithForecast value
     * @param \StructType\DepositInWithForecast $depositInWithForecast
     * @return \StructType\Reservation_1
     */
    public function setDepositInWithForecast(\StructType\DepositInWithForecast $depositInWithForecast = null)
    {
        $this->DepositInWithForecast = $depositInWithForecast;
        return $this;
    }
    /**
     * Get DepositInWithPayment value
     * @return \StructType\DepositInWithPayment
     */
    public function getDepositInWithPayment()
    {
        return $this->DepositInWithPayment;
    }
    /**
     * Set DepositInWithPayment value
     * @param \StructType\DepositInWithPayment $depositInWithPayment
     * @return \StructType\Reservation_1
     */
    public function setDepositInWithPayment(\StructType\DepositInWithPayment $depositInWithPayment = null)
    {
        $this->DepositInWithPayment = $depositInWithPayment;
        return $this;
    }
    /**
     * Get DepositInWithService value
     * @return \StructType\DepositInWithService
     */
    public function getDepositInWithService()
    {
        return $this->DepositInWithService;
    }
    /**
     * Set DepositInWithService value
     * @param \StructType\DepositInWithService $depositInWithService
     * @return \StructType\Reservation_1
     */
    public function setDepositInWithService(\StructType\DepositInWithService $depositInWithService = null)
    {
        $this->DepositInWithService = $depositInWithService;
        return $this;
    }
    /**
     * Get PostPrePayment value
     * @return \StructType\PostPrePayment[]|null
     */
    public function getPostPrePayment()
    {
        return $this->PostPrePayment;
    }
    /**
     * This method is responsible for validating the values passed to the setPostPrePayment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPostPrePayment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePostPrePaymentForArrayConstraintsFromSetPostPrePayment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reservationPostPrePaymentItem) {
            // validation for constraint: itemType
            if (!$reservationPostPrePaymentItem instanceof \StructType\PostPrePayment) {
                $invalidValues[] = is_object($reservationPostPrePaymentItem) ? get_class($reservationPostPrePaymentItem) : sprintf('%s(%s)', gettype($reservationPostPrePaymentItem), var_export($reservationPostPrePaymentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PostPrePayment property can only contain items of type \StructType\PostPrePayment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PostPrePayment value
     * @throws \InvalidArgumentException
     * @param \StructType\PostPrePayment[] $postPrePayment
     * @return \StructType\Reservation_1
     */
    public function setPostPrePayment(array $postPrePayment = array())
    {
        // validation for constraint: array
        if ('' !== ($postPrePaymentArrayErrorMessage = self::validatePostPrePaymentForArrayConstraintsFromSetPostPrePayment($postPrePayment))) {
            throw new \InvalidArgumentException($postPrePaymentArrayErrorMessage, __LINE__);
        }
        $this->PostPrePayment = $postPrePayment;
        return $this;
    }
    /**
     * Add item to PostPrePayment value
     * @throws \InvalidArgumentException
     * @param \StructType\PostPrePayment $item
     * @return \StructType\Reservation_1
     */
    public function addToPostPrePayment(\StructType\PostPrePayment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PostPrePayment) {
            throw new \InvalidArgumentException(sprintf('The PostPrePayment property can only contain items of type \StructType\PostPrePayment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PostPrePayment[] = $item;
        return $this;
    }
    /**
     * Get Rooms value
     * @return \StructType\Rooms_1[]|null
     */
    public function getRooms()
    {
        return $this->Rooms;
    }
    /**
     * This method is responsible for validating the values passed to the setRooms method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRooms method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomsForArrayConstraintsFromSetRooms(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reservationRoomsItem) {
            // validation for constraint: itemType
            if (!$reservationRoomsItem instanceof \StructType\Rooms_1) {
                $invalidValues[] = is_object($reservationRoomsItem) ? get_class($reservationRoomsItem) : sprintf('%s(%s)', gettype($reservationRoomsItem), var_export($reservationRoomsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Rooms property can only contain items of type \StructType\Rooms_1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Rooms value
     * @throws \InvalidArgumentException
     * @param \StructType\Rooms_1[] $rooms
     * @return \StructType\Reservation_1
     */
    public function setRooms(array $rooms = array())
    {
        // validation for constraint: array
        if ('' !== ($roomsArrayErrorMessage = self::validateRoomsForArrayConstraintsFromSetRooms($rooms))) {
            throw new \InvalidArgumentException($roomsArrayErrorMessage, __LINE__);
        }
        $this->Rooms = $rooms;
        return $this;
    }
    /**
     * Add item to Rooms value
     * @throws \InvalidArgumentException
     * @param \StructType\Rooms_1 $item
     * @return \StructType\Reservation_1
     */
    public function addToRooms(\StructType\Rooms_1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Rooms_1) {
            throw new \InvalidArgumentException(sprintf('The Rooms property can only contain items of type \StructType\Rooms_1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Rooms[] = $item;
        return $this;
    }
    /**
     * Get RESERVATION_CENTRALID value
     * @return string|null
     */
    public function getRESERVATION_CENTRALID()
    {
        return $this->{'RESERVATION-CENTRALID'};
    }
    /**
     * Set RESERVATION_CENTRALID value
     * @param string $rESERVATION_CENTRALID
     * @return \StructType\Reservation_1
     */
    public function setRESERVATION_CENTRALID($rESERVATION_CENTRALID = null)
    {
        // validation for constraint: string
        if (!is_null($rESERVATION_CENTRALID) && !is_string($rESERVATION_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rESERVATION_CENTRALID, true), gettype($rESERVATION_CENTRALID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rESERVATION_CENTRALID) && !preg_match('/([0-9])*/', $rESERVATION_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rESERVATION_CENTRALID, true)), __LINE__);
        }
        $this->RESERVATION_CENTRALID = $this->{'RESERVATION-CENTRALID'} = $rESERVATION_CENTRALID;
        return $this;
    }
    /**
     * Get ResGroupReservations value
     * @return \StructType\ResGroupReservations[]|null
     */
    public function getResGroupReservations()
    {
        return $this->ResGroupReservations;
    }
    /**
     * This method is responsible for validating the values passed to the setResGroupReservations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResGroupReservations method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResGroupReservationsForArrayConstraintsFromSetResGroupReservations(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reservationResGroupReservationsItem) {
            // validation for constraint: itemType
            if (!$reservationResGroupReservationsItem instanceof \StructType\ResGroupReservations) {
                $invalidValues[] = is_object($reservationResGroupReservationsItem) ? get_class($reservationResGroupReservationsItem) : sprintf('%s(%s)', gettype($reservationResGroupReservationsItem), var_export($reservationResGroupReservationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ResGroupReservations property can only contain items of type \StructType\ResGroupReservations, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ResGroupReservations value
     * @throws \InvalidArgumentException
     * @param \StructType\ResGroupReservations[] $resGroupReservations
     * @return \StructType\Reservation_1
     */
    public function setResGroupReservations(array $resGroupReservations = array())
    {
        // validation for constraint: array
        if ('' !== ($resGroupReservationsArrayErrorMessage = self::validateResGroupReservationsForArrayConstraintsFromSetResGroupReservations($resGroupReservations))) {
            throw new \InvalidArgumentException($resGroupReservationsArrayErrorMessage, __LINE__);
        }
        $this->ResGroupReservations = $resGroupReservations;
        return $this;
    }
    /**
     * Add item to ResGroupReservations value
     * @throws \InvalidArgumentException
     * @param \StructType\ResGroupReservations $item
     * @return \StructType\Reservation_1
     */
    public function addToResGroupReservations(\StructType\ResGroupReservations $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ResGroupReservations) {
            throw new \InvalidArgumentException(sprintf('The ResGroupReservations property can only contain items of type \StructType\ResGroupReservations, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ResGroupReservations[] = $item;
        return $this;
    }
    /**
     * Get Orderer value
     * @return \StructType\Orderer_1[]|null
     */
    public function getOrderer()
    {
        return $this->Orderer;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrdererForArrayConstraintsFromSetOrderer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reservationOrdererItem) {
            // validation for constraint: itemType
            if (!$reservationOrdererItem instanceof \StructType\Orderer_1) {
                $invalidValues[] = is_object($reservationOrdererItem) ? get_class($reservationOrdererItem) : sprintf('%s(%s)', gettype($reservationOrdererItem), var_export($reservationOrdererItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Orderer property can only contain items of type \StructType\Orderer_1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Orderer value
     * @throws \InvalidArgumentException
     * @param \StructType\Orderer_1[] $orderer
     * @return \StructType\Reservation_1
     */
    public function setOrderer(array $orderer = array())
    {
        // validation for constraint: array
        if ('' !== ($ordererArrayErrorMessage = self::validateOrdererForArrayConstraintsFromSetOrderer($orderer))) {
            throw new \InvalidArgumentException($ordererArrayErrorMessage, __LINE__);
        }
        $this->Orderer = $orderer;
        return $this;
    }
    /**
     * Add item to Orderer value
     * @throws \InvalidArgumentException
     * @param \StructType\Orderer_1 $item
     * @return \StructType\Reservation_1
     */
    public function addToOrderer(\StructType\Orderer_1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Orderer_1) {
            throw new \InvalidArgumentException(sprintf('The Orderer property can only contain items of type \StructType\Orderer_1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Orderer[] = $item;
        return $this;
    }
    /**
     * Get TravelAgency value
     * @return \StructType\TravelAgency_1[]|null
     */
    public function getTravelAgency()
    {
        return $this->TravelAgency;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelAgency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelAgency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelAgencyForArrayConstraintsFromSetTravelAgency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reservationTravelAgencyItem) {
            // validation for constraint: itemType
            if (!$reservationTravelAgencyItem instanceof \StructType\TravelAgency_1) {
                $invalidValues[] = is_object($reservationTravelAgencyItem) ? get_class($reservationTravelAgencyItem) : sprintf('%s(%s)', gettype($reservationTravelAgencyItem), var_export($reservationTravelAgencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelAgency property can only contain items of type \StructType\TravelAgency_1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelAgency value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelAgency_1[] $travelAgency
     * @return \StructType\Reservation_1
     */
    public function setTravelAgency(array $travelAgency = array())
    {
        // validation for constraint: array
        if ('' !== ($travelAgencyArrayErrorMessage = self::validateTravelAgencyForArrayConstraintsFromSetTravelAgency($travelAgency))) {
            throw new \InvalidArgumentException($travelAgencyArrayErrorMessage, __LINE__);
        }
        $this->TravelAgency = $travelAgency;
        return $this;
    }
    /**
     * Add item to TravelAgency value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelAgency_1 $item
     * @return \StructType\Reservation_1
     */
    public function addToTravelAgency(\StructType\TravelAgency_1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TravelAgency_1) {
            throw new \InvalidArgumentException(sprintf('The TravelAgency property can only contain items of type \StructType\TravelAgency_1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TravelAgency[] = $item;
        return $this;
    }
    /**
     * Get TravelPoint value
     * @return \StructType\TravelPoint_1[]|null
     */
    public function getTravelPoint()
    {
        return $this->TravelPoint;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelPoint method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelPoint method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelPointForArrayConstraintsFromSetTravelPoint(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reservationTravelPointItem) {
            // validation for constraint: itemType
            if (!$reservationTravelPointItem instanceof \StructType\TravelPoint_1) {
                $invalidValues[] = is_object($reservationTravelPointItem) ? get_class($reservationTravelPointItem) : sprintf('%s(%s)', gettype($reservationTravelPointItem), var_export($reservationTravelPointItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelPoint property can only contain items of type \StructType\TravelPoint_1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelPoint value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelPoint_1[] $travelPoint
     * @return \StructType\Reservation_1
     */
    public function setTravelPoint(array $travelPoint = array())
    {
        // validation for constraint: array
        if ('' !== ($travelPointArrayErrorMessage = self::validateTravelPointForArrayConstraintsFromSetTravelPoint($travelPoint))) {
            throw new \InvalidArgumentException($travelPointArrayErrorMessage, __LINE__);
        }
        $this->TravelPoint = $travelPoint;
        return $this;
    }
    /**
     * Add item to TravelPoint value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelPoint_1 $item
     * @return \StructType\Reservation_1
     */
    public function addToTravelPoint(\StructType\TravelPoint_1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TravelPoint_1) {
            throw new \InvalidArgumentException(sprintf('The TravelPoint property can only contain items of type \StructType\TravelPoint_1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TravelPoint[] = $item;
        return $this;
    }
}
