<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResAccounts StructType
 * @subpackage Structs
 */
class ResAccounts extends AbstractStructBase
{
    /**
     * The DepositAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DepositAccount[]
     */
    public $DepositAccount;
    /**
     * Constructor method for ResAccounts
     * @uses ResAccounts::setDepositAccount()
     * @param \StructType\DepositAccount[] $depositAccount
     */
    public function __construct(array $depositAccount = array())
    {
        $this
            ->setDepositAccount($depositAccount);
    }
    /**
     * Get DepositAccount value
     * @return \StructType\DepositAccount[]|null
     */
    public function getDepositAccount()
    {
        return $this->DepositAccount;
    }
    /**
     * This method is responsible for validating the values passed to the setDepositAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDepositAccount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDepositAccountForArrayConstraintsFromSetDepositAccount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resAccountsDepositAccountItem) {
            // validation for constraint: itemType
            if (!$resAccountsDepositAccountItem instanceof \StructType\DepositAccount) {
                $invalidValues[] = is_object($resAccountsDepositAccountItem) ? get_class($resAccountsDepositAccountItem) : sprintf('%s(%s)', gettype($resAccountsDepositAccountItem), var_export($resAccountsDepositAccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DepositAccount property can only contain items of type \StructType\DepositAccount, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DepositAccount value
     * @throws \InvalidArgumentException
     * @param \StructType\DepositAccount[] $depositAccount
     * @return \StructType\ResAccounts
     */
    public function setDepositAccount(array $depositAccount = array())
    {
        // validation for constraint: array
        if ('' !== ($depositAccountArrayErrorMessage = self::validateDepositAccountForArrayConstraintsFromSetDepositAccount($depositAccount))) {
            throw new \InvalidArgumentException($depositAccountArrayErrorMessage, __LINE__);
        }
        $this->DepositAccount = $depositAccount;
        return $this;
    }
    /**
     * Add item to DepositAccount value
     * @throws \InvalidArgumentException
     * @param \StructType\DepositAccount $item
     * @return \StructType\ResAccounts
     */
    public function addToDepositAccount(\StructType\DepositAccount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DepositAccount) {
            throw new \InvalidArgumentException(sprintf('The DepositAccount property can only contain items of type \StructType\DepositAccount, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DepositAccount[] = $item;
        return $this;
    }
}
