<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegistrationCard StructType
 * @subpackage Structs
 */
class RegistrationCard extends AbstractStructBase
{
    /**
     * The REGISTRATIONCARD_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $REGISTRATIONCARD_OBJID;
    /**
     * The signature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $signature;
    /**
     * The citytaxexceptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $citytaxexceptions;
    /**
     * The NamelistGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NamelistGroup[]
     */
    public $NamelistGroup;
    /**
     * The Namelist
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Namelist[]
     */
    public $Namelist;
    /**
     * Constructor method for RegistrationCard
     * @uses RegistrationCard::setREGISTRATIONCARD_OBJID()
     * @uses RegistrationCard::setSignature()
     * @uses RegistrationCard::setCitytaxexceptions()
     * @uses RegistrationCard::setNamelistGroup()
     * @uses RegistrationCard::setNamelist()
     * @param string $rEGISTRATIONCARD_OBJID
     * @param string $signature
     * @param string $citytaxexceptions
     * @param \StructType\NamelistGroup[] $namelistGroup
     * @param \StructType\Namelist[] $namelist
     */
    public function __construct($rEGISTRATIONCARD_OBJID = null, $signature = null, $citytaxexceptions = null, array $namelistGroup = array(), array $namelist = array())
    {
        $this
            ->setREGISTRATIONCARD_OBJID($rEGISTRATIONCARD_OBJID)
            ->setSignature($signature)
            ->setCitytaxexceptions($citytaxexceptions)
            ->setNamelistGroup($namelistGroup)
            ->setNamelist($namelist);
    }
    /**
     * Get REGISTRATIONCARD_OBJID value
     * @return string
     */
    public function getREGISTRATIONCARD_OBJID()
    {
        return $this->{'REGISTRATIONCARD-OBJID'};
    }
    /**
     * Set REGISTRATIONCARD_OBJID value
     * @param string $rEGISTRATIONCARD_OBJID
     * @return \StructType\RegistrationCard
     */
    public function setREGISTRATIONCARD_OBJID($rEGISTRATIONCARD_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rEGISTRATIONCARD_OBJID) && !is_string($rEGISTRATIONCARD_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rEGISTRATIONCARD_OBJID, true), gettype($rEGISTRATIONCARD_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rEGISTRATIONCARD_OBJID) && !preg_match('/([0-9])*/', $rEGISTRATIONCARD_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rEGISTRATIONCARD_OBJID, true)), __LINE__);
        }
        $this->REGISTRATIONCARD_OBJID = $this->{'REGISTRATIONCARD-OBJID'} = $rEGISTRATIONCARD_OBJID;
        return $this;
    }
    /**
     * Get signature value
     * @return string|null
     */
    public function getSignature()
    {
        return $this->signature;
    }
    /**
     * Set signature value
     * @param string $signature
     * @return \StructType\RegistrationCard
     */
    public function setSignature($signature = null)
    {
        // validation for constraint: string
        if (!is_null($signature) && !is_string($signature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signature, true), gettype($signature)), __LINE__);
        }
        $this->signature = $signature;
        return $this;
    }
    /**
     * Get citytaxexceptions value
     * @return string|null
     */
    public function getCitytaxexceptions()
    {
        return $this->citytaxexceptions;
    }
    /**
     * Set citytaxexceptions value
     * @param string $citytaxexceptions
     * @return \StructType\RegistrationCard
     */
    public function setCitytaxexceptions($citytaxexceptions = null)
    {
        // validation for constraint: string
        if (!is_null($citytaxexceptions) && !is_string($citytaxexceptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($citytaxexceptions, true), gettype($citytaxexceptions)), __LINE__);
        }
        $this->citytaxexceptions = $citytaxexceptions;
        return $this;
    }
    /**
     * Get NamelistGroup value
     * @return \StructType\NamelistGroup[]|null
     */
    public function getNamelistGroup()
    {
        return $this->NamelistGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setNamelistGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNamelistGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNamelistGroupForArrayConstraintsFromSetNamelistGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $registrationCardNamelistGroupItem) {
            // validation for constraint: itemType
            if (!$registrationCardNamelistGroupItem instanceof \StructType\NamelistGroup) {
                $invalidValues[] = is_object($registrationCardNamelistGroupItem) ? get_class($registrationCardNamelistGroupItem) : sprintf('%s(%s)', gettype($registrationCardNamelistGroupItem), var_export($registrationCardNamelistGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NamelistGroup property can only contain items of type \StructType\NamelistGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NamelistGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\NamelistGroup[] $namelistGroup
     * @return \StructType\RegistrationCard
     */
    public function setNamelistGroup(array $namelistGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($namelistGroupArrayErrorMessage = self::validateNamelistGroupForArrayConstraintsFromSetNamelistGroup($namelistGroup))) {
            throw new \InvalidArgumentException($namelistGroupArrayErrorMessage, __LINE__);
        }
        $this->NamelistGroup = $namelistGroup;
        return $this;
    }
    /**
     * Add item to NamelistGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\NamelistGroup $item
     * @return \StructType\RegistrationCard
     */
    public function addToNamelistGroup(\StructType\NamelistGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NamelistGroup) {
            throw new \InvalidArgumentException(sprintf('The NamelistGroup property can only contain items of type \StructType\NamelistGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NamelistGroup[] = $item;
        return $this;
    }
    /**
     * Get Namelist value
     * @return \StructType\Namelist[]|null
     */
    public function getNamelist()
    {
        return $this->Namelist;
    }
    /**
     * This method is responsible for validating the values passed to the setNamelist method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNamelist method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNamelistForArrayConstraintsFromSetNamelist(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $registrationCardNamelistItem) {
            // validation for constraint: itemType
            if (!$registrationCardNamelistItem instanceof \StructType\Namelist) {
                $invalidValues[] = is_object($registrationCardNamelistItem) ? get_class($registrationCardNamelistItem) : sprintf('%s(%s)', gettype($registrationCardNamelistItem), var_export($registrationCardNamelistItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Namelist property can only contain items of type \StructType\Namelist, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Namelist value
     * @throws \InvalidArgumentException
     * @param \StructType\Namelist[] $namelist
     * @return \StructType\RegistrationCard
     */
    public function setNamelist(array $namelist = array())
    {
        // validation for constraint: array
        if ('' !== ($namelistArrayErrorMessage = self::validateNamelistForArrayConstraintsFromSetNamelist($namelist))) {
            throw new \InvalidArgumentException($namelistArrayErrorMessage, __LINE__);
        }
        $this->Namelist = $namelist;
        return $this;
    }
    /**
     * Add item to Namelist value
     * @throws \InvalidArgumentException
     * @param \StructType\Namelist $item
     * @return \StructType\RegistrationCard
     */
    public function addToNamelist(\StructType\Namelist $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Namelist) {
            throw new \InvalidArgumentException(sprintf('The Namelist property can only contain items of type \StructType\Namelist, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Namelist[] = $item;
        return $this;
    }
}
