<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ROOMTOCLEAN StructType
 * @subpackage Structs
 */
class ROOMTOCLEAN extends AbstractStructBase
{
    /**
     * The ROOMTOCLEAN_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ROOMTOCLEAN_OBJID;
    /**
     * The hskarea
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $hskarea;
    /**
     * The shift
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $shift;
    /**
     * The hskcleaningpoints
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hskcleaningpoints;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $category;
    /**
     * The housekeepingstatus
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $housekeepingstatus;
    /**
     * The soaprhythm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $soaprhythm;
    /**
     * The towelrhythm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $towelrhythm;
    /**
     * The linenrhythm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $linenrhythm;
    /**
     * The soapbedrhythm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $soapbedrhythm;
    /**
     * The towelbedrhythm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $towelbedrhythm;
    /**
     * The linenbedrhythm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $linenbedrhythm;
    /**
     * The hskservices
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 160
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $hskservices;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $comment;
    /**
     * The ARRIVAL
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ARRIVAL
     */
    public $ARRIVAL;
    /**
     * The STAY
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\STAY
     */
    public $STAY;
    /**
     * The DEPARTURE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\DEPARTURE
     */
    public $DEPARTURE;
    /**
     * The ROOM
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ROOM_2[]
     */
    public $ROOM;
    /**
     * Constructor method for ROOMTOCLEAN
     * @uses ROOMTOCLEAN::setROOMTOCLEAN_OBJID()
     * @uses ROOMTOCLEAN::setHskarea()
     * @uses ROOMTOCLEAN::setShift()
     * @uses ROOMTOCLEAN::setHskcleaningpoints()
     * @uses ROOMTOCLEAN::setCategory()
     * @uses ROOMTOCLEAN::setHousekeepingstatus()
     * @uses ROOMTOCLEAN::setSoaprhythm()
     * @uses ROOMTOCLEAN::setTowelrhythm()
     * @uses ROOMTOCLEAN::setLinenrhythm()
     * @uses ROOMTOCLEAN::setSoapbedrhythm()
     * @uses ROOMTOCLEAN::setTowelbedrhythm()
     * @uses ROOMTOCLEAN::setLinenbedrhythm()
     * @uses ROOMTOCLEAN::setHskservices()
     * @uses ROOMTOCLEAN::setComment()
     * @uses ROOMTOCLEAN::setARRIVAL()
     * @uses ROOMTOCLEAN::setSTAY()
     * @uses ROOMTOCLEAN::setDEPARTURE()
     * @uses ROOMTOCLEAN::setROOM()
     * @param string $rOOMTOCLEAN_OBJID
     * @param string $hskarea
     * @param string $shift
     * @param string $hskcleaningpoints
     * @param string $category
     * @param string $housekeepingstatus
     * @param string $soaprhythm
     * @param string $towelrhythm
     * @param string $linenrhythm
     * @param string $soapbedrhythm
     * @param string $towelbedrhythm
     * @param string $linenbedrhythm
     * @param string $hskservices
     * @param string $comment
     * @param \StructType\ARRIVAL $aRRIVAL
     * @param \StructType\STAY $sTAY
     * @param \StructType\DEPARTURE $dEPARTURE
     * @param \StructType\ROOM_2[] $rOOM
     */
    public function __construct($rOOMTOCLEAN_OBJID = null, $hskarea = null, $shift = null, $hskcleaningpoints = null, $category = null, $housekeepingstatus = null, $soaprhythm = null, $towelrhythm = null, $linenrhythm = null, $soapbedrhythm = null, $towelbedrhythm = null, $linenbedrhythm = null, $hskservices = null, $comment = null, \StructType\ARRIVAL $aRRIVAL = null, \StructType\STAY $sTAY = null, \StructType\DEPARTURE $dEPARTURE = null, array $rOOM = array())
    {
        $this
            ->setROOMTOCLEAN_OBJID($rOOMTOCLEAN_OBJID)
            ->setHskarea($hskarea)
            ->setShift($shift)
            ->setHskcleaningpoints($hskcleaningpoints)
            ->setCategory($category)
            ->setHousekeepingstatus($housekeepingstatus)
            ->setSoaprhythm($soaprhythm)
            ->setTowelrhythm($towelrhythm)
            ->setLinenrhythm($linenrhythm)
            ->setSoapbedrhythm($soapbedrhythm)
            ->setTowelbedrhythm($towelbedrhythm)
            ->setLinenbedrhythm($linenbedrhythm)
            ->setHskservices($hskservices)
            ->setComment($comment)
            ->setARRIVAL($aRRIVAL)
            ->setSTAY($sTAY)
            ->setDEPARTURE($dEPARTURE)
            ->setROOM($rOOM);
    }
    /**
     * Get ROOMTOCLEAN_OBJID value
     * @return string
     */
    public function getROOMTOCLEAN_OBJID()
    {
        return $this->{'ROOMTOCLEAN-OBJID'};
    }
    /**
     * Set ROOMTOCLEAN_OBJID value
     * @param string $rOOMTOCLEAN_OBJID
     * @return \StructType\ROOMTOCLEAN
     */
    public function setROOMTOCLEAN_OBJID($rOOMTOCLEAN_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rOOMTOCLEAN_OBJID) && !is_string($rOOMTOCLEAN_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOOMTOCLEAN_OBJID, true), gettype($rOOMTOCLEAN_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rOOMTOCLEAN_OBJID) && !preg_match('/([0-9])*/', $rOOMTOCLEAN_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rOOMTOCLEAN_OBJID, true)), __LINE__);
        }
        $this->ROOMTOCLEAN_OBJID = $this->{'ROOMTOCLEAN-OBJID'} = $rOOMTOCLEAN_OBJID;
        return $this;
    }
    /**
     * Get hskarea value
     * @return string
     */
    public function getHskarea()
    {
        return $this->hskarea;
    }
    /**
     * Set hskarea value
     * @param string $hskarea
     * @return \StructType\ROOMTOCLEAN
     */
    public function setHskarea($hskarea = null)
    {
        // validation for constraint: string
        if (!is_null($hskarea) && !is_string($hskarea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hskarea, true), gettype($hskarea)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($hskarea) && mb_strlen($hskarea) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($hskarea)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($hskarea) && mb_strlen($hskarea) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($hskarea)), __LINE__);
        }
        $this->hskarea = $hskarea;
        return $this;
    }
    /**
     * Get shift value
     * @return string
     */
    public function getShift()
    {
        return $this->shift;
    }
    /**
     * Set shift value
     * @param string $shift
     * @return \StructType\ROOMTOCLEAN
     */
    public function setShift($shift = null)
    {
        // validation for constraint: string
        if (!is_null($shift) && !is_string($shift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shift, true), gettype($shift)), __LINE__);
        }
        $this->shift = $shift;
        return $this;
    }
    /**
     * Get hskcleaningpoints value
     * @return string
     */
    public function getHskcleaningpoints()
    {
        return $this->hskcleaningpoints;
    }
    /**
     * Set hskcleaningpoints value
     * @param string $hskcleaningpoints
     * @return \StructType\ROOMTOCLEAN
     */
    public function setHskcleaningpoints($hskcleaningpoints = null)
    {
        // validation for constraint: string
        if (!is_null($hskcleaningpoints) && !is_string($hskcleaningpoints)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hskcleaningpoints, true), gettype($hskcleaningpoints)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hskcleaningpoints) && !preg_match('/([-+]){0,1}([0-9])*/', $hskcleaningpoints)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hskcleaningpoints, true)), __LINE__);
        }
        $this->hskcleaningpoints = $hskcleaningpoints;
        return $this;
    }
    /**
     * Get category value
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\ROOMTOCLEAN
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($category) && mb_strlen($category) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($category)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($category) && mb_strlen($category) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get housekeepingstatus value
     * @return string
     */
    public function getHousekeepingstatus()
    {
        return $this->housekeepingstatus;
    }
    /**
     * Set housekeepingstatus value
     * @param string $housekeepingstatus
     * @return \StructType\ROOMTOCLEAN
     */
    public function setHousekeepingstatus($housekeepingstatus = null)
    {
        // validation for constraint: string
        if (!is_null($housekeepingstatus) && !is_string($housekeepingstatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($housekeepingstatus, true), gettype($housekeepingstatus)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($housekeepingstatus) && mb_strlen($housekeepingstatus) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($housekeepingstatus)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($housekeepingstatus) && mb_strlen($housekeepingstatus) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($housekeepingstatus)), __LINE__);
        }
        $this->housekeepingstatus = $housekeepingstatus;
        return $this;
    }
    /**
     * Get soaprhythm value
     * @return string
     */
    public function getSoaprhythm()
    {
        return $this->soaprhythm;
    }
    /**
     * Set soaprhythm value
     * @param string $soaprhythm
     * @return \StructType\ROOMTOCLEAN
     */
    public function setSoaprhythm($soaprhythm = null)
    {
        // validation for constraint: string
        if (!is_null($soaprhythm) && !is_string($soaprhythm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($soaprhythm, true), gettype($soaprhythm)), __LINE__);
        }
        $this->soaprhythm = $soaprhythm;
        return $this;
    }
    /**
     * Get towelrhythm value
     * @return string
     */
    public function getTowelrhythm()
    {
        return $this->towelrhythm;
    }
    /**
     * Set towelrhythm value
     * @param string $towelrhythm
     * @return \StructType\ROOMTOCLEAN
     */
    public function setTowelrhythm($towelrhythm = null)
    {
        // validation for constraint: string
        if (!is_null($towelrhythm) && !is_string($towelrhythm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($towelrhythm, true), gettype($towelrhythm)), __LINE__);
        }
        $this->towelrhythm = $towelrhythm;
        return $this;
    }
    /**
     * Get linenrhythm value
     * @return string
     */
    public function getLinenrhythm()
    {
        return $this->linenrhythm;
    }
    /**
     * Set linenrhythm value
     * @param string $linenrhythm
     * @return \StructType\ROOMTOCLEAN
     */
    public function setLinenrhythm($linenrhythm = null)
    {
        // validation for constraint: string
        if (!is_null($linenrhythm) && !is_string($linenrhythm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linenrhythm, true), gettype($linenrhythm)), __LINE__);
        }
        $this->linenrhythm = $linenrhythm;
        return $this;
    }
    /**
     * Get soapbedrhythm value
     * @return string
     */
    public function getSoapbedrhythm()
    {
        return $this->soapbedrhythm;
    }
    /**
     * Set soapbedrhythm value
     * @param string $soapbedrhythm
     * @return \StructType\ROOMTOCLEAN
     */
    public function setSoapbedrhythm($soapbedrhythm = null)
    {
        // validation for constraint: string
        if (!is_null($soapbedrhythm) && !is_string($soapbedrhythm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($soapbedrhythm, true), gettype($soapbedrhythm)), __LINE__);
        }
        $this->soapbedrhythm = $soapbedrhythm;
        return $this;
    }
    /**
     * Get towelbedrhythm value
     * @return string
     */
    public function getTowelbedrhythm()
    {
        return $this->towelbedrhythm;
    }
    /**
     * Set towelbedrhythm value
     * @param string $towelbedrhythm
     * @return \StructType\ROOMTOCLEAN
     */
    public function setTowelbedrhythm($towelbedrhythm = null)
    {
        // validation for constraint: string
        if (!is_null($towelbedrhythm) && !is_string($towelbedrhythm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($towelbedrhythm, true), gettype($towelbedrhythm)), __LINE__);
        }
        $this->towelbedrhythm = $towelbedrhythm;
        return $this;
    }
    /**
     * Get linenbedrhythm value
     * @return string
     */
    public function getLinenbedrhythm()
    {
        return $this->linenbedrhythm;
    }
    /**
     * Set linenbedrhythm value
     * @param string $linenbedrhythm
     * @return \StructType\ROOMTOCLEAN
     */
    public function setLinenbedrhythm($linenbedrhythm = null)
    {
        // validation for constraint: string
        if (!is_null($linenbedrhythm) && !is_string($linenbedrhythm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linenbedrhythm, true), gettype($linenbedrhythm)), __LINE__);
        }
        $this->linenbedrhythm = $linenbedrhythm;
        return $this;
    }
    /**
     * Get hskservices value
     * @return string
     */
    public function getHskservices()
    {
        return $this->hskservices;
    }
    /**
     * Set hskservices value
     * @param string $hskservices
     * @return \StructType\ROOMTOCLEAN
     */
    public function setHskservices($hskservices = null)
    {
        // validation for constraint: string
        if (!is_null($hskservices) && !is_string($hskservices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hskservices, true), gettype($hskservices)), __LINE__);
        }
        // validation for constraint: maxLength(160)
        if (!is_null($hskservices) && mb_strlen($hskservices) > 160) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 160', mb_strlen($hskservices)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($hskservices) && mb_strlen($hskservices) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($hskservices)), __LINE__);
        }
        $this->hskservices = $hskservices;
        return $this;
    }
    /**
     * Get comment value
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\ROOMTOCLEAN
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($comment) && mb_strlen($comment) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($comment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($comment) && mb_strlen($comment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get ARRIVAL value
     * @return \StructType\ARRIVAL
     */
    public function getARRIVAL()
    {
        return $this->ARRIVAL;
    }
    /**
     * Set ARRIVAL value
     * @param \StructType\ARRIVAL $aRRIVAL
     * @return \StructType\ROOMTOCLEAN
     */
    public function setARRIVAL(\StructType\ARRIVAL $aRRIVAL = null)
    {
        $this->ARRIVAL = $aRRIVAL;
        return $this;
    }
    /**
     * Get STAY value
     * @return \StructType\STAY
     */
    public function getSTAY()
    {
        return $this->STAY;
    }
    /**
     * Set STAY value
     * @param \StructType\STAY $sTAY
     * @return \StructType\ROOMTOCLEAN
     */
    public function setSTAY(\StructType\STAY $sTAY = null)
    {
        $this->STAY = $sTAY;
        return $this;
    }
    /**
     * Get DEPARTURE value
     * @return \StructType\DEPARTURE
     */
    public function getDEPARTURE()
    {
        return $this->DEPARTURE;
    }
    /**
     * Set DEPARTURE value
     * @param \StructType\DEPARTURE $dEPARTURE
     * @return \StructType\ROOMTOCLEAN
     */
    public function setDEPARTURE(\StructType\DEPARTURE $dEPARTURE = null)
    {
        $this->DEPARTURE = $dEPARTURE;
        return $this;
    }
    /**
     * Get ROOM value
     * @return \StructType\ROOM_2[]|null
     */
    public function getROOM()
    {
        return $this->ROOM;
    }
    /**
     * This method is responsible for validating the values passed to the setROOM method
     * This method is willingly generated in order to preserve the one-line inline validation within the setROOM method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateROOMForArrayConstraintsFromSetROOM(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rOOMTOCLEANROOMItem) {
            // validation for constraint: itemType
            if (!$rOOMTOCLEANROOMItem instanceof \StructType\ROOM_2) {
                $invalidValues[] = is_object($rOOMTOCLEANROOMItem) ? get_class($rOOMTOCLEANROOMItem) : sprintf('%s(%s)', gettype($rOOMTOCLEANROOMItem), var_export($rOOMTOCLEANROOMItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ROOM property can only contain items of type \StructType\ROOM_2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ROOM value
     * @throws \InvalidArgumentException
     * @param \StructType\ROOM_2[] $rOOM
     * @return \StructType\ROOMTOCLEAN
     */
    public function setROOM(array $rOOM = array())
    {
        // validation for constraint: array
        if ('' !== ($rOOMArrayErrorMessage = self::validateROOMForArrayConstraintsFromSetROOM($rOOM))) {
            throw new \InvalidArgumentException($rOOMArrayErrorMessage, __LINE__);
        }
        $this->ROOM = $rOOM;
        return $this;
    }
    /**
     * Add item to ROOM value
     * @throws \InvalidArgumentException
     * @param \StructType\ROOM_2 $item
     * @return \StructType\ROOMTOCLEAN
     */
    public function addToROOM(\StructType\ROOM_2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ROOM_2) {
            throw new \InvalidArgumentException(sprintf('The ROOM property can only contain items of type \StructType\ROOM_2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ROOM[] = $item;
        return $this;
    }
}
