<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RESERVATION-GROUP StructType
 * @subpackage Structs
 */
class RESERVATION_GROUP extends AbstractStructBase
{
    /**
     * The RESERVATION_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $RESERVATION_OBJID;
    /**
     * Constructor method for RESERVATION-GROUP
     * @uses RESERVATION_GROUP::setRESERVATION_OBJID()
     * @param string $rESERVATION_OBJID
     */
    public function __construct($rESERVATION_OBJID = null)
    {
        $this
            ->setRESERVATION_OBJID($rESERVATION_OBJID);
    }
    /**
     * Get RESERVATION_OBJID value
     * @return string
     */
    public function getRESERVATION_OBJID()
    {
        return $this->{'RESERVATION-OBJID'};
    }
    /**
     * Set RESERVATION_OBJID value
     * @param string $rESERVATION_OBJID
     * @return \StructType\RESERVATION_GROUP
     */
    public function setRESERVATION_OBJID($rESERVATION_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rESERVATION_OBJID) && !is_string($rESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rESERVATION_OBJID, true), gettype($rESERVATION_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rESERVATION_OBJID) && !preg_match('/([0-9])*/', $rESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rESERVATION_OBJID, true)), __LINE__);
        }
        $this->RESERVATION_OBJID = $this->{'RESERVATION-OBJID'} = $rESERVATION_OBJID;
        return $this;
    }
}
