<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RESERVATION StructType
 * @subpackage Structs
 */
class RESERVATION extends AbstractStructBase
{
    /**
     * The RESERVATION_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $RESERVATION_OBJID;
    /**
     * The RESERVATION_CENTRALID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $RESERVATION_CENTRALID;
    /**
     * The resno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $resno;
    /**
     * The hotel
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hotel;
    /**
     * The subno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $subno;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $category;
    /**
     * The ratecategory
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ratecategory;
    /**
     * The ratesegment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ratesegment;
    /**
     * The restype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $restype;
    /**
     * The arrival
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $arrival;
    /**
     * The departure
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $departure;
    /**
     * The noofrooms
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofrooms;
    /**
     * The noofpax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofpax;
    /**
     * The paymentinstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $paymentinstructions;
    /**
     * The cancellationdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $cancellationdate;
    /**
     * The noofnights
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofnights;
    /**
     * The arrivaltime
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $arrivaltime;
    /**
     * The departuretime
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $departuretime;
    /**
     * The gdsresnumber
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $gdsresnumber;
    /**
     * The externalid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $externalid;
    /**
     * The externalkey
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $externalkey;
    /**
     * The externalreference
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $externalreference;
    /**
     * The resmedium
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $resmedium;
    /**
     * The ressource
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ressource;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * The noofchildren
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofchildren;
    /**
     * The noofadults
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofadults;
    /**
     * The commenttechnical
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $commenttechnical;
    /**
     * The commentcentral
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $commentcentral;
    /**
     * The discountgroup
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $discountgroup;
    /**
     * The DEPOSIT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\DEPOSIT
     */
    public $DEPOSIT;
    /**
     * The forecastnoofadults
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $forecastnoofadults;
    /**
     * The forecastnoofchildren
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $forecastnoofchildren;
    /**
     * The forecastnoofpax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $forecastnoofpax;
    /**
     * The forecastrategross
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $forecastrategross;
    /**
     * The forecastratenet
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $forecastratenet;
    /**
     * The deposit
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $deposit;
    /**
     * The hasautoservice
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hasautoservice;
    /**
     * The RESERVATIONPACKAGES
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RESERVATIONPACKAGES
     */
    public $RESERVATIONPACKAGES;
    /**
     * The EXTERNALIDS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\EXTERNALIDS
     */
    public $EXTERNALIDS;
    /**
     * The ROOMS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ROOMS
     */
    public $ROOMS;
    /**
     * The ratesfixed
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $ratesfixed;
    /**
     * The internalrestype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $internalrestype;
    /**
     * The CARD
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CARD
     */
    public $CARD;
    /**
     * The marketsegment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $marketsegment;
    /**
     * The packages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packages;
    /**
     * The guesttype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $guesttype;
    /**
     * The optiontodate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $optiontodate;
    /**
     * The channel
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $channel;
    /**
     * The nn1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $nn1;
    /**
     * The commentadditional
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $commentadditional;
    /**
     * The note
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $note;
    /**
     * The rateassignedto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $rateassignedto;
    /**
     * The ORDERER
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ORDERER[]
     */
    public $ORDERER;
    /**
     * The TRAVELAGENCY
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TRAVELAGENCY
     */
    public $TRAVELAGENCY;
    /**
     * The TRAVELPOINT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TRAVELPOINT
     */
    public $TRAVELPOINT;
    /**
     * The ORDERERCONTACTPERSON
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORDERERCONTACTPERSON
     */
    public $ORDERERCONTACTPERSON;
    /**
     * The TRAVELAGENCYCONTACTPERSON
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TRAVELAGENCYCONTACTPERSON
     */
    public $TRAVELAGENCYCONTACTPERSON;
    /**
     * The TRAVELPOINTCONTACTPERSON
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TRAVELPOINTCONTACTPERSON
     */
    public $TRAVELPOINTCONTACTPERSON;
    /**
     * The commentinternet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $commentinternet;
    /**
     * The commentinvoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $commentinvoice;
    /**
     * The payminstrautoservice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $payminstrautoservice;
    /**
     * The duedate1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $duedate1;
    /**
     * The amount1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amount1;
    /**
     * The duedate2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $duedate2;
    /**
     * The amount2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amount2;
    /**
     * The duedate3
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $duedate3;
    /**
     * The amount3
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amount3;
    /**
     * The ROOM
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ROOM_2[]
     */
    public $ROOM;
    /**
     * Constructor method for RESERVATION
     * @uses RESERVATION::setRESERVATION_OBJID()
     * @uses RESERVATION::setRESERVATION_CENTRALID()
     * @uses RESERVATION::setResno()
     * @uses RESERVATION::setHotel()
     * @uses RESERVATION::setSubno()
     * @uses RESERVATION::setCategory()
     * @uses RESERVATION::setRatecategory()
     * @uses RESERVATION::setRatesegment()
     * @uses RESERVATION::setRestype()
     * @uses RESERVATION::setArrival()
     * @uses RESERVATION::setDeparture()
     * @uses RESERVATION::setNoofrooms()
     * @uses RESERVATION::setNoofpax()
     * @uses RESERVATION::setPaymentinstructions()
     * @uses RESERVATION::setCancellationdate()
     * @uses RESERVATION::setNoofnights()
     * @uses RESERVATION::setArrivaltime()
     * @uses RESERVATION::setDeparturetime()
     * @uses RESERVATION::setGdsresnumber()
     * @uses RESERVATION::setExternalid()
     * @uses RESERVATION::setExternalkey()
     * @uses RESERVATION::setExternalreference()
     * @uses RESERVATION::setResmedium()
     * @uses RESERVATION::setRessource()
     * @uses RESERVATION::setCurrency()
     * @uses RESERVATION::setNoofchildren()
     * @uses RESERVATION::setNoofadults()
     * @uses RESERVATION::setCommenttechnical()
     * @uses RESERVATION::setCommentcentral()
     * @uses RESERVATION::setDiscountgroup()
     * @uses RESERVATION::setDEPOSIT()
     * @uses RESERVATION::setForecastnoofadults()
     * @uses RESERVATION::setForecastnoofchildren()
     * @uses RESERVATION::setForecastnoofpax()
     * @uses RESERVATION::setForecastrategross()
     * @uses RESERVATION::setForecastratenet()
     * @uses RESERVATION::setDeposit_1()
     * @uses RESERVATION::setHasautoservice()
     * @uses RESERVATION::setRESERVATIONPACKAGES()
     * @uses RESERVATION::setEXTERNALIDS()
     * @uses RESERVATION::setROOMS()
     * @uses RESERVATION::setRatesfixed()
     * @uses RESERVATION::setInternalrestype()
     * @uses RESERVATION::setCARD()
     * @uses RESERVATION::setMarketsegment()
     * @uses RESERVATION::setPackages()
     * @uses RESERVATION::setGuesttype()
     * @uses RESERVATION::setOptiontodate()
     * @uses RESERVATION::setChannel()
     * @uses RESERVATION::setNn1()
     * @uses RESERVATION::setCommentadditional()
     * @uses RESERVATION::setNote()
     * @uses RESERVATION::setRateassignedto()
     * @uses RESERVATION::setORDERER()
     * @uses RESERVATION::setTRAVELAGENCY()
     * @uses RESERVATION::setTRAVELPOINT()
     * @uses RESERVATION::setORDERERCONTACTPERSON()
     * @uses RESERVATION::setTRAVELAGENCYCONTACTPERSON()
     * @uses RESERVATION::setTRAVELPOINTCONTACTPERSON()
     * @uses RESERVATION::setCommentinternet()
     * @uses RESERVATION::setCommentinvoice()
     * @uses RESERVATION::setPayminstrautoservice()
     * @uses RESERVATION::setDuedate1()
     * @uses RESERVATION::setAmount1()
     * @uses RESERVATION::setDuedate2()
     * @uses RESERVATION::setAmount2()
     * @uses RESERVATION::setDuedate3()
     * @uses RESERVATION::setAmount3()
     * @uses RESERVATION::setROOM()
     * @param string $rESERVATION_OBJID
     * @param string $rESERVATION_CENTRALID
     * @param string $resno
     * @param string $hotel
     * @param string $subno
     * @param string $category
     * @param string $ratecategory
     * @param string $ratesegment
     * @param string $restype
     * @param string $arrival
     * @param string $departure
     * @param string $noofrooms
     * @param string $noofpax
     * @param string $paymentinstructions
     * @param string $cancellationdate
     * @param string $noofnights
     * @param string $arrivaltime
     * @param string $departuretime
     * @param string $gdsresnumber
     * @param string $externalid
     * @param string $externalkey
     * @param string $externalreference
     * @param string $resmedium
     * @param string $ressource
     * @param string $currency
     * @param string $noofchildren
     * @param string $noofadults
     * @param string $commenttechnical
     * @param string $commentcentral
     * @param string $discountgroup
     * @param \StructType\DEPOSIT $dEPOSIT
     * @param string $forecastnoofadults
     * @param string $forecastnoofchildren
     * @param string $forecastnoofpax
     * @param string $forecastrategross
     * @param string $forecastratenet
     * @param string $deposit
     * @param string $hasautoservice
     * @param \StructType\RESERVATIONPACKAGES $rESERVATIONPACKAGES
     * @param \StructType\EXTERNALIDS $eXTERNALIDS
     * @param \StructType\ROOMS $rOOMS
     * @param string $ratesfixed
     * @param string $internalrestype
     * @param \StructType\CARD $cARD
     * @param string $marketsegment
     * @param string $packages
     * @param string $guesttype
     * @param string $optiontodate
     * @param string $channel
     * @param string $nn1
     * @param string $commentadditional
     * @param string $note
     * @param string $rateassignedto
     * @param \StructType\ORDERER[] $oRDERER
     * @param \StructType\TRAVELAGENCY $tRAVELAGENCY
     * @param \StructType\TRAVELPOINT $tRAVELPOINT
     * @param \StructType\ORDERERCONTACTPERSON $oRDERERCONTACTPERSON
     * @param \StructType\TRAVELAGENCYCONTACTPERSON $tRAVELAGENCYCONTACTPERSON
     * @param \StructType\TRAVELPOINTCONTACTPERSON $tRAVELPOINTCONTACTPERSON
     * @param string $commentinternet
     * @param string $commentinvoice
     * @param string $payminstrautoservice
     * @param string $duedate1
     * @param string $amount1
     * @param string $duedate2
     * @param string $amount2
     * @param string $duedate3
     * @param string $amount3
     * @param \StructType\ROOM_2[] $rOOM
     */
    public function __construct($rESERVATION_OBJID = null, $rESERVATION_CENTRALID = null, $resno = null, $hotel = null, $subno = null, $category = null, $ratecategory = null, $ratesegment = null, $restype = null, $arrival = null, $departure = null, $noofrooms = null, $noofpax = null, $paymentinstructions = null, $cancellationdate = null, $noofnights = null, $arrivaltime = null, $departuretime = null, $gdsresnumber = null, $externalid = null, $externalkey = null, $externalreference = null, $resmedium = null, $ressource = null, $currency = null, $noofchildren = null, $noofadults = null, $commenttechnical = null, $commentcentral = null, $discountgroup = null, \StructType\DEPOSIT $dEPOSIT = null, $forecastnoofadults = null, $forecastnoofchildren = null, $forecastnoofpax = null, $forecastrategross = null, $forecastratenet = null, $deposit_1 = null, $hasautoservice = null, \StructType\RESERVATIONPACKAGES $rESERVATIONPACKAGES = null, \StructType\EXTERNALIDS $eXTERNALIDS = null, \StructType\ROOMS $rOOMS = null, $ratesfixed = null, $internalrestype = null, \StructType\CARD $cARD = null, $marketsegment = null, $packages = null, $guesttype = null, $optiontodate = null, $channel = null, $nn1 = null, $commentadditional = null, $note = null, $rateassignedto = null, array $oRDERER = array(), \StructType\TRAVELAGENCY $tRAVELAGENCY = null, \StructType\TRAVELPOINT $tRAVELPOINT = null, \StructType\ORDERERCONTACTPERSON $oRDERERCONTACTPERSON = null, \StructType\TRAVELAGENCYCONTACTPERSON $tRAVELAGENCYCONTACTPERSON = null, \StructType\TRAVELPOINTCONTACTPERSON $tRAVELPOINTCONTACTPERSON = null, $commentinternet = null, $commentinvoice = null, $payminstrautoservice = null, $duedate1 = null, $amount1 = null, $duedate2 = null, $amount2 = null, $duedate3 = null, $amount3 = null, array $rOOM = array())
    {
        $this
            ->setRESERVATION_OBJID($rESERVATION_OBJID)
            ->setRESERVATION_CENTRALID($rESERVATION_CENTRALID)
            ->setResno($resno)
            ->setHotel($hotel)
            ->setSubno($subno)
            ->setCategory($category)
            ->setRatecategory($ratecategory)
            ->setRatesegment($ratesegment)
            ->setRestype($restype)
            ->setArrival($arrival)
            ->setDeparture($departure)
            ->setNoofrooms($noofrooms)
            ->setNoofpax($noofpax)
            ->setPaymentinstructions($paymentinstructions)
            ->setCancellationdate($cancellationdate)
            ->setNoofnights($noofnights)
            ->setArrivaltime($arrivaltime)
            ->setDeparturetime($departuretime)
            ->setGdsresnumber($gdsresnumber)
            ->setExternalid($externalid)
            ->setExternalkey($externalkey)
            ->setExternalreference($externalreference)
            ->setResmedium($resmedium)
            ->setRessource($ressource)
            ->setCurrency($currency)
            ->setNoofchildren($noofchildren)
            ->setNoofadults($noofadults)
            ->setCommenttechnical($commenttechnical)
            ->setCommentcentral($commentcentral)
            ->setDiscountgroup($discountgroup)
            ->setDEPOSIT($dEPOSIT)
            ->setForecastnoofadults($forecastnoofadults)
            ->setForecastnoofchildren($forecastnoofchildren)
            ->setForecastnoofpax($forecastnoofpax)
            ->setForecastrategross($forecastrategross)
            ->setForecastratenet($forecastratenet)
            ->setDeposit_1($deposit_1)
            ->setHasautoservice($hasautoservice)
            ->setRESERVATIONPACKAGES($rESERVATIONPACKAGES)
            ->setEXTERNALIDS($eXTERNALIDS)
            ->setROOMS($rOOMS)
            ->setRatesfixed($ratesfixed)
            ->setInternalrestype($internalrestype)
            ->setCARD($cARD)
            ->setMarketsegment($marketsegment)
            ->setPackages($packages)
            ->setGuesttype($guesttype)
            ->setOptiontodate($optiontodate)
            ->setChannel($channel)
            ->setNn1($nn1)
            ->setCommentadditional($commentadditional)
            ->setNote($note)
            ->setRateassignedto($rateassignedto)
            ->setORDERER($oRDERER)
            ->setTRAVELAGENCY($tRAVELAGENCY)
            ->setTRAVELPOINT($tRAVELPOINT)
            ->setORDERERCONTACTPERSON($oRDERERCONTACTPERSON)
            ->setTRAVELAGENCYCONTACTPERSON($tRAVELAGENCYCONTACTPERSON)
            ->setTRAVELPOINTCONTACTPERSON($tRAVELPOINTCONTACTPERSON)
            ->setCommentinternet($commentinternet)
            ->setCommentinvoice($commentinvoice)
            ->setPayminstrautoservice($payminstrautoservice)
            ->setDuedate1($duedate1)
            ->setAmount1($amount1)
            ->setDuedate2($duedate2)
            ->setAmount2($amount2)
            ->setDuedate3($duedate3)
            ->setAmount3($amount3)
            ->setROOM($rOOM);
    }
    /**
     * Get RESERVATION_OBJID value
     * @return string
     */
    public function getRESERVATION_OBJID()
    {
        return $this->{'RESERVATION-OBJID'};
    }
    /**
     * Set RESERVATION_OBJID value
     * @param string $rESERVATION_OBJID
     * @return \StructType\RESERVATION
     */
    public function setRESERVATION_OBJID($rESERVATION_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rESERVATION_OBJID) && !is_string($rESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rESERVATION_OBJID, true), gettype($rESERVATION_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rESERVATION_OBJID) && !preg_match('/([0-9])*/', $rESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rESERVATION_OBJID, true)), __LINE__);
        }
        $this->RESERVATION_OBJID = $this->{'RESERVATION-OBJID'} = $rESERVATION_OBJID;
        return $this;
    }
    /**
     * Get RESERVATION_CENTRALID value
     * @return string
     */
    public function getRESERVATION_CENTRALID()
    {
        return $this->{'RESERVATION-CENTRALID'};
    }
    /**
     * Set RESERVATION_CENTRALID value
     * @param string $rESERVATION_CENTRALID
     * @return \StructType\RESERVATION
     */
    public function setRESERVATION_CENTRALID($rESERVATION_CENTRALID = null)
    {
        // validation for constraint: string
        if (!is_null($rESERVATION_CENTRALID) && !is_string($rESERVATION_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rESERVATION_CENTRALID, true), gettype($rESERVATION_CENTRALID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rESERVATION_CENTRALID) && !preg_match('/([0-9])*/', $rESERVATION_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rESERVATION_CENTRALID, true)), __LINE__);
        }
        $this->RESERVATION_CENTRALID = $this->{'RESERVATION-CENTRALID'} = $rESERVATION_CENTRALID;
        return $this;
    }
    /**
     * Get resno value
     * @return string
     */
    public function getResno()
    {
        return $this->resno;
    }
    /**
     * Set resno value
     * @param string $resno
     * @return \StructType\RESERVATION
     */
    public function setResno($resno = null)
    {
        // validation for constraint: string
        if (!is_null($resno) && !is_string($resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resno, true), gettype($resno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($resno) && !preg_match('/([-+]){0,1}([0-9])*/', $resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($resno, true)), __LINE__);
        }
        $this->resno = $resno;
        return $this;
    }
    /**
     * Get hotel value
     * @return string
     */
    public function getHotel()
    {
        return $this->hotel;
    }
    /**
     * Set hotel value
     * @param string $hotel
     * @return \StructType\RESERVATION
     */
    public function setHotel($hotel = null)
    {
        // validation for constraint: string
        if (!is_null($hotel) && !is_string($hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotel, true), gettype($hotel)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hotel) && !preg_match('/([-+]){0,1}([0-9])*/', $hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hotel, true)), __LINE__);
        }
        $this->hotel = $hotel;
        return $this;
    }
    /**
     * Get subno value
     * @return string
     */
    public function getSubno()
    {
        return $this->subno;
    }
    /**
     * Set subno value
     * @param string $subno
     * @return \StructType\RESERVATION
     */
    public function setSubno($subno = null)
    {
        // validation for constraint: string
        if (!is_null($subno) && !is_string($subno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subno, true), gettype($subno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($subno) && !preg_match('/([-+]){0,1}([0-9])*/', $subno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($subno, true)), __LINE__);
        }
        $this->subno = $subno;
        return $this;
    }
    /**
     * Get category value
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\RESERVATION
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($category) && mb_strlen($category) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($category)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($category) && mb_strlen($category) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get ratecategory value
     * @return string
     */
    public function getRatecategory()
    {
        return $this->ratecategory;
    }
    /**
     * Set ratecategory value
     * @param string $ratecategory
     * @return \StructType\RESERVATION
     */
    public function setRatecategory($ratecategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratecategory) && !is_string($ratecategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratecategory, true), gettype($ratecategory)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($ratecategory) && mb_strlen($ratecategory) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($ratecategory)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ratecategory) && mb_strlen($ratecategory) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ratecategory)), __LINE__);
        }
        $this->ratecategory = $ratecategory;
        return $this;
    }
    /**
     * Get ratesegment value
     * @return string
     */
    public function getRatesegment()
    {
        return $this->ratesegment;
    }
    /**
     * Set ratesegment value
     * @param string $ratesegment
     * @return \StructType\RESERVATION
     */
    public function setRatesegment($ratesegment = null)
    {
        // validation for constraint: string
        if (!is_null($ratesegment) && !is_string($ratesegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratesegment, true), gettype($ratesegment)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($ratesegment) && mb_strlen($ratesegment) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($ratesegment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ratesegment) && mb_strlen($ratesegment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ratesegment)), __LINE__);
        }
        $this->ratesegment = $ratesegment;
        return $this;
    }
    /**
     * Get restype value
     * @return string
     */
    public function getRestype()
    {
        return $this->restype;
    }
    /**
     * Set restype value
     * @param string $restype
     * @return \StructType\RESERVATION
     */
    public function setRestype($restype = null)
    {
        // validation for constraint: string
        if (!is_null($restype) && !is_string($restype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restype, true), gettype($restype)), __LINE__);
        }
        $this->restype = $restype;
        return $this;
    }
    /**
     * Get arrival value
     * @return string
     */
    public function getArrival()
    {
        return $this->arrival;
    }
    /**
     * Set arrival value
     * @param string $arrival
     * @return \StructType\RESERVATION
     */
    public function setArrival($arrival = null)
    {
        // validation for constraint: string
        if (!is_null($arrival) && !is_string($arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrival, true), gettype($arrival)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($arrival) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($arrival, true)), __LINE__);
        }
        $this->arrival = $arrival;
        return $this;
    }
    /**
     * Get departure value
     * @return string
     */
    public function getDeparture()
    {
        return $this->departure;
    }
    /**
     * Set departure value
     * @param string $departure
     * @return \StructType\RESERVATION
     */
    public function setDeparture($departure = null)
    {
        // validation for constraint: string
        if (!is_null($departure) && !is_string($departure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departure, true), gettype($departure)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($departure) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $departure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($departure, true)), __LINE__);
        }
        $this->departure = $departure;
        return $this;
    }
    /**
     * Get noofrooms value
     * @return string
     */
    public function getNoofrooms()
    {
        return $this->noofrooms;
    }
    /**
     * Set noofrooms value
     * @param string $noofrooms
     * @return \StructType\RESERVATION
     */
    public function setNoofrooms($noofrooms = null)
    {
        // validation for constraint: string
        if (!is_null($noofrooms) && !is_string($noofrooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofrooms, true), gettype($noofrooms)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofrooms) && !preg_match('/([-+]){0,1}([0-9])*/', $noofrooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofrooms, true)), __LINE__);
        }
        $this->noofrooms = $noofrooms;
        return $this;
    }
    /**
     * Get noofpax value
     * @return string
     */
    public function getNoofpax()
    {
        return $this->noofpax;
    }
    /**
     * Set noofpax value
     * @param string $noofpax
     * @return \StructType\RESERVATION
     */
    public function setNoofpax($noofpax = null)
    {
        // validation for constraint: string
        if (!is_null($noofpax) && !is_string($noofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofpax, true), gettype($noofpax)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofpax) && !preg_match('/([-+]){0,1}([0-9])*/', $noofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofpax, true)), __LINE__);
        }
        $this->noofpax = $noofpax;
        return $this;
    }
    /**
     * Get paymentinstructions value
     * @return string
     */
    public function getPaymentinstructions()
    {
        return $this->paymentinstructions;
    }
    /**
     * Set paymentinstructions value
     * @param string $paymentinstructions
     * @return \StructType\RESERVATION
     */
    public function setPaymentinstructions($paymentinstructions = null)
    {
        // validation for constraint: string
        if (!is_null($paymentinstructions) && !is_string($paymentinstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentinstructions, true), gettype($paymentinstructions)), __LINE__);
        }
        $this->paymentinstructions = $paymentinstructions;
        return $this;
    }
    /**
     * Get cancellationdate value
     * @return string
     */
    public function getCancellationdate()
    {
        return $this->cancellationdate;
    }
    /**
     * Set cancellationdate value
     * @param string $cancellationdate
     * @return \StructType\RESERVATION
     */
    public function setCancellationdate($cancellationdate = null)
    {
        // validation for constraint: string
        if (!is_null($cancellationdate) && !is_string($cancellationdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancellationdate, true), gettype($cancellationdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($cancellationdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $cancellationdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($cancellationdate, true)), __LINE__);
        }
        $this->cancellationdate = $cancellationdate;
        return $this;
    }
    /**
     * Get noofnights value
     * @return string
     */
    public function getNoofnights()
    {
        return $this->noofnights;
    }
    /**
     * Set noofnights value
     * @param string $noofnights
     * @return \StructType\RESERVATION
     */
    public function setNoofnights($noofnights = null)
    {
        // validation for constraint: string
        if (!is_null($noofnights) && !is_string($noofnights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofnights, true), gettype($noofnights)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofnights) && !preg_match('/([-+]){0,1}([0-9])*/', $noofnights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofnights, true)), __LINE__);
        }
        $this->noofnights = $noofnights;
        return $this;
    }
    /**
     * Get arrivaltime value
     * @return string
     */
    public function getArrivaltime()
    {
        return $this->arrivaltime;
    }
    /**
     * Set arrivaltime value
     * @param string $arrivaltime
     * @return \StructType\RESERVATION
     */
    public function setArrivaltime($arrivaltime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivaltime) && !is_string($arrivaltime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivaltime, true), gettype($arrivaltime)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($arrivaltime) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $arrivaltime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($arrivaltime, true)), __LINE__);
        }
        $this->arrivaltime = $arrivaltime;
        return $this;
    }
    /**
     * Get departuretime value
     * @return string
     */
    public function getDeparturetime()
    {
        return $this->departuretime;
    }
    /**
     * Set departuretime value
     * @param string $departuretime
     * @return \StructType\RESERVATION
     */
    public function setDeparturetime($departuretime = null)
    {
        // validation for constraint: string
        if (!is_null($departuretime) && !is_string($departuretime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departuretime, true), gettype($departuretime)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($departuretime) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $departuretime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($departuretime, true)), __LINE__);
        }
        $this->departuretime = $departuretime;
        return $this;
    }
    /**
     * Get gdsresnumber value
     * @return string
     */
    public function getGdsresnumber()
    {
        return $this->gdsresnumber;
    }
    /**
     * Set gdsresnumber value
     * @param string $gdsresnumber
     * @return \StructType\RESERVATION
     */
    public function setGdsresnumber($gdsresnumber = null)
    {
        // validation for constraint: string
        if (!is_null($gdsresnumber) && !is_string($gdsresnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gdsresnumber, true), gettype($gdsresnumber)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($gdsresnumber) && mb_strlen($gdsresnumber) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($gdsresnumber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($gdsresnumber) && mb_strlen($gdsresnumber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($gdsresnumber)), __LINE__);
        }
        $this->gdsresnumber = $gdsresnumber;
        return $this;
    }
    /**
     * Get externalid value
     * @return string
     */
    public function getExternalid()
    {
        return $this->externalid;
    }
    /**
     * Set externalid value
     * @param string $externalid
     * @return \StructType\RESERVATION
     */
    public function setExternalid($externalid = null)
    {
        // validation for constraint: string
        if (!is_null($externalid) && !is_string($externalid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalid, true), gettype($externalid)), __LINE__);
        }
        $this->externalid = $externalid;
        return $this;
    }
    /**
     * Get externalkey value
     * @return string
     */
    public function getExternalkey()
    {
        return $this->externalkey;
    }
    /**
     * Set externalkey value
     * @param string $externalkey
     * @return \StructType\RESERVATION
     */
    public function setExternalkey($externalkey = null)
    {
        // validation for constraint: string
        if (!is_null($externalkey) && !is_string($externalkey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalkey, true), gettype($externalkey)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($externalkey) && mb_strlen($externalkey) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($externalkey)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($externalkey) && mb_strlen($externalkey) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($externalkey)), __LINE__);
        }
        $this->externalkey = $externalkey;
        return $this;
    }
    /**
     * Get externalreference value
     * @return string
     */
    public function getExternalreference()
    {
        return $this->externalreference;
    }
    /**
     * Set externalreference value
     * @param string $externalreference
     * @return \StructType\RESERVATION
     */
    public function setExternalreference($externalreference = null)
    {
        // validation for constraint: string
        if (!is_null($externalreference) && !is_string($externalreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalreference, true), gettype($externalreference)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($externalreference) && mb_strlen($externalreference) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($externalreference)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($externalreference) && mb_strlen($externalreference) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($externalreference)), __LINE__);
        }
        $this->externalreference = $externalreference;
        return $this;
    }
    /**
     * Get resmedium value
     * @return string
     */
    public function getResmedium()
    {
        return $this->resmedium;
    }
    /**
     * Set resmedium value
     * @param string $resmedium
     * @return \StructType\RESERVATION
     */
    public function setResmedium($resmedium = null)
    {
        // validation for constraint: string
        if (!is_null($resmedium) && !is_string($resmedium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resmedium, true), gettype($resmedium)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($resmedium) && mb_strlen($resmedium) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($resmedium)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($resmedium) && mb_strlen($resmedium) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($resmedium)), __LINE__);
        }
        $this->resmedium = $resmedium;
        return $this;
    }
    /**
     * Get ressource value
     * @return string
     */
    public function getRessource()
    {
        return $this->ressource;
    }
    /**
     * Set ressource value
     * @param string $ressource
     * @return \StructType\RESERVATION
     */
    public function setRessource($ressource = null)
    {
        // validation for constraint: string
        if (!is_null($ressource) && !is_string($ressource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ressource, true), gettype($ressource)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($ressource) && mb_strlen($ressource) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($ressource)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ressource) && mb_strlen($ressource) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ressource)), __LINE__);
        }
        $this->ressource = $ressource;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\RESERVATION
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get noofchildren value
     * @return string
     */
    public function getNoofchildren()
    {
        return $this->noofchildren;
    }
    /**
     * Set noofchildren value
     * @param string $noofchildren
     * @return \StructType\RESERVATION
     */
    public function setNoofchildren($noofchildren = null)
    {
        // validation for constraint: string
        if (!is_null($noofchildren) && !is_string($noofchildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofchildren, true), gettype($noofchildren)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofchildren) && !preg_match('/([-+]){0,1}([0-9])*/', $noofchildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofchildren, true)), __LINE__);
        }
        $this->noofchildren = $noofchildren;
        return $this;
    }
    /**
     * Get noofadults value
     * @return string
     */
    public function getNoofadults()
    {
        return $this->noofadults;
    }
    /**
     * Set noofadults value
     * @param string $noofadults
     * @return \StructType\RESERVATION
     */
    public function setNoofadults($noofadults = null)
    {
        // validation for constraint: string
        if (!is_null($noofadults) && !is_string($noofadults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofadults, true), gettype($noofadults)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofadults) && !preg_match('/([-+]){0,1}([0-9])*/', $noofadults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofadults, true)), __LINE__);
        }
        $this->noofadults = $noofadults;
        return $this;
    }
    /**
     * Get commenttechnical value
     * @return string
     */
    public function getCommenttechnical()
    {
        return $this->commenttechnical;
    }
    /**
     * Set commenttechnical value
     * @param string $commenttechnical
     * @return \StructType\RESERVATION
     */
    public function setCommenttechnical($commenttechnical = null)
    {
        // validation for constraint: string
        if (!is_null($commenttechnical) && !is_string($commenttechnical)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commenttechnical, true), gettype($commenttechnical)), __LINE__);
        }
        $this->commenttechnical = $commenttechnical;
        return $this;
    }
    /**
     * Get commentcentral value
     * @return string
     */
    public function getCommentcentral()
    {
        return $this->commentcentral;
    }
    /**
     * Set commentcentral value
     * @param string $commentcentral
     * @return \StructType\RESERVATION
     */
    public function setCommentcentral($commentcentral = null)
    {
        // validation for constraint: string
        if (!is_null($commentcentral) && !is_string($commentcentral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commentcentral, true), gettype($commentcentral)), __LINE__);
        }
        $this->commentcentral = $commentcentral;
        return $this;
    }
    /**
     * Get discountgroup value
     * @return string
     */
    public function getDiscountgroup()
    {
        return $this->discountgroup;
    }
    /**
     * Set discountgroup value
     * @param string $discountgroup
     * @return \StructType\RESERVATION
     */
    public function setDiscountgroup($discountgroup = null)
    {
        // validation for constraint: string
        if (!is_null($discountgroup) && !is_string($discountgroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountgroup, true), gettype($discountgroup)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($discountgroup) && mb_strlen($discountgroup) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($discountgroup)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($discountgroup) && mb_strlen($discountgroup) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($discountgroup)), __LINE__);
        }
        $this->discountgroup = $discountgroup;
        return $this;
    }
    /**
     * Get DEPOSIT value
     * @return \StructType\DEPOSIT
     */
    public function getDEPOSIT()
    {
        return $this->DEPOSIT;
    }
    /**
     * Set DEPOSIT value
     * @param \StructType\DEPOSIT $dEPOSIT
     * @return \StructType\RESERVATION
     */
    public function setDEPOSIT(\StructType\DEPOSIT $dEPOSIT = null)
    {
        $this->DEPOSIT = $dEPOSIT;
        return $this;
    }
    /**
     * Get forecastnoofadults value
     * @return string
     */
    public function getForecastnoofadults()
    {
        return $this->forecastnoofadults;
    }
    /**
     * Set forecastnoofadults value
     * @param string $forecastnoofadults
     * @return \StructType\RESERVATION
     */
    public function setForecastnoofadults($forecastnoofadults = null)
    {
        // validation for constraint: string
        if (!is_null($forecastnoofadults) && !is_string($forecastnoofadults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastnoofadults, true), gettype($forecastnoofadults)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($forecastnoofadults) && !preg_match('/([-+]){0,1}([0-9])*/', $forecastnoofadults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($forecastnoofadults, true)), __LINE__);
        }
        $this->forecastnoofadults = $forecastnoofadults;
        return $this;
    }
    /**
     * Get forecastnoofchildren value
     * @return string
     */
    public function getForecastnoofchildren()
    {
        return $this->forecastnoofchildren;
    }
    /**
     * Set forecastnoofchildren value
     * @param string $forecastnoofchildren
     * @return \StructType\RESERVATION
     */
    public function setForecastnoofchildren($forecastnoofchildren = null)
    {
        // validation for constraint: string
        if (!is_null($forecastnoofchildren) && !is_string($forecastnoofchildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastnoofchildren, true), gettype($forecastnoofchildren)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($forecastnoofchildren) && !preg_match('/([-+]){0,1}([0-9])*/', $forecastnoofchildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($forecastnoofchildren, true)), __LINE__);
        }
        $this->forecastnoofchildren = $forecastnoofchildren;
        return $this;
    }
    /**
     * Get forecastnoofpax value
     * @return string
     */
    public function getForecastnoofpax()
    {
        return $this->forecastnoofpax;
    }
    /**
     * Set forecastnoofpax value
     * @param string $forecastnoofpax
     * @return \StructType\RESERVATION
     */
    public function setForecastnoofpax($forecastnoofpax = null)
    {
        // validation for constraint: string
        if (!is_null($forecastnoofpax) && !is_string($forecastnoofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastnoofpax, true), gettype($forecastnoofpax)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($forecastnoofpax) && !preg_match('/([-+]){0,1}([0-9])*/', $forecastnoofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($forecastnoofpax, true)), __LINE__);
        }
        $this->forecastnoofpax = $forecastnoofpax;
        return $this;
    }
    /**
     * Get forecastrategross value
     * @return string
     */
    public function getForecastrategross()
    {
        return $this->forecastrategross;
    }
    /**
     * Set forecastrategross value
     * @param string $forecastrategross
     * @return \StructType\RESERVATION
     */
    public function setForecastrategross($forecastrategross = null)
    {
        // validation for constraint: string
        if (!is_null($forecastrategross) && !is_string($forecastrategross)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastrategross, true), gettype($forecastrategross)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($forecastrategross) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $forecastrategross)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($forecastrategross, true)), __LINE__);
        }
        $this->forecastrategross = $forecastrategross;
        return $this;
    }
    /**
     * Get forecastratenet value
     * @return string
     */
    public function getForecastratenet()
    {
        return $this->forecastratenet;
    }
    /**
     * Set forecastratenet value
     * @param string $forecastratenet
     * @return \StructType\RESERVATION
     */
    public function setForecastratenet($forecastratenet = null)
    {
        // validation for constraint: string
        if (!is_null($forecastratenet) && !is_string($forecastratenet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastratenet, true), gettype($forecastratenet)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($forecastratenet) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $forecastratenet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($forecastratenet, true)), __LINE__);
        }
        $this->forecastratenet = $forecastratenet;
        return $this;
    }
    /**
     * Get deposit value
     * @return string
     */
    public function getDeposit_1()
    {
        return $this->deposit;
    }
    /**
     * Set deposit value
     * @param string $deposit
     * @return \StructType\RESERVATION
     */
    public function setDeposit_1($deposit_1 = null)
    {
        // validation for constraint: string
        if (!is_null($deposit_1) && !is_string($deposit_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deposit_1, true), gettype($deposit_1)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($deposit_1) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $deposit_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($deposit_1, true)), __LINE__);
        }
        $this->deposit = $deposit_1;
        return $this;
    }
    /**
     * Get hasautoservice value
     * @return string
     */
    public function getHasautoservice()
    {
        return $this->hasautoservice;
    }
    /**
     * Set hasautoservice value
     * @param string $hasautoservice
     * @return \StructType\RESERVATION
     */
    public function setHasautoservice($hasautoservice = null)
    {
        // validation for constraint: string
        if (!is_null($hasautoservice) && !is_string($hasautoservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hasautoservice, true), gettype($hasautoservice)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hasautoservice) && !preg_match('/([-+]){0,1}([0-9])*/', $hasautoservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hasautoservice, true)), __LINE__);
        }
        $this->hasautoservice = $hasautoservice;
        return $this;
    }
    /**
     * Get RESERVATIONPACKAGES value
     * @return \StructType\RESERVATIONPACKAGES
     */
    public function getRESERVATIONPACKAGES()
    {
        return $this->RESERVATIONPACKAGES;
    }
    /**
     * Set RESERVATIONPACKAGES value
     * @param \StructType\RESERVATIONPACKAGES $rESERVATIONPACKAGES
     * @return \StructType\RESERVATION
     */
    public function setRESERVATIONPACKAGES(\StructType\RESERVATIONPACKAGES $rESERVATIONPACKAGES = null)
    {
        $this->RESERVATIONPACKAGES = $rESERVATIONPACKAGES;
        return $this;
    }
    /**
     * Get EXTERNALIDS value
     * @return \StructType\EXTERNALIDS
     */
    public function getEXTERNALIDS()
    {
        return $this->EXTERNALIDS;
    }
    /**
     * Set EXTERNALIDS value
     * @param \StructType\EXTERNALIDS $eXTERNALIDS
     * @return \StructType\RESERVATION
     */
    public function setEXTERNALIDS(\StructType\EXTERNALIDS $eXTERNALIDS = null)
    {
        $this->EXTERNALIDS = $eXTERNALIDS;
        return $this;
    }
    /**
     * Get ROOMS value
     * @return \StructType\ROOMS
     */
    public function getROOMS()
    {
        return $this->ROOMS;
    }
    /**
     * Set ROOMS value
     * @param \StructType\ROOMS $rOOMS
     * @return \StructType\RESERVATION
     */
    public function setROOMS(\StructType\ROOMS $rOOMS = null)
    {
        $this->ROOMS = $rOOMS;
        return $this;
    }
    /**
     * Get ratesfixed value
     * @return string
     */
    public function getRatesfixed()
    {
        return $this->ratesfixed;
    }
    /**
     * Set ratesfixed value
     * @param string $ratesfixed
     * @return \StructType\RESERVATION
     */
    public function setRatesfixed($ratesfixed = null)
    {
        // validation for constraint: string
        if (!is_null($ratesfixed) && !is_string($ratesfixed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratesfixed, true), gettype($ratesfixed)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($ratesfixed) && !preg_match('/([-+]){0,1}([0-9])*/', $ratesfixed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($ratesfixed, true)), __LINE__);
        }
        $this->ratesfixed = $ratesfixed;
        return $this;
    }
    /**
     * Get internalrestype value
     * @return string
     */
    public function getInternalrestype()
    {
        return $this->internalrestype;
    }
    /**
     * Set internalrestype value
     * @param string $internalrestype
     * @return \StructType\RESERVATION
     */
    public function setInternalrestype($internalrestype = null)
    {
        // validation for constraint: string
        if (!is_null($internalrestype) && !is_string($internalrestype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalrestype, true), gettype($internalrestype)), __LINE__);
        }
        $this->internalrestype = $internalrestype;
        return $this;
    }
    /**
     * Get CARD value
     * @return \StructType\CARD
     */
    public function getCARD()
    {
        return $this->CARD;
    }
    /**
     * Set CARD value
     * @param \StructType\CARD $cARD
     * @return \StructType\RESERVATION
     */
    public function setCARD(\StructType\CARD $cARD = null)
    {
        $this->CARD = $cARD;
        return $this;
    }
    /**
     * Get marketsegment value
     * @return string|null
     */
    public function getMarketsegment()
    {
        return $this->marketsegment;
    }
    /**
     * Set marketsegment value
     * @param string $marketsegment
     * @return \StructType\RESERVATION
     */
    public function setMarketsegment($marketsegment = null)
    {
        // validation for constraint: string
        if (!is_null($marketsegment) && !is_string($marketsegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketsegment, true), gettype($marketsegment)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($marketsegment) && mb_strlen($marketsegment) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($marketsegment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($marketsegment) && mb_strlen($marketsegment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($marketsegment)), __LINE__);
        }
        $this->marketsegment = $marketsegment;
        return $this;
    }
    /**
     * Get packages value
     * @return string|null
     */
    public function getPackages()
    {
        return $this->packages;
    }
    /**
     * Set packages value
     * @param string $packages
     * @return \StructType\RESERVATION
     */
    public function setPackages($packages = null)
    {
        // validation for constraint: string
        if (!is_null($packages) && !is_string($packages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packages, true), gettype($packages)), __LINE__);
        }
        $this->packages = $packages;
        return $this;
    }
    /**
     * Get guesttype value
     * @return string|null
     */
    public function getGuesttype()
    {
        return $this->guesttype;
    }
    /**
     * Set guesttype value
     * @param string $guesttype
     * @return \StructType\RESERVATION
     */
    public function setGuesttype($guesttype = null)
    {
        // validation for constraint: string
        if (!is_null($guesttype) && !is_string($guesttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guesttype, true), gettype($guesttype)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($guesttype) && mb_strlen($guesttype) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($guesttype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($guesttype) && mb_strlen($guesttype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($guesttype)), __LINE__);
        }
        $this->guesttype = $guesttype;
        return $this;
    }
    /**
     * Get optiontodate value
     * @return string|null
     */
    public function getOptiontodate()
    {
        return $this->optiontodate;
    }
    /**
     * Set optiontodate value
     * @param string $optiontodate
     * @return \StructType\RESERVATION
     */
    public function setOptiontodate($optiontodate = null)
    {
        // validation for constraint: string
        if (!is_null($optiontodate) && !is_string($optiontodate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optiontodate, true), gettype($optiontodate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($optiontodate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $optiontodate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($optiontodate, true)), __LINE__);
        }
        $this->optiontodate = $optiontodate;
        return $this;
    }
    /**
     * Get channel value
     * @return string|null
     */
    public function getChannel()
    {
        return $this->channel;
    }
    /**
     * Set channel value
     * @param string $channel
     * @return \StructType\RESERVATION
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: string
        if (!is_null($channel) && !is_string($channel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channel, true), gettype($channel)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($channel) && mb_strlen($channel) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($channel)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($channel) && mb_strlen($channel) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($channel)), __LINE__);
        }
        $this->channel = $channel;
        return $this;
    }
    /**
     * Get nn1 value
     * @return string|null
     */
    public function getNn1()
    {
        return $this->nn1;
    }
    /**
     * Set nn1 value
     * @param string $nn1
     * @return \StructType\RESERVATION
     */
    public function setNn1($nn1 = null)
    {
        // validation for constraint: string
        if (!is_null($nn1) && !is_string($nn1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nn1, true), gettype($nn1)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($nn1) && mb_strlen($nn1) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($nn1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($nn1) && mb_strlen($nn1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($nn1)), __LINE__);
        }
        $this->nn1 = $nn1;
        return $this;
    }
    /**
     * Get commentadditional value
     * @return string|null
     */
    public function getCommentadditional()
    {
        return $this->commentadditional;
    }
    /**
     * Set commentadditional value
     * @param string $commentadditional
     * @return \StructType\RESERVATION
     */
    public function setCommentadditional($commentadditional = null)
    {
        // validation for constraint: string
        if (!is_null($commentadditional) && !is_string($commentadditional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commentadditional, true), gettype($commentadditional)), __LINE__);
        }
        $this->commentadditional = $commentadditional;
        return $this;
    }
    /**
     * Get note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @param string $note
     * @return \StructType\RESERVATION
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($note) && mb_strlen($note) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($note)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($note) && mb_strlen($note) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($note)), __LINE__);
        }
        $this->note = $note;
        return $this;
    }
    /**
     * Get rateassignedto value
     * @return string|null
     */
    public function getRateassignedto()
    {
        return $this->rateassignedto;
    }
    /**
     * Set rateassignedto value
     * @param string $rateassignedto
     * @return \StructType\RESERVATION
     */
    public function setRateassignedto($rateassignedto = null)
    {
        // validation for constraint: string
        if (!is_null($rateassignedto) && !is_string($rateassignedto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateassignedto, true), gettype($rateassignedto)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($rateassignedto) && !preg_match('/([-+]){0,1}([0-9])*/', $rateassignedto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($rateassignedto, true)), __LINE__);
        }
        $this->rateassignedto = $rateassignedto;
        return $this;
    }
    /**
     * Get ORDERER value
     * @return \StructType\ORDERER[]|null
     */
    public function getORDERER()
    {
        return $this->ORDERER;
    }
    /**
     * This method is responsible for validating the values passed to the setORDERER method
     * This method is willingly generated in order to preserve the one-line inline validation within the setORDERER method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateORDERERForArrayConstraintsFromSetORDERER(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rESERVATIONORDERERItem) {
            // validation for constraint: itemType
            if (!$rESERVATIONORDERERItem instanceof \StructType\ORDERER) {
                $invalidValues[] = is_object($rESERVATIONORDERERItem) ? get_class($rESERVATIONORDERERItem) : sprintf('%s(%s)', gettype($rESERVATIONORDERERItem), var_export($rESERVATIONORDERERItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ORDERER property can only contain items of type \StructType\ORDERER, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ORDERER value
     * @throws \InvalidArgumentException
     * @param \StructType\ORDERER[] $oRDERER
     * @return \StructType\RESERVATION
     */
    public function setORDERER(array $oRDERER = array())
    {
        // validation for constraint: array
        if ('' !== ($oRDERERArrayErrorMessage = self::validateORDERERForArrayConstraintsFromSetORDERER($oRDERER))) {
            throw new \InvalidArgumentException($oRDERERArrayErrorMessage, __LINE__);
        }
        $this->ORDERER = $oRDERER;
        return $this;
    }
    /**
     * Add item to ORDERER value
     * @throws \InvalidArgumentException
     * @param \StructType\ORDERER $item
     * @return \StructType\RESERVATION
     */
    public function addToORDERER(\StructType\ORDERER $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ORDERER) {
            throw new \InvalidArgumentException(sprintf('The ORDERER property can only contain items of type \StructType\ORDERER, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ORDERER[] = $item;
        return $this;
    }
    /**
     * Get TRAVELAGENCY value
     * @return \StructType\TRAVELAGENCY|null
     */
    public function getTRAVELAGENCY()
    {
        return $this->TRAVELAGENCY;
    }
    /**
     * Set TRAVELAGENCY value
     * @param \StructType\TRAVELAGENCY $tRAVELAGENCY
     * @return \StructType\RESERVATION
     */
    public function setTRAVELAGENCY(\StructType\TRAVELAGENCY $tRAVELAGENCY = null)
    {
        $this->TRAVELAGENCY = $tRAVELAGENCY;
        return $this;
    }
    /**
     * Get TRAVELPOINT value
     * @return \StructType\TRAVELPOINT|null
     */
    public function getTRAVELPOINT()
    {
        return $this->TRAVELPOINT;
    }
    /**
     * Set TRAVELPOINT value
     * @param \StructType\TRAVELPOINT $tRAVELPOINT
     * @return \StructType\RESERVATION
     */
    public function setTRAVELPOINT(\StructType\TRAVELPOINT $tRAVELPOINT = null)
    {
        $this->TRAVELPOINT = $tRAVELPOINT;
        return $this;
    }
    /**
     * Get ORDERERCONTACTPERSON value
     * @return \StructType\ORDERERCONTACTPERSON|null
     */
    public function getORDERERCONTACTPERSON()
    {
        return $this->ORDERERCONTACTPERSON;
    }
    /**
     * Set ORDERERCONTACTPERSON value
     * @param \StructType\ORDERERCONTACTPERSON $oRDERERCONTACTPERSON
     * @return \StructType\RESERVATION
     */
    public function setORDERERCONTACTPERSON(\StructType\ORDERERCONTACTPERSON $oRDERERCONTACTPERSON = null)
    {
        $this->ORDERERCONTACTPERSON = $oRDERERCONTACTPERSON;
        return $this;
    }
    /**
     * Get TRAVELAGENCYCONTACTPERSON value
     * @return \StructType\TRAVELAGENCYCONTACTPERSON|null
     */
    public function getTRAVELAGENCYCONTACTPERSON()
    {
        return $this->TRAVELAGENCYCONTACTPERSON;
    }
    /**
     * Set TRAVELAGENCYCONTACTPERSON value
     * @param \StructType\TRAVELAGENCYCONTACTPERSON $tRAVELAGENCYCONTACTPERSON
     * @return \StructType\RESERVATION
     */
    public function setTRAVELAGENCYCONTACTPERSON(\StructType\TRAVELAGENCYCONTACTPERSON $tRAVELAGENCYCONTACTPERSON = null)
    {
        $this->TRAVELAGENCYCONTACTPERSON = $tRAVELAGENCYCONTACTPERSON;
        return $this;
    }
    /**
     * Get TRAVELPOINTCONTACTPERSON value
     * @return \StructType\TRAVELPOINTCONTACTPERSON|null
     */
    public function getTRAVELPOINTCONTACTPERSON()
    {
        return $this->TRAVELPOINTCONTACTPERSON;
    }
    /**
     * Set TRAVELPOINTCONTACTPERSON value
     * @param \StructType\TRAVELPOINTCONTACTPERSON $tRAVELPOINTCONTACTPERSON
     * @return \StructType\RESERVATION
     */
    public function setTRAVELPOINTCONTACTPERSON(\StructType\TRAVELPOINTCONTACTPERSON $tRAVELPOINTCONTACTPERSON = null)
    {
        $this->TRAVELPOINTCONTACTPERSON = $tRAVELPOINTCONTACTPERSON;
        return $this;
    }
    /**
     * Get commentinternet value
     * @return string|null
     */
    public function getCommentinternet()
    {
        return $this->commentinternet;
    }
    /**
     * Set commentinternet value
     * @param string $commentinternet
     * @return \StructType\RESERVATION
     */
    public function setCommentinternet($commentinternet = null)
    {
        // validation for constraint: string
        if (!is_null($commentinternet) && !is_string($commentinternet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commentinternet, true), gettype($commentinternet)), __LINE__);
        }
        $this->commentinternet = $commentinternet;
        return $this;
    }
    /**
     * Get commentinvoice value
     * @return string|null
     */
    public function getCommentinvoice()
    {
        return $this->commentinvoice;
    }
    /**
     * Set commentinvoice value
     * @param string $commentinvoice
     * @return \StructType\RESERVATION
     */
    public function setCommentinvoice($commentinvoice = null)
    {
        // validation for constraint: string
        if (!is_null($commentinvoice) && !is_string($commentinvoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commentinvoice, true), gettype($commentinvoice)), __LINE__);
        }
        $this->commentinvoice = $commentinvoice;
        return $this;
    }
    /**
     * Get payminstrautoservice value
     * @return string|null
     */
    public function getPayminstrautoservice()
    {
        return $this->payminstrautoservice;
    }
    /**
     * Set payminstrautoservice value
     * @param string $payminstrautoservice
     * @return \StructType\RESERVATION
     */
    public function setPayminstrautoservice($payminstrautoservice = null)
    {
        // validation for constraint: string
        if (!is_null($payminstrautoservice) && !is_string($payminstrautoservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payminstrautoservice, true), gettype($payminstrautoservice)), __LINE__);
        }
        $this->payminstrautoservice = $payminstrautoservice;
        return $this;
    }
    /**
     * Get duedate1 value
     * @return string|null
     */
    public function getDuedate1()
    {
        return $this->duedate1;
    }
    /**
     * Set duedate1 value
     * @param string $duedate1
     * @return \StructType\RESERVATION
     */
    public function setDuedate1($duedate1 = null)
    {
        // validation for constraint: string
        if (!is_null($duedate1) && !is_string($duedate1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duedate1, true), gettype($duedate1)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($duedate1) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $duedate1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($duedate1, true)), __LINE__);
        }
        $this->duedate1 = $duedate1;
        return $this;
    }
    /**
     * Get amount1 value
     * @return string|null
     */
    public function getAmount1()
    {
        return $this->amount1;
    }
    /**
     * Set amount1 value
     * @param string $amount1
     * @return \StructType\RESERVATION
     */
    public function setAmount1($amount1 = null)
    {
        // validation for constraint: string
        if (!is_null($amount1) && !is_string($amount1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount1, true), gettype($amount1)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amount1) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amount1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amount1, true)), __LINE__);
        }
        $this->amount1 = $amount1;
        return $this;
    }
    /**
     * Get duedate2 value
     * @return string|null
     */
    public function getDuedate2()
    {
        return $this->duedate2;
    }
    /**
     * Set duedate2 value
     * @param string $duedate2
     * @return \StructType\RESERVATION
     */
    public function setDuedate2($duedate2 = null)
    {
        // validation for constraint: string
        if (!is_null($duedate2) && !is_string($duedate2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duedate2, true), gettype($duedate2)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($duedate2) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $duedate2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($duedate2, true)), __LINE__);
        }
        $this->duedate2 = $duedate2;
        return $this;
    }
    /**
     * Get amount2 value
     * @return string|null
     */
    public function getAmount2()
    {
        return $this->amount2;
    }
    /**
     * Set amount2 value
     * @param string $amount2
     * @return \StructType\RESERVATION
     */
    public function setAmount2($amount2 = null)
    {
        // validation for constraint: string
        if (!is_null($amount2) && !is_string($amount2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount2, true), gettype($amount2)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amount2) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amount2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amount2, true)), __LINE__);
        }
        $this->amount2 = $amount2;
        return $this;
    }
    /**
     * Get duedate3 value
     * @return string|null
     */
    public function getDuedate3()
    {
        return $this->duedate3;
    }
    /**
     * Set duedate3 value
     * @param string $duedate3
     * @return \StructType\RESERVATION
     */
    public function setDuedate3($duedate3 = null)
    {
        // validation for constraint: string
        if (!is_null($duedate3) && !is_string($duedate3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duedate3, true), gettype($duedate3)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($duedate3) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $duedate3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($duedate3, true)), __LINE__);
        }
        $this->duedate3 = $duedate3;
        return $this;
    }
    /**
     * Get amount3 value
     * @return string|null
     */
    public function getAmount3()
    {
        return $this->amount3;
    }
    /**
     * Set amount3 value
     * @param string $amount3
     * @return \StructType\RESERVATION
     */
    public function setAmount3($amount3 = null)
    {
        // validation for constraint: string
        if (!is_null($amount3) && !is_string($amount3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount3, true), gettype($amount3)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amount3) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amount3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amount3, true)), __LINE__);
        }
        $this->amount3 = $amount3;
        return $this;
    }
    /**
     * Get ROOM value
     * @return \StructType\ROOM_2[]|null
     */
    public function getROOM()
    {
        return $this->ROOM;
    }
    /**
     * This method is responsible for validating the values passed to the setROOM method
     * This method is willingly generated in order to preserve the one-line inline validation within the setROOM method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateROOMForArrayConstraintsFromSetROOM(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rESERVATIONROOMItem) {
            // validation for constraint: itemType
            if (!$rESERVATIONROOMItem instanceof \StructType\ROOM_2) {
                $invalidValues[] = is_object($rESERVATIONROOMItem) ? get_class($rESERVATIONROOMItem) : sprintf('%s(%s)', gettype($rESERVATIONROOMItem), var_export($rESERVATIONROOMItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ROOM property can only contain items of type \StructType\ROOM_2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ROOM value
     * @throws \InvalidArgumentException
     * @param \StructType\ROOM_2[] $rOOM
     * @return \StructType\RESERVATION
     */
    public function setROOM(array $rOOM = array())
    {
        // validation for constraint: array
        if ('' !== ($rOOMArrayErrorMessage = self::validateROOMForArrayConstraintsFromSetROOM($rOOM))) {
            throw new \InvalidArgumentException($rOOMArrayErrorMessage, __LINE__);
        }
        $this->ROOM = $rOOM;
        return $this;
    }
    /**
     * Add item to ROOM value
     * @throws \InvalidArgumentException
     * @param \StructType\ROOM_2 $item
     * @return \StructType\RESERVATION
     */
    public function addToROOM(\StructType\ROOM_2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ROOM_2) {
            throw new \InvalidArgumentException(sprintf('The ROOM property can only contain items of type \StructType\ROOM_2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ROOM[] = $item;
        return $this;
    }
}
