<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RATERESULT StructType
 * @subpackage Structs
 */
class RATERESULT extends AbstractStructBase
{
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $rate;
    /**
     * The discount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $discount;
    /**
     * The currencyamount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $currencyamount;
    /**
     * The currencydiscount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $currencydiscount;
    /**
     * The DAILYRATERESULT
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DAILYRATERESULT[]
     */
    public $DAILYRATERESULT;
    /**
     * Constructor method for RATERESULT
     * @uses RATERESULT::setRate()
     * @uses RATERESULT::setDiscount()
     * @uses RATERESULT::setCurrencyamount()
     * @uses RATERESULT::setCurrencydiscount()
     * @uses RATERESULT::setDAILYRATERESULT()
     * @param string $rate
     * @param string $discount
     * @param string $currencyamount
     * @param string $currencydiscount
     * @param \StructType\DAILYRATERESULT[] $dAILYRATERESULT
     */
    public function __construct($rate = null, $discount = null, $currencyamount = null, $currencydiscount = null, array $dAILYRATERESULT = array())
    {
        $this
            ->setRate($rate)
            ->setDiscount($discount)
            ->setCurrencyamount($currencyamount)
            ->setCurrencydiscount($currencydiscount)
            ->setDAILYRATERESULT($dAILYRATERESULT);
    }
    /**
     * Get rate value
     * @return string
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\RATERESULT
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($rate) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($rate, true)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get discount value
     * @return string
     */
    public function getDiscount()
    {
        return $this->discount;
    }
    /**
     * Set discount value
     * @param string $discount
     * @return \StructType\RATERESULT
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: string
        if (!is_null($discount) && !is_string($discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($discount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($discount, true)), __LINE__);
        }
        $this->discount = $discount;
        return $this;
    }
    /**
     * Get currencyamount value
     * @return string
     */
    public function getCurrencyamount()
    {
        return $this->currencyamount;
    }
    /**
     * Set currencyamount value
     * @param string $currencyamount
     * @return \StructType\RATERESULT
     */
    public function setCurrencyamount($currencyamount = null)
    {
        // validation for constraint: string
        if (!is_null($currencyamount) && !is_string($currencyamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyamount, true), gettype($currencyamount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($currencyamount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $currencyamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($currencyamount, true)), __LINE__);
        }
        $this->currencyamount = $currencyamount;
        return $this;
    }
    /**
     * Get currencydiscount value
     * @return string
     */
    public function getCurrencydiscount()
    {
        return $this->currencydiscount;
    }
    /**
     * Set currencydiscount value
     * @param string $currencydiscount
     * @return \StructType\RATERESULT
     */
    public function setCurrencydiscount($currencydiscount = null)
    {
        // validation for constraint: string
        if (!is_null($currencydiscount) && !is_string($currencydiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencydiscount, true), gettype($currencydiscount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($currencydiscount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $currencydiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($currencydiscount, true)), __LINE__);
        }
        $this->currencydiscount = $currencydiscount;
        return $this;
    }
    /**
     * Get DAILYRATERESULT value
     * @return \StructType\DAILYRATERESULT[]|null
     */
    public function getDAILYRATERESULT()
    {
        return $this->DAILYRATERESULT;
    }
    /**
     * This method is responsible for validating the values passed to the setDAILYRATERESULT method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDAILYRATERESULT method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDAILYRATERESULTForArrayConstraintsFromSetDAILYRATERESULT(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rATERESULTDAILYRATERESULTItem) {
            // validation for constraint: itemType
            if (!$rATERESULTDAILYRATERESULTItem instanceof \StructType\DAILYRATERESULT) {
                $invalidValues[] = is_object($rATERESULTDAILYRATERESULTItem) ? get_class($rATERESULTDAILYRATERESULTItem) : sprintf('%s(%s)', gettype($rATERESULTDAILYRATERESULTItem), var_export($rATERESULTDAILYRATERESULTItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DAILYRATERESULT property can only contain items of type \StructType\DAILYRATERESULT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DAILYRATERESULT value
     * @throws \InvalidArgumentException
     * @param \StructType\DAILYRATERESULT[] $dAILYRATERESULT
     * @return \StructType\RATERESULT
     */
    public function setDAILYRATERESULT(array $dAILYRATERESULT = array())
    {
        // validation for constraint: array
        if ('' !== ($dAILYRATERESULTArrayErrorMessage = self::validateDAILYRATERESULTForArrayConstraintsFromSetDAILYRATERESULT($dAILYRATERESULT))) {
            throw new \InvalidArgumentException($dAILYRATERESULTArrayErrorMessage, __LINE__);
        }
        $this->DAILYRATERESULT = $dAILYRATERESULT;
        return $this;
    }
    /**
     * Add item to DAILYRATERESULT value
     * @throws \InvalidArgumentException
     * @param \StructType\DAILYRATERESULT $item
     * @return \StructType\RATERESULT
     */
    public function addToDAILYRATERESULT(\StructType\DAILYRATERESULT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DAILYRATERESULT) {
            throw new \InvalidArgumentException(sprintf('The DAILYRATERESULT property can only contain items of type \StructType\DAILYRATERESULT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DAILYRATERESULT[] = $item;
        return $this;
    }
}
