<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostFOPayment StructType
 * @subpackage Structs
 */
class PostFOPayment extends AbstractStructBase
{
    /**
     * The interfacepartner
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $interfacepartner;
    /**
     * The typeofpayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $typeofpayment;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amount;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The DESCRIPTION
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DESCRIPTION;
    /**
     * The isfromzpos
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $isfromzpos;
    /**
     * The approvalnumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $approvalnumber;
    /**
     * The processingdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $processingdate;
    /**
     * Constructor method for PostFOPayment
     * @uses PostFOPayment::setInterfacepartner()
     * @uses PostFOPayment::setTypeofpayment()
     * @uses PostFOPayment::setAmount()
     * @uses PostFOPayment::setCurrency()
     * @uses PostFOPayment::setDESCRIPTION()
     * @uses PostFOPayment::setIsfromzpos()
     * @uses PostFOPayment::setApprovalnumber()
     * @uses PostFOPayment::setProcessingdate()
     * @param string $interfacepartner
     * @param string $typeofpayment
     * @param string $amount
     * @param string $currency
     * @param string $dESCRIPTION
     * @param string $isfromzpos
     * @param string $approvalnumber
     * @param string $processingdate
     */
    public function __construct($interfacepartner = null, $typeofpayment = null, $amount = null, $currency = null, $dESCRIPTION = null, $isfromzpos = null, $approvalnumber = null, $processingdate = null)
    {
        $this
            ->setInterfacepartner($interfacepartner)
            ->setTypeofpayment($typeofpayment)
            ->setAmount($amount)
            ->setCurrency($currency)
            ->setDESCRIPTION($dESCRIPTION)
            ->setIsfromzpos($isfromzpos)
            ->setApprovalnumber($approvalnumber)
            ->setProcessingdate($processingdate);
    }
    /**
     * Get interfacepartner value
     * @return string
     */
    public function getInterfacepartner()
    {
        return $this->interfacepartner;
    }
    /**
     * Set interfacepartner value
     * @param string $interfacepartner
     * @return \StructType\PostFOPayment
     */
    public function setInterfacepartner($interfacepartner = null)
    {
        // validation for constraint: string
        if (!is_null($interfacepartner) && !is_string($interfacepartner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interfacepartner, true), gettype($interfacepartner)), __LINE__);
        }
        $this->interfacepartner = $interfacepartner;
        return $this;
    }
    /**
     * Get typeofpayment value
     * @return string
     */
    public function getTypeofpayment()
    {
        return $this->typeofpayment;
    }
    /**
     * Set typeofpayment value
     * @param string $typeofpayment
     * @return \StructType\PostFOPayment
     */
    public function setTypeofpayment($typeofpayment = null)
    {
        // validation for constraint: string
        if (!is_null($typeofpayment) && !is_string($typeofpayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeofpayment, true), gettype($typeofpayment)), __LINE__);
        }
        $this->typeofpayment = $typeofpayment;
        return $this;
    }
    /**
     * Get amount value
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param string $amount
     * @return \StructType\PostFOPayment
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amount, true)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\PostFOPayment
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get DESCRIPTION value
     * @return string|null
     */
    public function getDESCRIPTION()
    {
        return $this->DESCRIPTION;
    }
    /**
     * Set DESCRIPTION value
     * @param string $dESCRIPTION
     * @return \StructType\PostFOPayment
     */
    public function setDESCRIPTION($dESCRIPTION = null)
    {
        // validation for constraint: string
        if (!is_null($dESCRIPTION) && !is_string($dESCRIPTION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dESCRIPTION, true), gettype($dESCRIPTION)), __LINE__);
        }
        $this->DESCRIPTION = $dESCRIPTION;
        return $this;
    }
    /**
     * Get isfromzpos value
     * @return string|null
     */
    public function getIsfromzpos()
    {
        return $this->isfromzpos;
    }
    /**
     * Set isfromzpos value
     * @param string $isfromzpos
     * @return \StructType\PostFOPayment
     */
    public function setIsfromzpos($isfromzpos = null)
    {
        // validation for constraint: string
        if (!is_null($isfromzpos) && !is_string($isfromzpos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isfromzpos, true), gettype($isfromzpos)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($isfromzpos) && !preg_match('/([-+]){0,1}([0-9])*/', $isfromzpos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($isfromzpos, true)), __LINE__);
        }
        $this->isfromzpos = $isfromzpos;
        return $this;
    }
    /**
     * Get approvalnumber value
     * @return string|null
     */
    public function getApprovalnumber()
    {
        return $this->approvalnumber;
    }
    /**
     * Set approvalnumber value
     * @param string $approvalnumber
     * @return \StructType\PostFOPayment
     */
    public function setApprovalnumber($approvalnumber = null)
    {
        // validation for constraint: string
        if (!is_null($approvalnumber) && !is_string($approvalnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvalnumber, true), gettype($approvalnumber)), __LINE__);
        }
        $this->approvalnumber = $approvalnumber;
        return $this;
    }
    /**
     * Get processingdate value
     * @return string|null
     */
    public function getProcessingdate()
    {
        return $this->processingdate;
    }
    /**
     * Set processingdate value
     * @param string $processingdate
     * @return \StructType\PostFOPayment
     */
    public function setProcessingdate($processingdate = null)
    {
        // validation for constraint: string
        if (!is_null($processingdate) && !is_string($processingdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processingdate, true), gettype($processingdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($processingdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $processingdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($processingdate, true)), __LINE__);
        }
        $this->processingdate = $processingdate;
        return $this;
    }
}
