<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PoliceListEntry StructType
 * @subpackage Structs
 */
class PoliceListEntry extends AbstractStructBase
{
    /**
     * The POLICELIST_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $POLICELIST_OBJID;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $address;
    /**
     * The name1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name1;
    /**
     * The name2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $name2;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $street;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $postcode;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $city;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $country;
    /**
     * The subcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $subcountry;
    /**
     * The subsubcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $subsubcountry;
    /**
     * The region
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $region;
    /**
     * The nationality
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 9
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $nationality;
    /**
     * The birthdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $birthdate;
    /**
     * The placeofbirth
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $placeofbirth;
    /**
     * The birthcountry
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 9
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $birthcountry;
    /**
     * The passportno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $passportno;
    /**
     * The passportdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $passportdate;
    /**
     * The passporttype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $passporttype;
    /**
     * The cardnumber
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $cardnumber;
    /**
     * The cardexpiry
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $cardexpiry;
    /**
     * The border
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $border;
    /**
     * The borderstation
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $borderstation;
    /**
     * The bordertown
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $bordertown;
    /**
     * The nameofmother
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $nameofmother;
    /**
     * The nameoffather
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $nameoffather;
    /**
     * The nn1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $nn1;
    /**
     * The nn2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $nn2;
    /**
     * The identno1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $identno1;
    /**
     * The identno2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $identno2;
    /**
     * The identno3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $identno3;
    /**
     * The identno4
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $identno4;
    /**
     * The identno5
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $identno5;
    /**
     * The identtype1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $identtype1;
    /**
     * The identtype2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $identtype2;
    /**
     * The identtype3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $identtype3;
    /**
     * The identtype4
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $identtype4;
    /**
     * The identtype5
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $identtype5;
    /**
     * Constructor method for PoliceListEntry
     * @uses PoliceListEntry::setPOLICELIST_OBJID()
     * @uses PoliceListEntry::setAddress()
     * @uses PoliceListEntry::setName1()
     * @uses PoliceListEntry::setName2()
     * @uses PoliceListEntry::setStreet()
     * @uses PoliceListEntry::setPostcode()
     * @uses PoliceListEntry::setCity()
     * @uses PoliceListEntry::setCountry()
     * @uses PoliceListEntry::setSubcountry()
     * @uses PoliceListEntry::setSubsubcountry()
     * @uses PoliceListEntry::setRegion()
     * @uses PoliceListEntry::setNationality()
     * @uses PoliceListEntry::setBirthdate()
     * @uses PoliceListEntry::setPlaceofbirth()
     * @uses PoliceListEntry::setBirthcountry()
     * @uses PoliceListEntry::setPassportno()
     * @uses PoliceListEntry::setPassportdate()
     * @uses PoliceListEntry::setPassporttype()
     * @uses PoliceListEntry::setCardnumber()
     * @uses PoliceListEntry::setCardexpiry()
     * @uses PoliceListEntry::setBorder()
     * @uses PoliceListEntry::setBorderstation()
     * @uses PoliceListEntry::setBordertown()
     * @uses PoliceListEntry::setNameofmother()
     * @uses PoliceListEntry::setNameoffather()
     * @uses PoliceListEntry::setNn1()
     * @uses PoliceListEntry::setNn2()
     * @uses PoliceListEntry::setIdentno1()
     * @uses PoliceListEntry::setIdentno2()
     * @uses PoliceListEntry::setIdentno3()
     * @uses PoliceListEntry::setIdentno4()
     * @uses PoliceListEntry::setIdentno5()
     * @uses PoliceListEntry::setIdenttype1()
     * @uses PoliceListEntry::setIdenttype2()
     * @uses PoliceListEntry::setIdenttype3()
     * @uses PoliceListEntry::setIdenttype4()
     * @uses PoliceListEntry::setIdenttype5()
     * @param string $pOLICELIST_OBJID
     * @param string $address
     * @param string $name1
     * @param string $name2
     * @param string $street
     * @param string $postcode
     * @param string $city
     * @param string $country
     * @param string $subcountry
     * @param string $subsubcountry
     * @param string $region
     * @param string $nationality
     * @param string $birthdate
     * @param string $placeofbirth
     * @param string $birthcountry
     * @param string $passportno
     * @param string $passportdate
     * @param string $passporttype
     * @param string $cardnumber
     * @param string $cardexpiry
     * @param string $border
     * @param string $borderstation
     * @param string $bordertown
     * @param string $nameofmother
     * @param string $nameoffather
     * @param string $nn1
     * @param string $nn2
     * @param string $identno1
     * @param string $identno2
     * @param string $identno3
     * @param string $identno4
     * @param string $identno5
     * @param string $identtype1
     * @param string $identtype2
     * @param string $identtype3
     * @param string $identtype4
     * @param string $identtype5
     */
    public function __construct($pOLICELIST_OBJID = null, $address = null, $name1 = null, $name2 = null, $street = null, $postcode = null, $city = null, $country = null, $subcountry = null, $subsubcountry = null, $region = null, $nationality = null, $birthdate = null, $placeofbirth = null, $birthcountry = null, $passportno = null, $passportdate = null, $passporttype = null, $cardnumber = null, $cardexpiry = null, $border = null, $borderstation = null, $bordertown = null, $nameofmother = null, $nameoffather = null, $nn1 = null, $nn2 = null, $identno1 = null, $identno2 = null, $identno3 = null, $identno4 = null, $identno5 = null, $identtype1 = null, $identtype2 = null, $identtype3 = null, $identtype4 = null, $identtype5 = null)
    {
        $this
            ->setPOLICELIST_OBJID($pOLICELIST_OBJID)
            ->setAddress($address)
            ->setName1($name1)
            ->setName2($name2)
            ->setStreet($street)
            ->setPostcode($postcode)
            ->setCity($city)
            ->setCountry($country)
            ->setSubcountry($subcountry)
            ->setSubsubcountry($subsubcountry)
            ->setRegion($region)
            ->setNationality($nationality)
            ->setBirthdate($birthdate)
            ->setPlaceofbirth($placeofbirth)
            ->setBirthcountry($birthcountry)
            ->setPassportno($passportno)
            ->setPassportdate($passportdate)
            ->setPassporttype($passporttype)
            ->setCardnumber($cardnumber)
            ->setCardexpiry($cardexpiry)
            ->setBorder($border)
            ->setBorderstation($borderstation)
            ->setBordertown($bordertown)
            ->setNameofmother($nameofmother)
            ->setNameoffather($nameoffather)
            ->setNn1($nn1)
            ->setNn2($nn2)
            ->setIdentno1($identno1)
            ->setIdentno2($identno2)
            ->setIdentno3($identno3)
            ->setIdentno4($identno4)
            ->setIdentno5($identno5)
            ->setIdenttype1($identtype1)
            ->setIdenttype2($identtype2)
            ->setIdenttype3($identtype3)
            ->setIdenttype4($identtype4)
            ->setIdenttype5($identtype5);
    }
    /**
     * Get POLICELIST_OBJID value
     * @return string
     */
    public function getPOLICELIST_OBJID()
    {
        return $this->{'POLICELIST-OBJID'};
    }
    /**
     * Set POLICELIST_OBJID value
     * @param string $pOLICELIST_OBJID
     * @return \StructType\PoliceListEntry
     */
    public function setPOLICELIST_OBJID($pOLICELIST_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($pOLICELIST_OBJID) && !is_string($pOLICELIST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pOLICELIST_OBJID, true), gettype($pOLICELIST_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($pOLICELIST_OBJID) && !preg_match('/([0-9])*/', $pOLICELIST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($pOLICELIST_OBJID, true)), __LINE__);
        }
        $this->POLICELIST_OBJID = $this->{'POLICELIST-OBJID'} = $pOLICELIST_OBJID;
        return $this;
    }
    /**
     * Get address value
     * @return string
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\PoliceListEntry
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get name1 value
     * @return string
     */
    public function getName1()
    {
        return $this->name1;
    }
    /**
     * Set name1 value
     * @param string $name1
     * @return \StructType\PoliceListEntry
     */
    public function setName1($name1 = null)
    {
        // validation for constraint: string
        if (!is_null($name1) && !is_string($name1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name1, true), gettype($name1)), __LINE__);
        }
        $this->name1 = $name1;
        return $this;
    }
    /**
     * Get name2 value
     * @return string
     */
    public function getName2()
    {
        return $this->name2;
    }
    /**
     * Set name2 value
     * @param string $name2
     * @return \StructType\PoliceListEntry
     */
    public function setName2($name2 = null)
    {
        // validation for constraint: string
        if (!is_null($name2) && !is_string($name2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name2, true), gettype($name2)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($name2) && mb_strlen($name2) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($name2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($name2) && mb_strlen($name2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($name2)), __LINE__);
        }
        $this->name2 = $name2;
        return $this;
    }
    /**
     * Get street value
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\PoliceListEntry
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($street) && mb_strlen($street) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($street)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($street) && mb_strlen($street) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get postcode value
     * @return string
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\PoliceListEntry
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($postcode) && mb_strlen($postcode) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($postcode)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($postcode) && mb_strlen($postcode) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get city value
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\PoliceListEntry
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city) && mb_strlen($city) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($city) && mb_strlen($city) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get country value
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\PoliceListEntry
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get subcountry value
     * @return string
     */
    public function getSubcountry()
    {
        return $this->subcountry;
    }
    /**
     * Set subcountry value
     * @param string $subcountry
     * @return \StructType\PoliceListEntry
     */
    public function setSubcountry($subcountry = null)
    {
        // validation for constraint: string
        if (!is_null($subcountry) && !is_string($subcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subcountry, true), gettype($subcountry)), __LINE__);
        }
        $this->subcountry = $subcountry;
        return $this;
    }
    /**
     * Get subsubcountry value
     * @return string
     */
    public function getSubsubcountry()
    {
        return $this->subsubcountry;
    }
    /**
     * Set subsubcountry value
     * @param string $subsubcountry
     * @return \StructType\PoliceListEntry
     */
    public function setSubsubcountry($subsubcountry = null)
    {
        // validation for constraint: string
        if (!is_null($subsubcountry) && !is_string($subsubcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsubcountry, true), gettype($subsubcountry)), __LINE__);
        }
        $this->subsubcountry = $subsubcountry;
        return $this;
    }
    /**
     * Get region value
     * @return string
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param string $region
     * @return \StructType\PoliceListEntry
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($region, true), gettype($region)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($region) && mb_strlen($region) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($region)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($region) && mb_strlen($region) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($region)), __LINE__);
        }
        $this->region = $region;
        return $this;
    }
    /**
     * Get nationality value
     * @return string
     */
    public function getNationality()
    {
        return $this->nationality;
    }
    /**
     * Set nationality value
     * @param string $nationality
     * @return \StructType\PoliceListEntry
     */
    public function setNationality($nationality = null)
    {
        // validation for constraint: string
        if (!is_null($nationality) && !is_string($nationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationality, true), gettype($nationality)), __LINE__);
        }
        // validation for constraint: maxLength(9)
        if (!is_null($nationality) && mb_strlen($nationality) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 9', mb_strlen($nationality)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($nationality) && mb_strlen($nationality) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($nationality)), __LINE__);
        }
        $this->nationality = $nationality;
        return $this;
    }
    /**
     * Get birthdate value
     * @return string
     */
    public function getBirthdate()
    {
        return $this->birthdate;
    }
    /**
     * Set birthdate value
     * @param string $birthdate
     * @return \StructType\PoliceListEntry
     */
    public function setBirthdate($birthdate = null)
    {
        // validation for constraint: string
        if (!is_null($birthdate) && !is_string($birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthdate, true), gettype($birthdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($birthdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($birthdate, true)), __LINE__);
        }
        $this->birthdate = $birthdate;
        return $this;
    }
    /**
     * Get placeofbirth value
     * @return string
     */
    public function getPlaceofbirth()
    {
        return $this->placeofbirth;
    }
    /**
     * Set placeofbirth value
     * @param string $placeofbirth
     * @return \StructType\PoliceListEntry
     */
    public function setPlaceofbirth($placeofbirth = null)
    {
        // validation for constraint: string
        if (!is_null($placeofbirth) && !is_string($placeofbirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($placeofbirth, true), gettype($placeofbirth)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($placeofbirth) && mb_strlen($placeofbirth) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($placeofbirth)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($placeofbirth) && mb_strlen($placeofbirth) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($placeofbirth)), __LINE__);
        }
        $this->placeofbirth = $placeofbirth;
        return $this;
    }
    /**
     * Get birthcountry value
     * @return string
     */
    public function getBirthcountry()
    {
        return $this->birthcountry;
    }
    /**
     * Set birthcountry value
     * @param string $birthcountry
     * @return \StructType\PoliceListEntry
     */
    public function setBirthcountry($birthcountry = null)
    {
        // validation for constraint: string
        if (!is_null($birthcountry) && !is_string($birthcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthcountry, true), gettype($birthcountry)), __LINE__);
        }
        // validation for constraint: maxLength(9)
        if (!is_null($birthcountry) && mb_strlen($birthcountry) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 9', mb_strlen($birthcountry)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($birthcountry) && mb_strlen($birthcountry) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($birthcountry)), __LINE__);
        }
        $this->birthcountry = $birthcountry;
        return $this;
    }
    /**
     * Get passportno value
     * @return string
     */
    public function getPassportno()
    {
        return $this->passportno;
    }
    /**
     * Set passportno value
     * @param string $passportno
     * @return \StructType\PoliceListEntry
     */
    public function setPassportno($passportno = null)
    {
        // validation for constraint: string
        if (!is_null($passportno) && !is_string($passportno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passportno, true), gettype($passportno)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($passportno) && mb_strlen($passportno) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($passportno)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($passportno) && mb_strlen($passportno) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($passportno)), __LINE__);
        }
        $this->passportno = $passportno;
        return $this;
    }
    /**
     * Get passportdate value
     * @return string
     */
    public function getPassportdate()
    {
        return $this->passportdate;
    }
    /**
     * Set passportdate value
     * @param string $passportdate
     * @return \StructType\PoliceListEntry
     */
    public function setPassportdate($passportdate = null)
    {
        // validation for constraint: string
        if (!is_null($passportdate) && !is_string($passportdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passportdate, true), gettype($passportdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($passportdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $passportdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($passportdate, true)), __LINE__);
        }
        $this->passportdate = $passportdate;
        return $this;
    }
    /**
     * Get passporttype value
     * @return string
     */
    public function getPassporttype()
    {
        return $this->passporttype;
    }
    /**
     * Set passporttype value
     * @param string $passporttype
     * @return \StructType\PoliceListEntry
     */
    public function setPassporttype($passporttype = null)
    {
        // validation for constraint: string
        if (!is_null($passporttype) && !is_string($passporttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passporttype, true), gettype($passporttype)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($passporttype) && mb_strlen($passporttype) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($passporttype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($passporttype) && mb_strlen($passporttype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($passporttype)), __LINE__);
        }
        $this->passporttype = $passporttype;
        return $this;
    }
    /**
     * Get cardnumber value
     * @return string
     */
    public function getCardnumber()
    {
        return $this->cardnumber;
    }
    /**
     * Set cardnumber value
     * @param string $cardnumber
     * @return \StructType\PoliceListEntry
     */
    public function setCardnumber($cardnumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardnumber) && !is_string($cardnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardnumber, true), gettype($cardnumber)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($cardnumber) && mb_strlen($cardnumber) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($cardnumber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($cardnumber) && mb_strlen($cardnumber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($cardnumber)), __LINE__);
        }
        $this->cardnumber = $cardnumber;
        return $this;
    }
    /**
     * Get cardexpiry value
     * @return string
     */
    public function getCardexpiry()
    {
        return $this->cardexpiry;
    }
    /**
     * Set cardexpiry value
     * @param string $cardexpiry
     * @return \StructType\PoliceListEntry
     */
    public function setCardexpiry($cardexpiry = null)
    {
        // validation for constraint: string
        if (!is_null($cardexpiry) && !is_string($cardexpiry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardexpiry, true), gettype($cardexpiry)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($cardexpiry) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $cardexpiry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($cardexpiry, true)), __LINE__);
        }
        $this->cardexpiry = $cardexpiry;
        return $this;
    }
    /**
     * Get border value
     * @return string
     */
    public function getBorder()
    {
        return $this->border;
    }
    /**
     * Set border value
     * @param string $border
     * @return \StructType\PoliceListEntry
     */
    public function setBorder($border = null)
    {
        // validation for constraint: string
        if (!is_null($border) && !is_string($border)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($border, true), gettype($border)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($border) && mb_strlen($border) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($border)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($border) && mb_strlen($border) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($border)), __LINE__);
        }
        $this->border = $border;
        return $this;
    }
    /**
     * Get borderstation value
     * @return string
     */
    public function getBorderstation()
    {
        return $this->borderstation;
    }
    /**
     * Set borderstation value
     * @param string $borderstation
     * @return \StructType\PoliceListEntry
     */
    public function setBorderstation($borderstation = null)
    {
        // validation for constraint: string
        if (!is_null($borderstation) && !is_string($borderstation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($borderstation, true), gettype($borderstation)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($borderstation) && mb_strlen($borderstation) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($borderstation)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($borderstation) && mb_strlen($borderstation) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($borderstation)), __LINE__);
        }
        $this->borderstation = $borderstation;
        return $this;
    }
    /**
     * Get bordertown value
     * @return string
     */
    public function getBordertown()
    {
        return $this->bordertown;
    }
    /**
     * Set bordertown value
     * @param string $bordertown
     * @return \StructType\PoliceListEntry
     */
    public function setBordertown($bordertown = null)
    {
        // validation for constraint: string
        if (!is_null($bordertown) && !is_string($bordertown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bordertown, true), gettype($bordertown)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($bordertown) && mb_strlen($bordertown) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($bordertown)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($bordertown) && mb_strlen($bordertown) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($bordertown)), __LINE__);
        }
        $this->bordertown = $bordertown;
        return $this;
    }
    /**
     * Get nameofmother value
     * @return string
     */
    public function getNameofmother()
    {
        return $this->nameofmother;
    }
    /**
     * Set nameofmother value
     * @param string $nameofmother
     * @return \StructType\PoliceListEntry
     */
    public function setNameofmother($nameofmother = null)
    {
        // validation for constraint: string
        if (!is_null($nameofmother) && !is_string($nameofmother)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameofmother, true), gettype($nameofmother)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($nameofmother) && mb_strlen($nameofmother) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($nameofmother)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($nameofmother) && mb_strlen($nameofmother) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($nameofmother)), __LINE__);
        }
        $this->nameofmother = $nameofmother;
        return $this;
    }
    /**
     * Get nameoffather value
     * @return string
     */
    public function getNameoffather()
    {
        return $this->nameoffather;
    }
    /**
     * Set nameoffather value
     * @param string $nameoffather
     * @return \StructType\PoliceListEntry
     */
    public function setNameoffather($nameoffather = null)
    {
        // validation for constraint: string
        if (!is_null($nameoffather) && !is_string($nameoffather)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameoffather, true), gettype($nameoffather)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($nameoffather) && mb_strlen($nameoffather) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($nameoffather)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($nameoffather) && mb_strlen($nameoffather) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($nameoffather)), __LINE__);
        }
        $this->nameoffather = $nameoffather;
        return $this;
    }
    /**
     * Get nn1 value
     * @return string
     */
    public function getNn1()
    {
        return $this->nn1;
    }
    /**
     * Set nn1 value
     * @param string $nn1
     * @return \StructType\PoliceListEntry
     */
    public function setNn1($nn1 = null)
    {
        // validation for constraint: string
        if (!is_null($nn1) && !is_string($nn1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nn1, true), gettype($nn1)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($nn1) && mb_strlen($nn1) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($nn1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($nn1) && mb_strlen($nn1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($nn1)), __LINE__);
        }
        $this->nn1 = $nn1;
        return $this;
    }
    /**
     * Get nn2 value
     * @return string
     */
    public function getNn2()
    {
        return $this->nn2;
    }
    /**
     * Set nn2 value
     * @param string $nn2
     * @return \StructType\PoliceListEntry
     */
    public function setNn2($nn2 = null)
    {
        // validation for constraint: string
        if (!is_null($nn2) && !is_string($nn2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nn2, true), gettype($nn2)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($nn2) && mb_strlen($nn2) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($nn2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($nn2) && mb_strlen($nn2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($nn2)), __LINE__);
        }
        $this->nn2 = $nn2;
        return $this;
    }
    /**
     * Get identno1 value
     * @return string
     */
    public function getIdentno1()
    {
        return $this->identno1;
    }
    /**
     * Set identno1 value
     * @param string $identno1
     * @return \StructType\PoliceListEntry
     */
    public function setIdentno1($identno1 = null)
    {
        // validation for constraint: string
        if (!is_null($identno1) && !is_string($identno1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identno1, true), gettype($identno1)), __LINE__);
        }
        $this->identno1 = $identno1;
        return $this;
    }
    /**
     * Get identno2 value
     * @return string
     */
    public function getIdentno2()
    {
        return $this->identno2;
    }
    /**
     * Set identno2 value
     * @param string $identno2
     * @return \StructType\PoliceListEntry
     */
    public function setIdentno2($identno2 = null)
    {
        // validation for constraint: string
        if (!is_null($identno2) && !is_string($identno2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identno2, true), gettype($identno2)), __LINE__);
        }
        $this->identno2 = $identno2;
        return $this;
    }
    /**
     * Get identno3 value
     * @return string
     */
    public function getIdentno3()
    {
        return $this->identno3;
    }
    /**
     * Set identno3 value
     * @param string $identno3
     * @return \StructType\PoliceListEntry
     */
    public function setIdentno3($identno3 = null)
    {
        // validation for constraint: string
        if (!is_null($identno3) && !is_string($identno3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identno3, true), gettype($identno3)), __LINE__);
        }
        $this->identno3 = $identno3;
        return $this;
    }
    /**
     * Get identno4 value
     * @return string
     */
    public function getIdentno4()
    {
        return $this->identno4;
    }
    /**
     * Set identno4 value
     * @param string $identno4
     * @return \StructType\PoliceListEntry
     */
    public function setIdentno4($identno4 = null)
    {
        // validation for constraint: string
        if (!is_null($identno4) && !is_string($identno4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identno4, true), gettype($identno4)), __LINE__);
        }
        $this->identno4 = $identno4;
        return $this;
    }
    /**
     * Get identno5 value
     * @return string
     */
    public function getIdentno5()
    {
        return $this->identno5;
    }
    /**
     * Set identno5 value
     * @param string $identno5
     * @return \StructType\PoliceListEntry
     */
    public function setIdentno5($identno5 = null)
    {
        // validation for constraint: string
        if (!is_null($identno5) && !is_string($identno5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identno5, true), gettype($identno5)), __LINE__);
        }
        $this->identno5 = $identno5;
        return $this;
    }
    /**
     * Get identtype1 value
     * @return string
     */
    public function getIdenttype1()
    {
        return $this->identtype1;
    }
    /**
     * Set identtype1 value
     * @param string $identtype1
     * @return \StructType\PoliceListEntry
     */
    public function setIdenttype1($identtype1 = null)
    {
        // validation for constraint: string
        if (!is_null($identtype1) && !is_string($identtype1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identtype1, true), gettype($identtype1)), __LINE__);
        }
        $this->identtype1 = $identtype1;
        return $this;
    }
    /**
     * Get identtype2 value
     * @return string
     */
    public function getIdenttype2()
    {
        return $this->identtype2;
    }
    /**
     * Set identtype2 value
     * @param string $identtype2
     * @return \StructType\PoliceListEntry
     */
    public function setIdenttype2($identtype2 = null)
    {
        // validation for constraint: string
        if (!is_null($identtype2) && !is_string($identtype2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identtype2, true), gettype($identtype2)), __LINE__);
        }
        $this->identtype2 = $identtype2;
        return $this;
    }
    /**
     * Get identtype3 value
     * @return string
     */
    public function getIdenttype3()
    {
        return $this->identtype3;
    }
    /**
     * Set identtype3 value
     * @param string $identtype3
     * @return \StructType\PoliceListEntry
     */
    public function setIdenttype3($identtype3 = null)
    {
        // validation for constraint: string
        if (!is_null($identtype3) && !is_string($identtype3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identtype3, true), gettype($identtype3)), __LINE__);
        }
        $this->identtype3 = $identtype3;
        return $this;
    }
    /**
     * Get identtype4 value
     * @return string
     */
    public function getIdenttype4()
    {
        return $this->identtype4;
    }
    /**
     * Set identtype4 value
     * @param string $identtype4
     * @return \StructType\PoliceListEntry
     */
    public function setIdenttype4($identtype4 = null)
    {
        // validation for constraint: string
        if (!is_null($identtype4) && !is_string($identtype4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identtype4, true), gettype($identtype4)), __LINE__);
        }
        $this->identtype4 = $identtype4;
        return $this;
    }
    /**
     * Get identtype5 value
     * @return string
     */
    public function getIdenttype5()
    {
        return $this->identtype5;
    }
    /**
     * Set identtype5 value
     * @param string $identtype5
     * @return \StructType\PoliceListEntry
     */
    public function setIdenttype5($identtype5 = null)
    {
        // validation for constraint: string
        if (!is_null($identtype5) && !is_string($identtype5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identtype5, true), gettype($identtype5)), __LINE__);
        }
        $this->identtype5 = $identtype5;
        return $this;
    }
}
