<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Person StructType
 * @subpackage Structs
 */
class Person extends AbstractStructBase
{
    /**
     * The PERSON_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $PERSON_OBJID;
    /**
     * The externaltypefilter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $externaltypefilter;
    /**
     * The resno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $resno;
    /**
     * The name1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name1;
    /**
     * The name2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $name2;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $title;
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The sex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sex;
    /**
     * The guesttype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $guesttype;
    /**
     * The birthdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $birthdate;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $address;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $country;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $city;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $street;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $postcode;
    /**
     * The subcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $subcountry;
    /**
     * The marketsegment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $marketsegment;
    /**
     * The salutation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $salutation;
    /**
     * The email1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $email1;
    /**
     * The mobile1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $mobile1;
    /**
     * The ratecategory
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ratecategory;
    /**
     * The arrivaltime
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $arrivaltime;
    /**
     * The departuretime
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $departuretime;
    /**
     * The vip
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $vip;
    /**
     * The vip2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $vip2;
    /**
     * The iconsihotgoprecheckin
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $iconsihotgoprecheckin;
    /**
     * The room
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $room;
    /**
     * The iconprecheckin
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $iconprecheckin;
    /**
     * The personstatus
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $personstatus;
    /**
     * The GUEST_IDS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\GUEST_IDS
     */
    public $GUEST_IDS;
    /**
     * The LOYALTY_CARDS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\LOYALTY_CARDS
     */
    public $LOYALTY_CARDS;
    /**
     * The servicecode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $servicecode;
    /**
     * The GUEST_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $GUEST_OBJID;
    /**
     * The Client
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Client;
    /**
     * The persontype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $persontype;
    /**
     * The PersonPackage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\PersonPackage[]
     */
    public $PersonPackage;
    /**
     * The EXTERNALID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EXTERNALID[]
     */
    public $EXTERNALID;
    /**
     * The Feedback
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Feedback[]
     */
    public $Feedback;
    /**
     * The GUESTACCOUNT
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GUESTACCOUNT[]
     */
    public $GUESTACCOUNT;
    /**
     * The Guest
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Guest_1[]
     */
    public $Guest;
    /**
     * The CategoryUpselling
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CategoryUpselling[]
     */
    public $CategoryUpselling;
    /**
     * The UpsellingAddServices
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UpsellingAddServices[]
     */
    public $UpsellingAddServices;
    /**
     * The subsubcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subsubcountry;
    /**
     * The region
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $region;
    /**
     * The nationality
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 9
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $nationality;
    /**
     * The birthcountry
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 9
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $birthcountry;
    /**
     * The signature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $signature;
    /**
     * The documentnumber
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 44
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $documentnumber;
    /**
     * The documenttype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $documenttype;
    /**
     * The documentdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $documentdate;
    /**
     * The docissuingcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $docissuingcountry;
    /**
     * The RegistrationCard
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RegistrationCard[]
     */
    public $RegistrationCard;
    /**
     * The ratesegment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $ratesegment;
    /**
     * Constructor method for Person
     * @uses Person::setPERSON_OBJID()
     * @uses Person::setExternaltypefilter()
     * @uses Person::setResno()
     * @uses Person::setName1()
     * @uses Person::setName2()
     * @uses Person::setTitle()
     * @uses Person::setDatefrom()
     * @uses Person::setDateto()
     * @uses Person::setSex()
     * @uses Person::setGuesttype()
     * @uses Person::setBirthdate()
     * @uses Person::setAddress()
     * @uses Person::setCountry()
     * @uses Person::setCity()
     * @uses Person::setStreet()
     * @uses Person::setPostcode()
     * @uses Person::setSubcountry()
     * @uses Person::setMarketsegment()
     * @uses Person::setSalutation()
     * @uses Person::setEmail1()
     * @uses Person::setMobile1()
     * @uses Person::setRatecategory()
     * @uses Person::setArrivaltime()
     * @uses Person::setDeparturetime()
     * @uses Person::setVip()
     * @uses Person::setVip2()
     * @uses Person::setIconsihotgoprecheckin()
     * @uses Person::setRoom()
     * @uses Person::setIconprecheckin()
     * @uses Person::setPersonstatus()
     * @uses Person::setGUEST_IDS()
     * @uses Person::setLOYALTY_CARDS()
     * @uses Person::setServicecode()
     * @uses Person::setGUEST_OBJID()
     * @uses Person::setClient()
     * @uses Person::setPersontype()
     * @uses Person::setPersonPackage()
     * @uses Person::setEXTERNALID()
     * @uses Person::setFeedback()
     * @uses Person::setGUESTACCOUNT()
     * @uses Person::setGuest()
     * @uses Person::setCategoryUpselling()
     * @uses Person::setUpsellingAddServices()
     * @uses Person::setSubsubcountry()
     * @uses Person::setRegion()
     * @uses Person::setNationality()
     * @uses Person::setBirthcountry()
     * @uses Person::setSignature()
     * @uses Person::setDocumentnumber()
     * @uses Person::setDocumenttype()
     * @uses Person::setDocumentdate()
     * @uses Person::setDocissuingcountry()
     * @uses Person::setRegistrationCard()
     * @uses Person::setRatesegment()
     * @param string $pERSON_OBJID
     * @param string $externaltypefilter
     * @param string $resno
     * @param string $name1
     * @param string $name2
     * @param string $title
     * @param string $datefrom
     * @param string $dateto
     * @param string $sex
     * @param string $guesttype
     * @param string $birthdate
     * @param string $address
     * @param string $country
     * @param string $city
     * @param string $street
     * @param string $postcode
     * @param string $subcountry
     * @param string $marketsegment
     * @param string $salutation
     * @param string $email1
     * @param string $mobile1
     * @param string $ratecategory
     * @param string $arrivaltime
     * @param string $departuretime
     * @param string $vip
     * @param string $vip2
     * @param string $iconsihotgoprecheckin
     * @param string $room
     * @param string $iconprecheckin
     * @param string $personstatus
     * @param \StructType\GUEST_IDS $gUEST_IDS
     * @param \StructType\LOYALTY_CARDS $lOYALTY_CARDS
     * @param string $servicecode
     * @param string $gUEST_OBJID
     * @param string $client
     * @param string $persontype
     * @param \StructType\PersonPackage[] $personPackage
     * @param \StructType\EXTERNALID[] $eXTERNALID
     * @param \StructType\Feedback[] $feedback
     * @param \StructType\GUESTACCOUNT[] $gUESTACCOUNT
     * @param \StructType\Guest_1[] $guest
     * @param \StructType\CategoryUpselling[] $categoryUpselling
     * @param \StructType\UpsellingAddServices[] $upsellingAddServices
     * @param string $subsubcountry
     * @param string $region
     * @param string $nationality
     * @param string $birthcountry
     * @param string $signature
     * @param string $documentnumber
     * @param string $documenttype
     * @param string $documentdate
     * @param string $docissuingcountry
     * @param \StructType\RegistrationCard[] $registrationCard
     * @param string $ratesegment
     */
    public function __construct($pERSON_OBJID = null, $externaltypefilter = null, $resno = null, $name1 = null, $name2 = null, $title = null, $datefrom = null, $dateto = null, $sex = null, $guesttype = null, $birthdate = null, $address = null, $country = null, $city = null, $street = null, $postcode = null, $subcountry = null, $marketsegment = null, $salutation = null, $email1 = null, $mobile1 = null, $ratecategory = null, $arrivaltime = null, $departuretime = null, $vip = null, $vip2 = null, $iconsihotgoprecheckin = null, $room = null, $iconprecheckin = null, $personstatus = null, \StructType\GUEST_IDS $gUEST_IDS = null, \StructType\LOYALTY_CARDS $lOYALTY_CARDS = null, $servicecode = null, $gUEST_OBJID = null, $client = null, $persontype = null, array $personPackage = array(), array $eXTERNALID = array(), array $feedback = array(), array $gUESTACCOUNT = array(), array $guest = array(), array $categoryUpselling = array(), array $upsellingAddServices = array(), $subsubcountry = null, $region = null, $nationality = null, $birthcountry = null, $signature = null, $documentnumber = null, $documenttype = null, $documentdate = null, $docissuingcountry = null, array $registrationCard = array(), $ratesegment = null)
    {
        $this
            ->setPERSON_OBJID($pERSON_OBJID)
            ->setExternaltypefilter($externaltypefilter)
            ->setResno($resno)
            ->setName1($name1)
            ->setName2($name2)
            ->setTitle($title)
            ->setDatefrom($datefrom)
            ->setDateto($dateto)
            ->setSex($sex)
            ->setGuesttype($guesttype)
            ->setBirthdate($birthdate)
            ->setAddress($address)
            ->setCountry($country)
            ->setCity($city)
            ->setStreet($street)
            ->setPostcode($postcode)
            ->setSubcountry($subcountry)
            ->setMarketsegment($marketsegment)
            ->setSalutation($salutation)
            ->setEmail1($email1)
            ->setMobile1($mobile1)
            ->setRatecategory($ratecategory)
            ->setArrivaltime($arrivaltime)
            ->setDeparturetime($departuretime)
            ->setVip($vip)
            ->setVip2($vip2)
            ->setIconsihotgoprecheckin($iconsihotgoprecheckin)
            ->setRoom($room)
            ->setIconprecheckin($iconprecheckin)
            ->setPersonstatus($personstatus)
            ->setGUEST_IDS($gUEST_IDS)
            ->setLOYALTY_CARDS($lOYALTY_CARDS)
            ->setServicecode($servicecode)
            ->setGUEST_OBJID($gUEST_OBJID)
            ->setClient($client)
            ->setPersontype($persontype)
            ->setPersonPackage($personPackage)
            ->setEXTERNALID($eXTERNALID)
            ->setFeedback($feedback)
            ->setGUESTACCOUNT($gUESTACCOUNT)
            ->setGuest($guest)
            ->setCategoryUpselling($categoryUpselling)
            ->setUpsellingAddServices($upsellingAddServices)
            ->setSubsubcountry($subsubcountry)
            ->setRegion($region)
            ->setNationality($nationality)
            ->setBirthcountry($birthcountry)
            ->setSignature($signature)
            ->setDocumentnumber($documentnumber)
            ->setDocumenttype($documenttype)
            ->setDocumentdate($documentdate)
            ->setDocissuingcountry($docissuingcountry)
            ->setRegistrationCard($registrationCard)
            ->setRatesegment($ratesegment);
    }
    /**
     * Get PERSON_OBJID value
     * @return string
     */
    public function getPERSON_OBJID()
    {
        return $this->{'PERSON-OBJID'};
    }
    /**
     * Set PERSON_OBJID value
     * @param string $pERSON_OBJID
     * @return \StructType\Person
     */
    public function setPERSON_OBJID($pERSON_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($pERSON_OBJID) && !is_string($pERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pERSON_OBJID, true), gettype($pERSON_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($pERSON_OBJID) && !preg_match('/([0-9])*/', $pERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($pERSON_OBJID, true)), __LINE__);
        }
        $this->PERSON_OBJID = $this->{'PERSON-OBJID'} = $pERSON_OBJID;
        return $this;
    }
    /**
     * Get externaltypefilter value
     * @return string
     */
    public function getExternaltypefilter()
    {
        return $this->externaltypefilter;
    }
    /**
     * Set externaltypefilter value
     * @param string $externaltypefilter
     * @return \StructType\Person
     */
    public function setExternaltypefilter($externaltypefilter = null)
    {
        // validation for constraint: string
        if (!is_null($externaltypefilter) && !is_string($externaltypefilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externaltypefilter, true), gettype($externaltypefilter)), __LINE__);
        }
        $this->externaltypefilter = $externaltypefilter;
        return $this;
    }
    /**
     * Get resno value
     * @return string
     */
    public function getResno()
    {
        return $this->resno;
    }
    /**
     * Set resno value
     * @param string $resno
     * @return \StructType\Person
     */
    public function setResno($resno = null)
    {
        // validation for constraint: string
        if (!is_null($resno) && !is_string($resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resno, true), gettype($resno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($resno) && !preg_match('/([-+]){0,1}([0-9])*/', $resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($resno, true)), __LINE__);
        }
        $this->resno = $resno;
        return $this;
    }
    /**
     * Get name1 value
     * @return string
     */
    public function getName1()
    {
        return $this->name1;
    }
    /**
     * Set name1 value
     * @param string $name1
     * @return \StructType\Person
     */
    public function setName1($name1 = null)
    {
        // validation for constraint: string
        if (!is_null($name1) && !is_string($name1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name1, true), gettype($name1)), __LINE__);
        }
        $this->name1 = $name1;
        return $this;
    }
    /**
     * Get name2 value
     * @return string
     */
    public function getName2()
    {
        return $this->name2;
    }
    /**
     * Set name2 value
     * @param string $name2
     * @return \StructType\Person
     */
    public function setName2($name2 = null)
    {
        // validation for constraint: string
        if (!is_null($name2) && !is_string($name2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name2, true), gettype($name2)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name2) && mb_strlen($name2) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($name2) && mb_strlen($name2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($name2)), __LINE__);
        }
        $this->name2 = $name2;
        return $this;
    }
    /**
     * Get title value
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\Person
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get datefrom value
     * @return string
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\Person
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get dateto value
     * @return string
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\Person
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get sex value
     * @return string
     */
    public function getSex()
    {
        return $this->sex;
    }
    /**
     * Set sex value
     * @param string $sex
     * @return \StructType\Person
     */
    public function setSex($sex = null)
    {
        // validation for constraint: string
        if (!is_null($sex) && !is_string($sex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sex, true), gettype($sex)), __LINE__);
        }
        $this->sex = $sex;
        return $this;
    }
    /**
     * Get guesttype value
     * @return string
     */
    public function getGuesttype()
    {
        return $this->guesttype;
    }
    /**
     * Set guesttype value
     * @param string $guesttype
     * @return \StructType\Person
     */
    public function setGuesttype($guesttype = null)
    {
        // validation for constraint: string
        if (!is_null($guesttype) && !is_string($guesttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guesttype, true), gettype($guesttype)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($guesttype) && mb_strlen($guesttype) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($guesttype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($guesttype) && mb_strlen($guesttype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($guesttype)), __LINE__);
        }
        $this->guesttype = $guesttype;
        return $this;
    }
    /**
     * Get birthdate value
     * @return string
     */
    public function getBirthdate()
    {
        return $this->birthdate;
    }
    /**
     * Set birthdate value
     * @param string $birthdate
     * @return \StructType\Person
     */
    public function setBirthdate($birthdate = null)
    {
        // validation for constraint: string
        if (!is_null($birthdate) && !is_string($birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthdate, true), gettype($birthdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($birthdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($birthdate, true)), __LINE__);
        }
        $this->birthdate = $birthdate;
        return $this;
    }
    /**
     * Get address value
     * @return string
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\Person
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get country value
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\Person
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get city value
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\Person
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city) && mb_strlen($city) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($city) && mb_strlen($city) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get street value
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\Person
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($street) && mb_strlen($street) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($street)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($street) && mb_strlen($street) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get postcode value
     * @return string
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\Person
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($postcode) && mb_strlen($postcode) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($postcode)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($postcode) && mb_strlen($postcode) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get subcountry value
     * @return string
     */
    public function getSubcountry()
    {
        return $this->subcountry;
    }
    /**
     * Set subcountry value
     * @param string $subcountry
     * @return \StructType\Person
     */
    public function setSubcountry($subcountry = null)
    {
        // validation for constraint: string
        if (!is_null($subcountry) && !is_string($subcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subcountry, true), gettype($subcountry)), __LINE__);
        }
        $this->subcountry = $subcountry;
        return $this;
    }
    /**
     * Get marketsegment value
     * @return string
     */
    public function getMarketsegment()
    {
        return $this->marketsegment;
    }
    /**
     * Set marketsegment value
     * @param string $marketsegment
     * @return \StructType\Person
     */
    public function setMarketsegment($marketsegment = null)
    {
        // validation for constraint: string
        if (!is_null($marketsegment) && !is_string($marketsegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketsegment, true), gettype($marketsegment)), __LINE__);
        }
        $this->marketsegment = $marketsegment;
        return $this;
    }
    /**
     * Get salutation value
     * @return string
     */
    public function getSalutation()
    {
        return $this->salutation;
    }
    /**
     * Set salutation value
     * @param string $salutation
     * @return \StructType\Person
     */
    public function setSalutation($salutation = null)
    {
        // validation for constraint: string
        if (!is_null($salutation) && !is_string($salutation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salutation, true), gettype($salutation)), __LINE__);
        }
        $this->salutation = $salutation;
        return $this;
    }
    /**
     * Get email1 value
     * @return string
     */
    public function getEmail1()
    {
        return $this->email1;
    }
    /**
     * Set email1 value
     * @param string $email1
     * @return \StructType\Person
     */
    public function setEmail1($email1 = null)
    {
        // validation for constraint: string
        if (!is_null($email1) && !is_string($email1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email1, true), gettype($email1)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($email1) && mb_strlen($email1) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($email1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($email1) && mb_strlen($email1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($email1)), __LINE__);
        }
        $this->email1 = $email1;
        return $this;
    }
    /**
     * Get mobile1 value
     * @return string
     */
    public function getMobile1()
    {
        return $this->mobile1;
    }
    /**
     * Set mobile1 value
     * @param string $mobile1
     * @return \StructType\Person
     */
    public function setMobile1($mobile1 = null)
    {
        // validation for constraint: string
        if (!is_null($mobile1) && !is_string($mobile1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile1, true), gettype($mobile1)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($mobile1) && mb_strlen($mobile1) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($mobile1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($mobile1) && mb_strlen($mobile1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($mobile1)), __LINE__);
        }
        $this->mobile1 = $mobile1;
        return $this;
    }
    /**
     * Get ratecategory value
     * @return string
     */
    public function getRatecategory()
    {
        return $this->ratecategory;
    }
    /**
     * Set ratecategory value
     * @param string $ratecategory
     * @return \StructType\Person
     */
    public function setRatecategory($ratecategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratecategory) && !is_string($ratecategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratecategory, true), gettype($ratecategory)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($ratecategory) && mb_strlen($ratecategory) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($ratecategory)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ratecategory) && mb_strlen($ratecategory) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ratecategory)), __LINE__);
        }
        $this->ratecategory = $ratecategory;
        return $this;
    }
    /**
     * Get arrivaltime value
     * @return string
     */
    public function getArrivaltime()
    {
        return $this->arrivaltime;
    }
    /**
     * Set arrivaltime value
     * @param string $arrivaltime
     * @return \StructType\Person
     */
    public function setArrivaltime($arrivaltime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivaltime) && !is_string($arrivaltime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivaltime, true), gettype($arrivaltime)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($arrivaltime) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $arrivaltime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($arrivaltime, true)), __LINE__);
        }
        $this->arrivaltime = $arrivaltime;
        return $this;
    }
    /**
     * Get departuretime value
     * @return string
     */
    public function getDeparturetime()
    {
        return $this->departuretime;
    }
    /**
     * Set departuretime value
     * @param string $departuretime
     * @return \StructType\Person
     */
    public function setDeparturetime($departuretime = null)
    {
        // validation for constraint: string
        if (!is_null($departuretime) && !is_string($departuretime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departuretime, true), gettype($departuretime)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($departuretime) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $departuretime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($departuretime, true)), __LINE__);
        }
        $this->departuretime = $departuretime;
        return $this;
    }
    /**
     * Get vip value
     * @return string
     */
    public function getVip()
    {
        return $this->vip;
    }
    /**
     * Set vip value
     * @param string $vip
     * @return \StructType\Person
     */
    public function setVip($vip = null)
    {
        // validation for constraint: string
        if (!is_null($vip) && !is_string($vip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vip, true), gettype($vip)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($vip) && mb_strlen($vip) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($vip)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vip) && mb_strlen($vip) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vip)), __LINE__);
        }
        $this->vip = $vip;
        return $this;
    }
    /**
     * Get vip2 value
     * @return string
     */
    public function getVip2()
    {
        return $this->vip2;
    }
    /**
     * Set vip2 value
     * @param string $vip2
     * @return \StructType\Person
     */
    public function setVip2($vip2 = null)
    {
        // validation for constraint: string
        if (!is_null($vip2) && !is_string($vip2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vip2, true), gettype($vip2)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($vip2) && mb_strlen($vip2) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($vip2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vip2) && mb_strlen($vip2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vip2)), __LINE__);
        }
        $this->vip2 = $vip2;
        return $this;
    }
    /**
     * Get iconsihotgoprecheckin value
     * @return string
     */
    public function getIconsihotgoprecheckin()
    {
        return $this->iconsihotgoprecheckin;
    }
    /**
     * Set iconsihotgoprecheckin value
     * @param string $iconsihotgoprecheckin
     * @return \StructType\Person
     */
    public function setIconsihotgoprecheckin($iconsihotgoprecheckin = null)
    {
        // validation for constraint: string
        if (!is_null($iconsihotgoprecheckin) && !is_string($iconsihotgoprecheckin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iconsihotgoprecheckin, true), gettype($iconsihotgoprecheckin)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($iconsihotgoprecheckin) && !preg_match('/([-+]){0,1}([0-9])*/', $iconsihotgoprecheckin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($iconsihotgoprecheckin, true)), __LINE__);
        }
        $this->iconsihotgoprecheckin = $iconsihotgoprecheckin;
        return $this;
    }
    /**
     * Get room value
     * @return string
     */
    public function getRoom()
    {
        return $this->room;
    }
    /**
     * Set room value
     * @param string $room
     * @return \StructType\Person
     */
    public function setRoom($room = null)
    {
        // validation for constraint: string
        if (!is_null($room) && !is_string($room)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($room, true), gettype($room)), __LINE__);
        }
        $this->room = $room;
        return $this;
    }
    /**
     * Get iconprecheckin value
     * @return string
     */
    public function getIconprecheckin()
    {
        return $this->iconprecheckin;
    }
    /**
     * Set iconprecheckin value
     * @param string $iconprecheckin
     * @return \StructType\Person
     */
    public function setIconprecheckin($iconprecheckin = null)
    {
        // validation for constraint: string
        if (!is_null($iconprecheckin) && !is_string($iconprecheckin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iconprecheckin, true), gettype($iconprecheckin)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($iconprecheckin) && !preg_match('/([-+]){0,1}([0-9])*/', $iconprecheckin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($iconprecheckin, true)), __LINE__);
        }
        $this->iconprecheckin = $iconprecheckin;
        return $this;
    }
    /**
     * Get personstatus value
     * @return string
     */
    public function getPersonstatus()
    {
        return $this->personstatus;
    }
    /**
     * Set personstatus value
     * @param string $personstatus
     * @return \StructType\Person
     */
    public function setPersonstatus($personstatus = null)
    {
        // validation for constraint: string
        if (!is_null($personstatus) && !is_string($personstatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personstatus, true), gettype($personstatus)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($personstatus) && !preg_match('/([-+]){0,1}([0-9])*/', $personstatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($personstatus, true)), __LINE__);
        }
        $this->personstatus = $personstatus;
        return $this;
    }
    /**
     * Get GUEST_IDS value
     * @return \StructType\GUEST_IDS
     */
    public function getGUEST_IDS()
    {
        return $this->{'GUEST-IDS'};
    }
    /**
     * Set GUEST_IDS value
     * @param \StructType\GUEST_IDS $gUEST_IDS
     * @return \StructType\Person
     */
    public function setGUEST_IDS(\StructType\GUEST_IDS $gUEST_IDS = null)
    {
        $this->GUEST_IDS = $this->{'GUEST-IDS'} = $gUEST_IDS;
        return $this;
    }
    /**
     * Get LOYALTY_CARDS value
     * @return \StructType\LOYALTY_CARDS
     */
    public function getLOYALTY_CARDS()
    {
        return $this->{'LOYALTY-CARDS'};
    }
    /**
     * Set LOYALTY_CARDS value
     * @param \StructType\LOYALTY_CARDS $lOYALTY_CARDS
     * @return \StructType\Person
     */
    public function setLOYALTY_CARDS(\StructType\LOYALTY_CARDS $lOYALTY_CARDS = null)
    {
        $this->LOYALTY_CARDS = $this->{'LOYALTY-CARDS'} = $lOYALTY_CARDS;
        return $this;
    }
    /**
     * Get servicecode value
     * @return string
     */
    public function getServicecode()
    {
        return $this->servicecode;
    }
    /**
     * Set servicecode value
     * @param string $servicecode
     * @return \StructType\Person
     */
    public function setServicecode($servicecode = null)
    {
        // validation for constraint: string
        if (!is_null($servicecode) && !is_string($servicecode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicecode, true), gettype($servicecode)), __LINE__);
        }
        $this->servicecode = $servicecode;
        return $this;
    }
    /**
     * Get GUEST_OBJID value
     * @return string
     */
    public function getGUEST_OBJID()
    {
        return $this->{'GUEST-OBJID'};
    }
    /**
     * Set GUEST_OBJID value
     * @param string $gUEST_OBJID
     * @return \StructType\Person
     */
    public function setGUEST_OBJID($gUEST_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($gUEST_OBJID) && !is_string($gUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gUEST_OBJID, true), gettype($gUEST_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($gUEST_OBJID) && !preg_match('/([0-9])*/', $gUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($gUEST_OBJID, true)), __LINE__);
        }
        $this->GUEST_OBJID = $this->{'GUEST-OBJID'} = $gUEST_OBJID;
        return $this;
    }
    /**
     * Get Client value
     * @return string
     */
    public function getClient()
    {
        return $this->Client;
    }
    /**
     * Set Client value
     * @param string $client
     * @return \StructType\Person
     */
    public function setClient($client = null)
    {
        // validation for constraint: string
        if (!is_null($client) && !is_string($client)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($client, true), gettype($client)), __LINE__);
        }
        $this->Client = $client;
        return $this;
    }
    /**
     * Get persontype value
     * @return string
     */
    public function getPersontype()
    {
        return $this->persontype;
    }
    /**
     * Set persontype value
     * @param string $persontype
     * @return \StructType\Person
     */
    public function setPersontype($persontype = null)
    {
        // validation for constraint: string
        if (!is_null($persontype) && !is_string($persontype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($persontype, true), gettype($persontype)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($persontype) && mb_strlen($persontype) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($persontype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($persontype) && mb_strlen($persontype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($persontype)), __LINE__);
        }
        $this->persontype = $persontype;
        return $this;
    }
    /**
     * Get PersonPackage value
     * @return \StructType\PersonPackage[]
     */
    public function getPersonPackage()
    {
        return $this->PersonPackage;
    }
    /**
     * This method is responsible for validating the values passed to the setPersonPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersonPackageForArrayConstraintsFromSetPersonPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personPersonPackageItem) {
            // validation for constraint: itemType
            if (!$personPersonPackageItem instanceof \StructType\PersonPackage) {
                $invalidValues[] = is_object($personPersonPackageItem) ? get_class($personPersonPackageItem) : sprintf('%s(%s)', gettype($personPersonPackageItem), var_export($personPersonPackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PersonPackage property can only contain items of type \StructType\PersonPackage, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PersonPackage value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonPackage[] $personPackage
     * @return \StructType\Person
     */
    public function setPersonPackage(array $personPackage = array())
    {
        // validation for constraint: array
        if ('' !== ($personPackageArrayErrorMessage = self::validatePersonPackageForArrayConstraintsFromSetPersonPackage($personPackage))) {
            throw new \InvalidArgumentException($personPackageArrayErrorMessage, __LINE__);
        }
        $this->PersonPackage = $personPackage;
        return $this;
    }
    /**
     * Add item to PersonPackage value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonPackage $item
     * @return \StructType\Person
     */
    public function addToPersonPackage(\StructType\PersonPackage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PersonPackage) {
            throw new \InvalidArgumentException(sprintf('The PersonPackage property can only contain items of type \StructType\PersonPackage, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PersonPackage[] = $item;
        return $this;
    }
    /**
     * Get EXTERNALID value
     * @return \StructType\EXTERNALID[]|null
     */
    public function getEXTERNALID()
    {
        return $this->EXTERNALID;
    }
    /**
     * This method is responsible for validating the values passed to the setEXTERNALID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEXTERNALID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEXTERNALIDForArrayConstraintsFromSetEXTERNALID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personEXTERNALIDItem) {
            // validation for constraint: itemType
            if (!$personEXTERNALIDItem instanceof \StructType\EXTERNALID) {
                $invalidValues[] = is_object($personEXTERNALIDItem) ? get_class($personEXTERNALIDItem) : sprintf('%s(%s)', gettype($personEXTERNALIDItem), var_export($personEXTERNALIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EXTERNALID property can only contain items of type \StructType\EXTERNALID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EXTERNALID value
     * @throws \InvalidArgumentException
     * @param \StructType\EXTERNALID[] $eXTERNALID
     * @return \StructType\Person
     */
    public function setEXTERNALID(array $eXTERNALID = array())
    {
        // validation for constraint: array
        if ('' !== ($eXTERNALIDArrayErrorMessage = self::validateEXTERNALIDForArrayConstraintsFromSetEXTERNALID($eXTERNALID))) {
            throw new \InvalidArgumentException($eXTERNALIDArrayErrorMessage, __LINE__);
        }
        $this->EXTERNALID = $eXTERNALID;
        return $this;
    }
    /**
     * Add item to EXTERNALID value
     * @throws \InvalidArgumentException
     * @param \StructType\EXTERNALID $item
     * @return \StructType\Person
     */
    public function addToEXTERNALID(\StructType\EXTERNALID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EXTERNALID) {
            throw new \InvalidArgumentException(sprintf('The EXTERNALID property can only contain items of type \StructType\EXTERNALID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EXTERNALID[] = $item;
        return $this;
    }
    /**
     * Get Feedback value
     * @return \StructType\Feedback[]|null
     */
    public function getFeedback()
    {
        return $this->Feedback;
    }
    /**
     * This method is responsible for validating the values passed to the setFeedback method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFeedback method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFeedbackForArrayConstraintsFromSetFeedback(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personFeedbackItem) {
            // validation for constraint: itemType
            if (!$personFeedbackItem instanceof \StructType\Feedback) {
                $invalidValues[] = is_object($personFeedbackItem) ? get_class($personFeedbackItem) : sprintf('%s(%s)', gettype($personFeedbackItem), var_export($personFeedbackItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Feedback property can only contain items of type \StructType\Feedback, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Feedback value
     * @throws \InvalidArgumentException
     * @param \StructType\Feedback[] $feedback
     * @return \StructType\Person
     */
    public function setFeedback(array $feedback = array())
    {
        // validation for constraint: array
        if ('' !== ($feedbackArrayErrorMessage = self::validateFeedbackForArrayConstraintsFromSetFeedback($feedback))) {
            throw new \InvalidArgumentException($feedbackArrayErrorMessage, __LINE__);
        }
        $this->Feedback = $feedback;
        return $this;
    }
    /**
     * Add item to Feedback value
     * @throws \InvalidArgumentException
     * @param \StructType\Feedback $item
     * @return \StructType\Person
     */
    public function addToFeedback(\StructType\Feedback $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Feedback) {
            throw new \InvalidArgumentException(sprintf('The Feedback property can only contain items of type \StructType\Feedback, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Feedback[] = $item;
        return $this;
    }
    /**
     * Get GUESTACCOUNT value
     * @return \StructType\GUESTACCOUNT[]|null
     */
    public function getGUESTACCOUNT()
    {
        return $this->GUESTACCOUNT;
    }
    /**
     * This method is responsible for validating the values passed to the setGUESTACCOUNT method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGUESTACCOUNT method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGUESTACCOUNTForArrayConstraintsFromSetGUESTACCOUNT(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personGUESTACCOUNTItem) {
            // validation for constraint: itemType
            if (!$personGUESTACCOUNTItem instanceof \StructType\GUESTACCOUNT) {
                $invalidValues[] = is_object($personGUESTACCOUNTItem) ? get_class($personGUESTACCOUNTItem) : sprintf('%s(%s)', gettype($personGUESTACCOUNTItem), var_export($personGUESTACCOUNTItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GUESTACCOUNT property can only contain items of type \StructType\GUESTACCOUNT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GUESTACCOUNT value
     * @throws \InvalidArgumentException
     * @param \StructType\GUESTACCOUNT[] $gUESTACCOUNT
     * @return \StructType\Person
     */
    public function setGUESTACCOUNT(array $gUESTACCOUNT = array())
    {
        // validation for constraint: array
        if ('' !== ($gUESTACCOUNTArrayErrorMessage = self::validateGUESTACCOUNTForArrayConstraintsFromSetGUESTACCOUNT($gUESTACCOUNT))) {
            throw new \InvalidArgumentException($gUESTACCOUNTArrayErrorMessage, __LINE__);
        }
        $this->GUESTACCOUNT = $gUESTACCOUNT;
        return $this;
    }
    /**
     * Add item to GUESTACCOUNT value
     * @throws \InvalidArgumentException
     * @param \StructType\GUESTACCOUNT $item
     * @return \StructType\Person
     */
    public function addToGUESTACCOUNT(\StructType\GUESTACCOUNT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GUESTACCOUNT) {
            throw new \InvalidArgumentException(sprintf('The GUESTACCOUNT property can only contain items of type \StructType\GUESTACCOUNT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GUESTACCOUNT[] = $item;
        return $this;
    }
    /**
     * Get Guest value
     * @return \StructType\Guest_1[]|null
     */
    public function getGuest()
    {
        return $this->Guest;
    }
    /**
     * This method is responsible for validating the values passed to the setGuest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuestForArrayConstraintsFromSetGuest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personGuestItem) {
            // validation for constraint: itemType
            if (!$personGuestItem instanceof \StructType\Guest_1) {
                $invalidValues[] = is_object($personGuestItem) ? get_class($personGuestItem) : sprintf('%s(%s)', gettype($personGuestItem), var_export($personGuestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Guest property can only contain items of type \StructType\Guest_1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Guest value
     * @throws \InvalidArgumentException
     * @param \StructType\Guest_1[] $guest
     * @return \StructType\Person
     */
    public function setGuest(array $guest = array())
    {
        // validation for constraint: array
        if ('' !== ($guestArrayErrorMessage = self::validateGuestForArrayConstraintsFromSetGuest($guest))) {
            throw new \InvalidArgumentException($guestArrayErrorMessage, __LINE__);
        }
        $this->Guest = $guest;
        return $this;
    }
    /**
     * Add item to Guest value
     * @throws \InvalidArgumentException
     * @param \StructType\Guest_1 $item
     * @return \StructType\Person
     */
    public function addToGuest(\StructType\Guest_1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Guest_1) {
            throw new \InvalidArgumentException(sprintf('The Guest property can only contain items of type \StructType\Guest_1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Guest[] = $item;
        return $this;
    }
    /**
     * Get CategoryUpselling value
     * @return \StructType\CategoryUpselling[]|null
     */
    public function getCategoryUpselling()
    {
        return $this->CategoryUpselling;
    }
    /**
     * This method is responsible for validating the values passed to the setCategoryUpselling method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCategoryUpselling method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCategoryUpsellingForArrayConstraintsFromSetCategoryUpselling(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personCategoryUpsellingItem) {
            // validation for constraint: itemType
            if (!$personCategoryUpsellingItem instanceof \StructType\CategoryUpselling) {
                $invalidValues[] = is_object($personCategoryUpsellingItem) ? get_class($personCategoryUpsellingItem) : sprintf('%s(%s)', gettype($personCategoryUpsellingItem), var_export($personCategoryUpsellingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CategoryUpselling property can only contain items of type \StructType\CategoryUpselling, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CategoryUpselling value
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryUpselling[] $categoryUpselling
     * @return \StructType\Person
     */
    public function setCategoryUpselling(array $categoryUpselling = array())
    {
        // validation for constraint: array
        if ('' !== ($categoryUpsellingArrayErrorMessage = self::validateCategoryUpsellingForArrayConstraintsFromSetCategoryUpselling($categoryUpselling))) {
            throw new \InvalidArgumentException($categoryUpsellingArrayErrorMessage, __LINE__);
        }
        $this->CategoryUpselling = $categoryUpselling;
        return $this;
    }
    /**
     * Add item to CategoryUpselling value
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryUpselling $item
     * @return \StructType\Person
     */
    public function addToCategoryUpselling(\StructType\CategoryUpselling $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CategoryUpselling) {
            throw new \InvalidArgumentException(sprintf('The CategoryUpselling property can only contain items of type \StructType\CategoryUpselling, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CategoryUpselling[] = $item;
        return $this;
    }
    /**
     * Get UpsellingAddServices value
     * @return \StructType\UpsellingAddServices[]|null
     */
    public function getUpsellingAddServices()
    {
        return $this->UpsellingAddServices;
    }
    /**
     * This method is responsible for validating the values passed to the setUpsellingAddServices method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUpsellingAddServices method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUpsellingAddServicesForArrayConstraintsFromSetUpsellingAddServices(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personUpsellingAddServicesItem) {
            // validation for constraint: itemType
            if (!$personUpsellingAddServicesItem instanceof \StructType\UpsellingAddServices) {
                $invalidValues[] = is_object($personUpsellingAddServicesItem) ? get_class($personUpsellingAddServicesItem) : sprintf('%s(%s)', gettype($personUpsellingAddServicesItem), var_export($personUpsellingAddServicesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UpsellingAddServices property can only contain items of type \StructType\UpsellingAddServices, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UpsellingAddServices value
     * @throws \InvalidArgumentException
     * @param \StructType\UpsellingAddServices[] $upsellingAddServices
     * @return \StructType\Person
     */
    public function setUpsellingAddServices(array $upsellingAddServices = array())
    {
        // validation for constraint: array
        if ('' !== ($upsellingAddServicesArrayErrorMessage = self::validateUpsellingAddServicesForArrayConstraintsFromSetUpsellingAddServices($upsellingAddServices))) {
            throw new \InvalidArgumentException($upsellingAddServicesArrayErrorMessage, __LINE__);
        }
        $this->UpsellingAddServices = $upsellingAddServices;
        return $this;
    }
    /**
     * Add item to UpsellingAddServices value
     * @throws \InvalidArgumentException
     * @param \StructType\UpsellingAddServices $item
     * @return \StructType\Person
     */
    public function addToUpsellingAddServices(\StructType\UpsellingAddServices $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UpsellingAddServices) {
            throw new \InvalidArgumentException(sprintf('The UpsellingAddServices property can only contain items of type \StructType\UpsellingAddServices, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UpsellingAddServices[] = $item;
        return $this;
    }
    /**
     * Get subsubcountry value
     * @return string|null
     */
    public function getSubsubcountry()
    {
        return $this->subsubcountry;
    }
    /**
     * Set subsubcountry value
     * @param string $subsubcountry
     * @return \StructType\Person
     */
    public function setSubsubcountry($subsubcountry = null)
    {
        // validation for constraint: string
        if (!is_null($subsubcountry) && !is_string($subsubcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsubcountry, true), gettype($subsubcountry)), __LINE__);
        }
        $this->subsubcountry = $subsubcountry;
        return $this;
    }
    /**
     * Get region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param string $region
     * @return \StructType\Person
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($region, true), gettype($region)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($region) && mb_strlen($region) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($region)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($region) && mb_strlen($region) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($region)), __LINE__);
        }
        $this->region = $region;
        return $this;
    }
    /**
     * Get nationality value
     * @return string|null
     */
    public function getNationality()
    {
        return $this->nationality;
    }
    /**
     * Set nationality value
     * @param string $nationality
     * @return \StructType\Person
     */
    public function setNationality($nationality = null)
    {
        // validation for constraint: string
        if (!is_null($nationality) && !is_string($nationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationality, true), gettype($nationality)), __LINE__);
        }
        // validation for constraint: maxLength(9)
        if (!is_null($nationality) && mb_strlen($nationality) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 9', mb_strlen($nationality)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($nationality) && mb_strlen($nationality) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($nationality)), __LINE__);
        }
        $this->nationality = $nationality;
        return $this;
    }
    /**
     * Get birthcountry value
     * @return string|null
     */
    public function getBirthcountry()
    {
        return $this->birthcountry;
    }
    /**
     * Set birthcountry value
     * @param string $birthcountry
     * @return \StructType\Person
     */
    public function setBirthcountry($birthcountry = null)
    {
        // validation for constraint: string
        if (!is_null($birthcountry) && !is_string($birthcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthcountry, true), gettype($birthcountry)), __LINE__);
        }
        // validation for constraint: maxLength(9)
        if (!is_null($birthcountry) && mb_strlen($birthcountry) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 9', mb_strlen($birthcountry)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($birthcountry) && mb_strlen($birthcountry) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($birthcountry)), __LINE__);
        }
        $this->birthcountry = $birthcountry;
        return $this;
    }
    /**
     * Get signature value
     * @return string|null
     */
    public function getSignature()
    {
        return $this->signature;
    }
    /**
     * Set signature value
     * @param string $signature
     * @return \StructType\Person
     */
    public function setSignature($signature = null)
    {
        // validation for constraint: string
        if (!is_null($signature) && !is_string($signature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signature, true), gettype($signature)), __LINE__);
        }
        $this->signature = $signature;
        return $this;
    }
    /**
     * Get documentnumber value
     * @return string|null
     */
    public function getDocumentnumber()
    {
        return $this->documentnumber;
    }
    /**
     * Set documentnumber value
     * @param string $documentnumber
     * @return \StructType\Person
     */
    public function setDocumentnumber($documentnumber = null)
    {
        // validation for constraint: string
        if (!is_null($documentnumber) && !is_string($documentnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentnumber, true), gettype($documentnumber)), __LINE__);
        }
        // validation for constraint: maxLength(44)
        if (!is_null($documentnumber) && mb_strlen($documentnumber) > 44) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 44', mb_strlen($documentnumber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($documentnumber) && mb_strlen($documentnumber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($documentnumber)), __LINE__);
        }
        $this->documentnumber = $documentnumber;
        return $this;
    }
    /**
     * Get documenttype value
     * @return string|null
     */
    public function getDocumenttype()
    {
        return $this->documenttype;
    }
    /**
     * Set documenttype value
     * @param string $documenttype
     * @return \StructType\Person
     */
    public function setDocumenttype($documenttype = null)
    {
        // validation for constraint: string
        if (!is_null($documenttype) && !is_string($documenttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documenttype, true), gettype($documenttype)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($documenttype) && mb_strlen($documenttype) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($documenttype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($documenttype) && mb_strlen($documenttype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($documenttype)), __LINE__);
        }
        $this->documenttype = $documenttype;
        return $this;
    }
    /**
     * Get documentdate value
     * @return string|null
     */
    public function getDocumentdate()
    {
        return $this->documentdate;
    }
    /**
     * Set documentdate value
     * @param string $documentdate
     * @return \StructType\Person
     */
    public function setDocumentdate($documentdate = null)
    {
        // validation for constraint: string
        if (!is_null($documentdate) && !is_string($documentdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentdate, true), gettype($documentdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($documentdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $documentdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($documentdate, true)), __LINE__);
        }
        $this->documentdate = $documentdate;
        return $this;
    }
    /**
     * Get docissuingcountry value
     * @return string|null
     */
    public function getDocissuingcountry()
    {
        return $this->docissuingcountry;
    }
    /**
     * Set docissuingcountry value
     * @param string $docissuingcountry
     * @return \StructType\Person
     */
    public function setDocissuingcountry($docissuingcountry = null)
    {
        // validation for constraint: string
        if (!is_null($docissuingcountry) && !is_string($docissuingcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docissuingcountry, true), gettype($docissuingcountry)), __LINE__);
        }
        $this->docissuingcountry = $docissuingcountry;
        return $this;
    }
    /**
     * Get RegistrationCard value
     * @return \StructType\RegistrationCard[]|null
     */
    public function getRegistrationCard()
    {
        return $this->RegistrationCard;
    }
    /**
     * This method is responsible for validating the values passed to the setRegistrationCard method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRegistrationCard method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRegistrationCardForArrayConstraintsFromSetRegistrationCard(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personRegistrationCardItem) {
            // validation for constraint: itemType
            if (!$personRegistrationCardItem instanceof \StructType\RegistrationCard) {
                $invalidValues[] = is_object($personRegistrationCardItem) ? get_class($personRegistrationCardItem) : sprintf('%s(%s)', gettype($personRegistrationCardItem), var_export($personRegistrationCardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RegistrationCard property can only contain items of type \StructType\RegistrationCard, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RegistrationCard value
     * @throws \InvalidArgumentException
     * @param \StructType\RegistrationCard[] $registrationCard
     * @return \StructType\Person
     */
    public function setRegistrationCard(array $registrationCard = array())
    {
        // validation for constraint: array
        if ('' !== ($registrationCardArrayErrorMessage = self::validateRegistrationCardForArrayConstraintsFromSetRegistrationCard($registrationCard))) {
            throw new \InvalidArgumentException($registrationCardArrayErrorMessage, __LINE__);
        }
        $this->RegistrationCard = $registrationCard;
        return $this;
    }
    /**
     * Add item to RegistrationCard value
     * @throws \InvalidArgumentException
     * @param \StructType\RegistrationCard $item
     * @return \StructType\Person
     */
    public function addToRegistrationCard(\StructType\RegistrationCard $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RegistrationCard) {
            throw new \InvalidArgumentException(sprintf('The RegistrationCard property can only contain items of type \StructType\RegistrationCard, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RegistrationCard[] = $item;
        return $this;
    }
    /**
     * Get ratesegment value
     * @return string|null
     */
    public function getRatesegment()
    {
        return $this->ratesegment;
    }
    /**
     * Set ratesegment value
     * @param string $ratesegment
     * @return \StructType\Person
     */
    public function setRatesegment($ratesegment = null)
    {
        // validation for constraint: string
        if (!is_null($ratesegment) && !is_string($ratesegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratesegment, true), gettype($ratesegment)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($ratesegment) && mb_strlen($ratesegment) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($ratesegment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ratesegment) && mb_strlen($ratesegment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ratesegment)), __LINE__);
        }
        $this->ratesegment = $ratesegment;
        return $this;
    }
}
