<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payments StructType
 * @subpackage Structs
 */
class Payments extends AbstractStructBase
{
    /**
     * The Payment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Payment[]
     */
    public $Payment;
    /**
     * Constructor method for Payments
     * @uses Payments::setPayment()
     * @param \StructType\Payment[] $payment
     */
    public function __construct(array $payment = array())
    {
        $this
            ->setPayment($payment);
    }
    /**
     * Get Payment value
     * @return \StructType\Payment[]|null
     */
    public function getPayment()
    {
        return $this->Payment;
    }
    /**
     * This method is responsible for validating the values passed to the setPayment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentForArrayConstraintsFromSetPayment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentsPaymentItem) {
            // validation for constraint: itemType
            if (!$paymentsPaymentItem instanceof \StructType\Payment) {
                $invalidValues[] = is_object($paymentsPaymentItem) ? get_class($paymentsPaymentItem) : sprintf('%s(%s)', gettype($paymentsPaymentItem), var_export($paymentsPaymentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Payment property can only contain items of type \StructType\Payment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Payment value
     * @throws \InvalidArgumentException
     * @param \StructType\Payment[] $payment
     * @return \StructType\Payments
     */
    public function setPayment(array $payment = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentArrayErrorMessage = self::validatePaymentForArrayConstraintsFromSetPayment($payment))) {
            throw new \InvalidArgumentException($paymentArrayErrorMessage, __LINE__);
        }
        $this->Payment = $payment;
        return $this;
    }
    /**
     * Add item to Payment value
     * @throws \InvalidArgumentException
     * @param \StructType\Payment $item
     * @return \StructType\Payments
     */
    public function addToPayment(\StructType\Payment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Payment) {
            throw new \InvalidArgumentException(sprintf('The Payment property can only contain items of type \StructType\Payment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Payment[] = $item;
        return $this;
    }
}
