<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Package StructType
 * @subpackage Structs
 */
class Package extends AbstractStructBase
{
    /**
     * The servicecode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $servicecode;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $comment;
    /**
     * The descriptionDefault
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $descriptionDefault;
    /**
     * The commentDefault
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $commentDefault;
    /**
     * The processing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $processing;
    /**
     * The company
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $company;
    /**
     * The allotment_owner
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $allotment_owner;
    /**
     * The allotmentname
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $allotmentname;
    /**
     * The allotment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $allotment;
    /**
     * The packagetypestandard
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $packagetypestandard;
    /**
     * The packagetyperoomrate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $packagetyperoomrate;
    /**
     * The packagetypepackage
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $packagetypepackage;
    /**
     * The packagetypeflexrate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $packagetypeflexrate;
    /**
     * The packagetypedefbylos
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $packagetypedefbylos;
    /**
     * The Images
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Images[]
     */
    public $Images;
    /**
     * The MultiLanguageDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MultiLanguageDescription[]
     */
    public $MultiLanguageDescription;
    /**
     * Constructor method for Package
     * @uses Package::setServicecode()
     * @uses Package::setDescription()
     * @uses Package::setComment()
     * @uses Package::setDescriptionDefault()
     * @uses Package::setCommentDefault()
     * @uses Package::setProcessing()
     * @uses Package::setCompany()
     * @uses Package::setAllotment_owner()
     * @uses Package::setAllotmentname()
     * @uses Package::setAllotment()
     * @uses Package::setPackagetypestandard()
     * @uses Package::setPackagetyperoomrate()
     * @uses Package::setPackagetypepackage()
     * @uses Package::setPackagetypeflexrate()
     * @uses Package::setPackagetypedefbylos()
     * @uses Package::setImages()
     * @uses Package::setMultiLanguageDescription()
     * @param string $servicecode
     * @param string $description
     * @param string $comment
     * @param string $descriptionDefault
     * @param string $commentDefault
     * @param string $processing
     * @param string $company
     * @param string $allotment_owner
     * @param string $allotmentname
     * @param string $allotment
     * @param string $packagetypestandard
     * @param string $packagetyperoomrate
     * @param string $packagetypepackage
     * @param string $packagetypeflexrate
     * @param string $packagetypedefbylos
     * @param \StructType\Images[] $images
     * @param \StructType\MultiLanguageDescription[] $multiLanguageDescription
     */
    public function __construct($servicecode = null, $description = null, $comment = null, $descriptionDefault = null, $commentDefault = null, $processing = null, $company = null, $allotment_owner = null, $allotmentname = null, $allotment = null, $packagetypestandard = null, $packagetyperoomrate = null, $packagetypepackage = null, $packagetypeflexrate = null, $packagetypedefbylos = null, array $images = array(), array $multiLanguageDescription = array())
    {
        $this
            ->setServicecode($servicecode)
            ->setDescription($description)
            ->setComment($comment)
            ->setDescriptionDefault($descriptionDefault)
            ->setCommentDefault($commentDefault)
            ->setProcessing($processing)
            ->setCompany($company)
            ->setAllotment_owner($allotment_owner)
            ->setAllotmentname($allotmentname)
            ->setAllotment($allotment)
            ->setPackagetypestandard($packagetypestandard)
            ->setPackagetyperoomrate($packagetyperoomrate)
            ->setPackagetypepackage($packagetypepackage)
            ->setPackagetypeflexrate($packagetypeflexrate)
            ->setPackagetypedefbylos($packagetypedefbylos)
            ->setImages($images)
            ->setMultiLanguageDescription($multiLanguageDescription);
    }
    /**
     * Get servicecode value
     * @return string
     */
    public function getServicecode()
    {
        return $this->servicecode;
    }
    /**
     * Set servicecode value
     * @param string $servicecode
     * @return \StructType\Package
     */
    public function setServicecode($servicecode = null)
    {
        // validation for constraint: string
        if (!is_null($servicecode) && !is_string($servicecode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicecode, true), gettype($servicecode)), __LINE__);
        }
        $this->servicecode = $servicecode;
        return $this;
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Package
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get comment value
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\Package
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get descriptionDefault value
     * @return string
     */
    public function getDescriptionDefault()
    {
        return $this->descriptionDefault;
    }
    /**
     * Set descriptionDefault value
     * @param string $descriptionDefault
     * @return \StructType\Package
     */
    public function setDescriptionDefault($descriptionDefault = null)
    {
        // validation for constraint: string
        if (!is_null($descriptionDefault) && !is_string($descriptionDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptionDefault, true), gettype($descriptionDefault)), __LINE__);
        }
        $this->descriptionDefault = $descriptionDefault;
        return $this;
    }
    /**
     * Get commentDefault value
     * @return string
     */
    public function getCommentDefault()
    {
        return $this->commentDefault;
    }
    /**
     * Set commentDefault value
     * @param string $commentDefault
     * @return \StructType\Package
     */
    public function setCommentDefault($commentDefault = null)
    {
        // validation for constraint: string
        if (!is_null($commentDefault) && !is_string($commentDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commentDefault, true), gettype($commentDefault)), __LINE__);
        }
        $this->commentDefault = $commentDefault;
        return $this;
    }
    /**
     * Get processing value
     * @return string
     */
    public function getProcessing()
    {
        return $this->processing;
    }
    /**
     * Set processing value
     * @param string $processing
     * @return \StructType\Package
     */
    public function setProcessing($processing = null)
    {
        // validation for constraint: string
        if (!is_null($processing) && !is_string($processing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processing, true), gettype($processing)), __LINE__);
        }
        $this->processing = $processing;
        return $this;
    }
    /**
     * Get company value
     * @return string
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * Set company value
     * @param string $company
     * @return \StructType\Package
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        $this->company = $company;
        return $this;
    }
    /**
     * Get allotment_owner value
     * @return string
     */
    public function getAllotment_owner()
    {
        return $this->{'allotment-owner'};
    }
    /**
     * Set allotment_owner value
     * @param string $allotment_owner
     * @return \StructType\Package
     */
    public function setAllotment_owner($allotment_owner = null)
    {
        // validation for constraint: string
        if (!is_null($allotment_owner) && !is_string($allotment_owner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allotment_owner, true), gettype($allotment_owner)), __LINE__);
        }
        $this->allotment_owner = $this->{'allotment-owner'} = $allotment_owner;
        return $this;
    }
    /**
     * Get allotmentname value
     * @return string
     */
    public function getAllotmentname()
    {
        return $this->allotmentname;
    }
    /**
     * Set allotmentname value
     * @param string $allotmentname
     * @return \StructType\Package
     */
    public function setAllotmentname($allotmentname = null)
    {
        // validation for constraint: string
        if (!is_null($allotmentname) && !is_string($allotmentname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allotmentname, true), gettype($allotmentname)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($allotmentname) && mb_strlen($allotmentname) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($allotmentname)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($allotmentname) && mb_strlen($allotmentname) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($allotmentname)), __LINE__);
        }
        $this->allotmentname = $allotmentname;
        return $this;
    }
    /**
     * Get allotment value
     * @return string
     */
    public function getAllotment()
    {
        return $this->allotment;
    }
    /**
     * Set allotment value
     * @param string $allotment
     * @return \StructType\Package
     */
    public function setAllotment($allotment = null)
    {
        // validation for constraint: string
        if (!is_null($allotment) && !is_string($allotment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allotment, true), gettype($allotment)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($allotment) && !preg_match('/([-+]){0,1}([0-9])*/', $allotment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($allotment, true)), __LINE__);
        }
        $this->allotment = $allotment;
        return $this;
    }
    /**
     * Get packagetypestandard value
     * @return string
     */
    public function getPackagetypestandard()
    {
        return $this->packagetypestandard;
    }
    /**
     * Set packagetypestandard value
     * @param string $packagetypestandard
     * @return \StructType\Package
     */
    public function setPackagetypestandard($packagetypestandard = null)
    {
        // validation for constraint: string
        if (!is_null($packagetypestandard) && !is_string($packagetypestandard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packagetypestandard, true), gettype($packagetypestandard)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($packagetypestandard) && !preg_match('/([-+]){0,1}([0-9])*/', $packagetypestandard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($packagetypestandard, true)), __LINE__);
        }
        $this->packagetypestandard = $packagetypestandard;
        return $this;
    }
    /**
     * Get packagetyperoomrate value
     * @return string
     */
    public function getPackagetyperoomrate()
    {
        return $this->packagetyperoomrate;
    }
    /**
     * Set packagetyperoomrate value
     * @param string $packagetyperoomrate
     * @return \StructType\Package
     */
    public function setPackagetyperoomrate($packagetyperoomrate = null)
    {
        // validation for constraint: string
        if (!is_null($packagetyperoomrate) && !is_string($packagetyperoomrate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packagetyperoomrate, true), gettype($packagetyperoomrate)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($packagetyperoomrate) && !preg_match('/([-+]){0,1}([0-9])*/', $packagetyperoomrate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($packagetyperoomrate, true)), __LINE__);
        }
        $this->packagetyperoomrate = $packagetyperoomrate;
        return $this;
    }
    /**
     * Get packagetypepackage value
     * @return string
     */
    public function getPackagetypepackage()
    {
        return $this->packagetypepackage;
    }
    /**
     * Set packagetypepackage value
     * @param string $packagetypepackage
     * @return \StructType\Package
     */
    public function setPackagetypepackage($packagetypepackage = null)
    {
        // validation for constraint: string
        if (!is_null($packagetypepackage) && !is_string($packagetypepackage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packagetypepackage, true), gettype($packagetypepackage)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($packagetypepackage) && !preg_match('/([-+]){0,1}([0-9])*/', $packagetypepackage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($packagetypepackage, true)), __LINE__);
        }
        $this->packagetypepackage = $packagetypepackage;
        return $this;
    }
    /**
     * Get packagetypeflexrate value
     * @return string
     */
    public function getPackagetypeflexrate()
    {
        return $this->packagetypeflexrate;
    }
    /**
     * Set packagetypeflexrate value
     * @param string $packagetypeflexrate
     * @return \StructType\Package
     */
    public function setPackagetypeflexrate($packagetypeflexrate = null)
    {
        // validation for constraint: string
        if (!is_null($packagetypeflexrate) && !is_string($packagetypeflexrate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packagetypeflexrate, true), gettype($packagetypeflexrate)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($packagetypeflexrate) && !preg_match('/([-+]){0,1}([0-9])*/', $packagetypeflexrate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($packagetypeflexrate, true)), __LINE__);
        }
        $this->packagetypeflexrate = $packagetypeflexrate;
        return $this;
    }
    /**
     * Get packagetypedefbylos value
     * @return string
     */
    public function getPackagetypedefbylos()
    {
        return $this->packagetypedefbylos;
    }
    /**
     * Set packagetypedefbylos value
     * @param string $packagetypedefbylos
     * @return \StructType\Package
     */
    public function setPackagetypedefbylos($packagetypedefbylos = null)
    {
        // validation for constraint: string
        if (!is_null($packagetypedefbylos) && !is_string($packagetypedefbylos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packagetypedefbylos, true), gettype($packagetypedefbylos)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($packagetypedefbylos) && !preg_match('/([-+]){0,1}([0-9])*/', $packagetypedefbylos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($packagetypedefbylos, true)), __LINE__);
        }
        $this->packagetypedefbylos = $packagetypedefbylos;
        return $this;
    }
    /**
     * Get Images value
     * @return \StructType\Images[]|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * This method is responsible for validating the values passed to the setImages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImagesForArrayConstraintsFromSetImages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageImagesItem) {
            // validation for constraint: itemType
            if (!$packageImagesItem instanceof \StructType\Images) {
                $invalidValues[] = is_object($packageImagesItem) ? get_class($packageImagesItem) : sprintf('%s(%s)', gettype($packageImagesItem), var_export($packageImagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Images property can only contain items of type \StructType\Images, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Images value
     * @throws \InvalidArgumentException
     * @param \StructType\Images[] $images
     * @return \StructType\Package
     */
    public function setImages(array $images = array())
    {
        // validation for constraint: array
        if ('' !== ($imagesArrayErrorMessage = self::validateImagesForArrayConstraintsFromSetImages($images))) {
            throw new \InvalidArgumentException($imagesArrayErrorMessage, __LINE__);
        }
        $this->Images = $images;
        return $this;
    }
    /**
     * Add item to Images value
     * @throws \InvalidArgumentException
     * @param \StructType\Images $item
     * @return \StructType\Package
     */
    public function addToImages(\StructType\Images $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Images) {
            throw new \InvalidArgumentException(sprintf('The Images property can only contain items of type \StructType\Images, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Images[] = $item;
        return $this;
    }
    /**
     * Get MultiLanguageDescription value
     * @return \StructType\MultiLanguageDescription[]|null
     */
    public function getMultiLanguageDescription()
    {
        return $this->MultiLanguageDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setMultiLanguageDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMultiLanguageDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMultiLanguageDescriptionForArrayConstraintsFromSetMultiLanguageDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageMultiLanguageDescriptionItem) {
            // validation for constraint: itemType
            if (!$packageMultiLanguageDescriptionItem instanceof \StructType\MultiLanguageDescription) {
                $invalidValues[] = is_object($packageMultiLanguageDescriptionItem) ? get_class($packageMultiLanguageDescriptionItem) : sprintf('%s(%s)', gettype($packageMultiLanguageDescriptionItem), var_export($packageMultiLanguageDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MultiLanguageDescription property can only contain items of type \StructType\MultiLanguageDescription, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MultiLanguageDescription value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLanguageDescription[] $multiLanguageDescription
     * @return \StructType\Package
     */
    public function setMultiLanguageDescription(array $multiLanguageDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($multiLanguageDescriptionArrayErrorMessage = self::validateMultiLanguageDescriptionForArrayConstraintsFromSetMultiLanguageDescription($multiLanguageDescription))) {
            throw new \InvalidArgumentException($multiLanguageDescriptionArrayErrorMessage, __LINE__);
        }
        $this->MultiLanguageDescription = $multiLanguageDescription;
        return $this;
    }
    /**
     * Add item to MultiLanguageDescription value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLanguageDescription $item
     * @return \StructType\Package
     */
    public function addToMultiLanguageDescription(\StructType\MultiLanguageDescription $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MultiLanguageDescription) {
            throw new \InvalidArgumentException(sprintf('The MultiLanguageDescription property can only contain items of type \StructType\MultiLanguageDescription, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MultiLanguageDescription[] = $item;
        return $this;
    }
}
