<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PRODUCT-FEATURES StructType
 * @subpackage Structs
 */
class PRODUCT_FEATURES extends AbstractStructBase
{
    /**
     * The product
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $product;
    /**
     * The FEATURES
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\FEATURES
     */
    public $FEATURES;
    /**
     * Constructor method for PRODUCT-FEATURES
     * @uses PRODUCT_FEATURES::setProduct()
     * @uses PRODUCT_FEATURES::setFEATURES()
     * @param string $product
     * @param \StructType\FEATURES $fEATURES
     */
    public function __construct($product = null, \StructType\FEATURES $fEATURES = null)
    {
        $this
            ->setProduct($product)
            ->setFEATURES($fEATURES);
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \StructType\PRODUCT_FEATURES
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product, true), gettype($product)), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get FEATURES value
     * @return \StructType\FEATURES
     */
    public function getFEATURES()
    {
        return $this->FEATURES;
    }
    /**
     * Set FEATURES value
     * @param \StructType\FEATURES $fEATURES
     * @return \StructType\PRODUCT_FEATURES
     */
    public function setFEATURES(\StructType\FEATURES $fEATURES = null)
    {
        $this->FEATURES = $fEATURES;
        return $this;
    }
}
