<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PMSAccountMain StructType
 * @subpackage Structs
 */
class PMSAccountMain extends AbstractStructBase
{
    /**
     * The ACCOUNT_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ACCOUNT_OBJID;
    /**
     * The accounttype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $accounttype;
    /**
     * Constructor method for PMSAccountMain
     * @uses PMSAccountMain::setACCOUNT_OBJID()
     * @uses PMSAccountMain::setAccounttype()
     * @param string $aCCOUNT_OBJID
     * @param string $accounttype
     */
    public function __construct($aCCOUNT_OBJID = null, $accounttype = null)
    {
        $this
            ->setACCOUNT_OBJID($aCCOUNT_OBJID)
            ->setAccounttype($accounttype);
    }
    /**
     * Get ACCOUNT_OBJID value
     * @return string
     */
    public function getACCOUNT_OBJID()
    {
        return $this->{'ACCOUNT-OBJID'};
    }
    /**
     * Set ACCOUNT_OBJID value
     * @param string $aCCOUNT_OBJID
     * @return \StructType\PMSAccountMain
     */
    public function setACCOUNT_OBJID($aCCOUNT_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($aCCOUNT_OBJID) && !is_string($aCCOUNT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aCCOUNT_OBJID, true), gettype($aCCOUNT_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($aCCOUNT_OBJID) && !preg_match('/([0-9])*/', $aCCOUNT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($aCCOUNT_OBJID, true)), __LINE__);
        }
        $this->ACCOUNT_OBJID = $this->{'ACCOUNT-OBJID'} = $aCCOUNT_OBJID;
        return $this;
    }
    /**
     * Get accounttype value
     * @return string
     */
    public function getAccounttype()
    {
        return $this->accounttype;
    }
    /**
     * Set accounttype value
     * @param string $accounttype
     * @return \StructType\PMSAccountMain
     */
    public function setAccounttype($accounttype = null)
    {
        // validation for constraint: string
        if (!is_null($accounttype) && !is_string($accounttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accounttype, true), gettype($accounttype)), __LINE__);
        }
        $this->accounttype = $accounttype;
        return $this;
    }
}
