<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PMSAccount StructType
 * @subpackage Structs
 */
class PMSAccount extends AbstractStructBase
{
    /**
     * The ACCOUNT_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ACCOUNT_OBJID;
    /**
     * The accounttype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $accounttype;
    /**
     * The PostFOService
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PostFOService
     */
    public $PostFOService;
    /**
     * The FOServicePosting
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\FOServicePosting
     */
    public $FOServicePosting;
    /**
     * The PostFOPayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PostFOPayment
     */
    public $PostFOPayment;
    /**
     * Constructor method for PMSAccount
     * @uses PMSAccount::setACCOUNT_OBJID()
     * @uses PMSAccount::setAccounttype()
     * @uses PMSAccount::setPostFOService()
     * @uses PMSAccount::setFOServicePosting()
     * @uses PMSAccount::setPostFOPayment()
     * @param string $aCCOUNT_OBJID
     * @param string $accounttype
     * @param \StructType\PostFOService $postFOService
     * @param \StructType\FOServicePosting $fOServicePosting
     * @param \StructType\PostFOPayment $postFOPayment
     */
    public function __construct($aCCOUNT_OBJID = null, $accounttype = null, \StructType\PostFOService $postFOService = null, \StructType\FOServicePosting $fOServicePosting = null, \StructType\PostFOPayment $postFOPayment = null)
    {
        $this
            ->setACCOUNT_OBJID($aCCOUNT_OBJID)
            ->setAccounttype($accounttype)
            ->setPostFOService($postFOService)
            ->setFOServicePosting($fOServicePosting)
            ->setPostFOPayment($postFOPayment);
    }
    /**
     * Get ACCOUNT_OBJID value
     * @return string
     */
    public function getACCOUNT_OBJID()
    {
        return $this->{'ACCOUNT-OBJID'};
    }
    /**
     * Set ACCOUNT_OBJID value
     * @param string $aCCOUNT_OBJID
     * @return \StructType\PMSAccount
     */
    public function setACCOUNT_OBJID($aCCOUNT_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($aCCOUNT_OBJID) && !is_string($aCCOUNT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aCCOUNT_OBJID, true), gettype($aCCOUNT_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($aCCOUNT_OBJID) && !preg_match('/([0-9])*/', $aCCOUNT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($aCCOUNT_OBJID, true)), __LINE__);
        }
        $this->ACCOUNT_OBJID = $this->{'ACCOUNT-OBJID'} = $aCCOUNT_OBJID;
        return $this;
    }
    /**
     * Get accounttype value
     * @return string
     */
    public function getAccounttype()
    {
        return $this->accounttype;
    }
    /**
     * Set accounttype value
     * @param string $accounttype
     * @return \StructType\PMSAccount
     */
    public function setAccounttype($accounttype = null)
    {
        // validation for constraint: string
        if (!is_null($accounttype) && !is_string($accounttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accounttype, true), gettype($accounttype)), __LINE__);
        }
        $this->accounttype = $accounttype;
        return $this;
    }
    /**
     * Get PostFOService value
     * @return \StructType\PostFOService
     */
    public function getPostFOService()
    {
        return $this->PostFOService;
    }
    /**
     * Set PostFOService value
     * @param \StructType\PostFOService $postFOService
     * @return \StructType\PMSAccount
     */
    public function setPostFOService(\StructType\PostFOService $postFOService = null)
    {
        $this->PostFOService = $postFOService;
        return $this;
    }
    /**
     * Get FOServicePosting value
     * @return \StructType\FOServicePosting
     */
    public function getFOServicePosting()
    {
        return $this->FOServicePosting;
    }
    /**
     * Set FOServicePosting value
     * @param \StructType\FOServicePosting $fOServicePosting
     * @return \StructType\PMSAccount
     */
    public function setFOServicePosting(\StructType\FOServicePosting $fOServicePosting = null)
    {
        $this->FOServicePosting = $fOServicePosting;
        return $this;
    }
    /**
     * Get PostFOPayment value
     * @return \StructType\PostFOPayment
     */
    public function getPostFOPayment()
    {
        return $this->PostFOPayment;
    }
    /**
     * Set PostFOPayment value
     * @param \StructType\PostFOPayment $postFOPayment
     * @return \StructType\PMSAccount
     */
    public function setPostFOPayment(\StructType\PostFOPayment $postFOPayment = null)
    {
        $this->PostFOPayment = $postFOPayment;
        return $this;
    }
}
