<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PAYMENT StructType
 * @subpackage Structs
 */
class PAYMENT_1 extends AbstractStructBase
{
    /**
     * The typeofpayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $typeofpayment;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amount;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * The PAYMENT_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $PAYMENT_OBJID;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The currencyamount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $currencyamount;
    /**
     * The currencyexchangefactor
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $currencyexchangefactor;
    /**
     * The descriptionlst
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $descriptionlst;
    /**
     * The billno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $billno;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * Constructor method for PAYMENT
     * @uses PAYMENT_1::setTypeofpayment()
     * @uses PAYMENT_1::setAmount()
     * @uses PAYMENT_1::setCurrency()
     * @uses PAYMENT_1::setPAYMENT_OBJID()
     * @uses PAYMENT_1::setDescription()
     * @uses PAYMENT_1::setCurrencyamount()
     * @uses PAYMENT_1::setCurrencyexchangefactor()
     * @uses PAYMENT_1::setDescriptionlst()
     * @uses PAYMENT_1::setBillno()
     * @uses PAYMENT_1::setComment()
     * @param string $typeofpayment
     * @param string $amount
     * @param string $currency
     * @param string $pAYMENT_OBJID
     * @param string $description
     * @param string $currencyamount
     * @param string $currencyexchangefactor
     * @param string $descriptionlst
     * @param string $billno
     * @param string $comment
     */
    public function __construct($typeofpayment = null, $amount = null, $currency = null, $pAYMENT_OBJID = null, $description = null, $currencyamount = null, $currencyexchangefactor = null, $descriptionlst = null, $billno = null, $comment = null)
    {
        $this
            ->setTypeofpayment($typeofpayment)
            ->setAmount($amount)
            ->setCurrency($currency)
            ->setPAYMENT_OBJID($pAYMENT_OBJID)
            ->setDescription($description)
            ->setCurrencyamount($currencyamount)
            ->setCurrencyexchangefactor($currencyexchangefactor)
            ->setDescriptionlst($descriptionlst)
            ->setBillno($billno)
            ->setComment($comment);
    }
    /**
     * Get typeofpayment value
     * @return string
     */
    public function getTypeofpayment()
    {
        return $this->typeofpayment;
    }
    /**
     * Set typeofpayment value
     * @param string $typeofpayment
     * @return \StructType\PAYMENT_1
     */
    public function setTypeofpayment($typeofpayment = null)
    {
        // validation for constraint: string
        if (!is_null($typeofpayment) && !is_string($typeofpayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeofpayment, true), gettype($typeofpayment)), __LINE__);
        }
        $this->typeofpayment = $typeofpayment;
        return $this;
    }
    /**
     * Get amount value
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param string $amount
     * @return \StructType\PAYMENT_1
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amount, true)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\PAYMENT_1
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get PAYMENT_OBJID value
     * @return string
     */
    public function getPAYMENT_OBJID()
    {
        return $this->{'PAYMENT-OBJID'};
    }
    /**
     * Set PAYMENT_OBJID value
     * @param string $pAYMENT_OBJID
     * @return \StructType\PAYMENT_1
     */
    public function setPAYMENT_OBJID($pAYMENT_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($pAYMENT_OBJID) && !is_string($pAYMENT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pAYMENT_OBJID, true), gettype($pAYMENT_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($pAYMENT_OBJID) && !preg_match('/([0-9])*/', $pAYMENT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($pAYMENT_OBJID, true)), __LINE__);
        }
        $this->PAYMENT_OBJID = $this->{'PAYMENT-OBJID'} = $pAYMENT_OBJID;
        return $this;
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\PAYMENT_1
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get currencyamount value
     * @return string
     */
    public function getCurrencyamount()
    {
        return $this->currencyamount;
    }
    /**
     * Set currencyamount value
     * @param string $currencyamount
     * @return \StructType\PAYMENT_1
     */
    public function setCurrencyamount($currencyamount = null)
    {
        // validation for constraint: string
        if (!is_null($currencyamount) && !is_string($currencyamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyamount, true), gettype($currencyamount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($currencyamount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $currencyamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($currencyamount, true)), __LINE__);
        }
        $this->currencyamount = $currencyamount;
        return $this;
    }
    /**
     * Get currencyexchangefactor value
     * @return string
     */
    public function getCurrencyexchangefactor()
    {
        return $this->currencyexchangefactor;
    }
    /**
     * Set currencyexchangefactor value
     * @param string $currencyexchangefactor
     * @return \StructType\PAYMENT_1
     */
    public function setCurrencyexchangefactor($currencyexchangefactor = null)
    {
        // validation for constraint: string
        if (!is_null($currencyexchangefactor) && !is_string($currencyexchangefactor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyexchangefactor, true), gettype($currencyexchangefactor)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($currencyexchangefactor) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $currencyexchangefactor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($currencyexchangefactor, true)), __LINE__);
        }
        $this->currencyexchangefactor = $currencyexchangefactor;
        return $this;
    }
    /**
     * Get descriptionlst value
     * @return string|null
     */
    public function getDescriptionlst()
    {
        return $this->descriptionlst;
    }
    /**
     * Set descriptionlst value
     * @param string $descriptionlst
     * @return \StructType\PAYMENT_1
     */
    public function setDescriptionlst($descriptionlst = null)
    {
        // validation for constraint: string
        if (!is_null($descriptionlst) && !is_string($descriptionlst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptionlst, true), gettype($descriptionlst)), __LINE__);
        }
        $this->descriptionlst = $descriptionlst;
        return $this;
    }
    /**
     * Get billno value
     * @return string|null
     */
    public function getBillno()
    {
        return $this->billno;
    }
    /**
     * Set billno value
     * @param string $billno
     * @return \StructType\PAYMENT_1
     */
    public function setBillno($billno = null)
    {
        // validation for constraint: string
        if (!is_null($billno) && !is_string($billno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billno, true), gettype($billno)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($billno) && !preg_match('/([0-9])*/', $billno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($billno, true)), __LINE__);
        }
        $this->billno = $billno;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\PAYMENT_1
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
}
