<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Orderer StructType
 * @subpackage Structs
 */
class Orderer_1 extends AbstractStructBase
{
    /**
     * The ORDERER_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ORDERER_OBJID;
    /**
     * The name1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name1;
    /**
     * The name2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $name2;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $country;
    /**
     * The subcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $subcountry;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $postcode;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $city;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $street;
    /**
     * The hqmatchadm
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $hqmatchadm;
    /**
     * The hqmatchisn
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $hqmatchisn;
    /**
     * The hqmatchsm
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $hqmatchsm;
    /**
     * The matchcode
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $matchcode;
    /**
     * The iata
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $iata;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $phone;
    /**
     * The email1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $email1;
    /**
     * The mobile1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $mobile1;
    /**
     * Constructor method for Orderer
     * @uses Orderer_1::setORDERER_OBJID()
     * @uses Orderer_1::setName1()
     * @uses Orderer_1::setName2()
     * @uses Orderer_1::setCountry()
     * @uses Orderer_1::setSubcountry()
     * @uses Orderer_1::setPostcode()
     * @uses Orderer_1::setCity()
     * @uses Orderer_1::setStreet()
     * @uses Orderer_1::setHqmatchadm()
     * @uses Orderer_1::setHqmatchisn()
     * @uses Orderer_1::setHqmatchsm()
     * @uses Orderer_1::setMatchcode()
     * @uses Orderer_1::setIata()
     * @uses Orderer_1::setPhone()
     * @uses Orderer_1::setEmail1()
     * @uses Orderer_1::setMobile1()
     * @param string $oRDERER_OBJID
     * @param string $name1
     * @param string $name2
     * @param string $country
     * @param string $subcountry
     * @param string $postcode
     * @param string $city
     * @param string $street
     * @param string $hqmatchadm
     * @param string $hqmatchisn
     * @param string $hqmatchsm
     * @param string $matchcode
     * @param string $iata
     * @param string $phone
     * @param string $email1
     * @param string $mobile1
     */
    public function __construct($oRDERER_OBJID = null, $name1 = null, $name2 = null, $country = null, $subcountry = null, $postcode = null, $city = null, $street = null, $hqmatchadm = null, $hqmatchisn = null, $hqmatchsm = null, $matchcode = null, $iata = null, $phone = null, $email1 = null, $mobile1 = null)
    {
        $this
            ->setORDERER_OBJID($oRDERER_OBJID)
            ->setName1($name1)
            ->setName2($name2)
            ->setCountry($country)
            ->setSubcountry($subcountry)
            ->setPostcode($postcode)
            ->setCity($city)
            ->setStreet($street)
            ->setHqmatchadm($hqmatchadm)
            ->setHqmatchisn($hqmatchisn)
            ->setHqmatchsm($hqmatchsm)
            ->setMatchcode($matchcode)
            ->setIata($iata)
            ->setPhone($phone)
            ->setEmail1($email1)
            ->setMobile1($mobile1);
    }
    /**
     * Get ORDERER_OBJID value
     * @return string
     */
    public function getORDERER_OBJID()
    {
        return $this->{'ORDERER-OBJID'};
    }
    /**
     * Set ORDERER_OBJID value
     * @param string $oRDERER_OBJID
     * @return \StructType\Orderer_1
     */
    public function setORDERER_OBJID($oRDERER_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($oRDERER_OBJID) && !is_string($oRDERER_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oRDERER_OBJID, true), gettype($oRDERER_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($oRDERER_OBJID) && !preg_match('/([0-9])*/', $oRDERER_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($oRDERER_OBJID, true)), __LINE__);
        }
        $this->ORDERER_OBJID = $this->{'ORDERER-OBJID'} = $oRDERER_OBJID;
        return $this;
    }
    /**
     * Get name1 value
     * @return string
     */
    public function getName1()
    {
        return $this->name1;
    }
    /**
     * Set name1 value
     * @param string $name1
     * @return \StructType\Orderer_1
     */
    public function setName1($name1 = null)
    {
        // validation for constraint: string
        if (!is_null($name1) && !is_string($name1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name1, true), gettype($name1)), __LINE__);
        }
        $this->name1 = $name1;
        return $this;
    }
    /**
     * Get name2 value
     * @return string
     */
    public function getName2()
    {
        return $this->name2;
    }
    /**
     * Set name2 value
     * @param string $name2
     * @return \StructType\Orderer_1
     */
    public function setName2($name2 = null)
    {
        // validation for constraint: string
        if (!is_null($name2) && !is_string($name2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name2, true), gettype($name2)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($name2) && mb_strlen($name2) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($name2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($name2) && mb_strlen($name2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($name2)), __LINE__);
        }
        $this->name2 = $name2;
        return $this;
    }
    /**
     * Get country value
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\Orderer_1
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get subcountry value
     * @return string
     */
    public function getSubcountry()
    {
        return $this->subcountry;
    }
    /**
     * Set subcountry value
     * @param string $subcountry
     * @return \StructType\Orderer_1
     */
    public function setSubcountry($subcountry = null)
    {
        // validation for constraint: string
        if (!is_null($subcountry) && !is_string($subcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subcountry, true), gettype($subcountry)), __LINE__);
        }
        $this->subcountry = $subcountry;
        return $this;
    }
    /**
     * Get postcode value
     * @return string
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\Orderer_1
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($postcode) && mb_strlen($postcode) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($postcode)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($postcode) && mb_strlen($postcode) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get city value
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\Orderer_1
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city) && mb_strlen($city) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($city) && mb_strlen($city) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get street value
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\Orderer_1
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($street) && mb_strlen($street) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($street)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($street) && mb_strlen($street) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get hqmatchadm value
     * @return string
     */
    public function getHqmatchadm()
    {
        return $this->hqmatchadm;
    }
    /**
     * Set hqmatchadm value
     * @param string $hqmatchadm
     * @return \StructType\Orderer_1
     */
    public function setHqmatchadm($hqmatchadm = null)
    {
        // validation for constraint: string
        if (!is_null($hqmatchadm) && !is_string($hqmatchadm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hqmatchadm, true), gettype($hqmatchadm)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($hqmatchadm) && mb_strlen($hqmatchadm) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($hqmatchadm)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($hqmatchadm) && mb_strlen($hqmatchadm) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($hqmatchadm)), __LINE__);
        }
        $this->hqmatchadm = $hqmatchadm;
        return $this;
    }
    /**
     * Get hqmatchisn value
     * @return string
     */
    public function getHqmatchisn()
    {
        return $this->hqmatchisn;
    }
    /**
     * Set hqmatchisn value
     * @param string $hqmatchisn
     * @return \StructType\Orderer_1
     */
    public function setHqmatchisn($hqmatchisn = null)
    {
        // validation for constraint: string
        if (!is_null($hqmatchisn) && !is_string($hqmatchisn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hqmatchisn, true), gettype($hqmatchisn)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($hqmatchisn) && mb_strlen($hqmatchisn) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($hqmatchisn)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($hqmatchisn) && mb_strlen($hqmatchisn) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($hqmatchisn)), __LINE__);
        }
        $this->hqmatchisn = $hqmatchisn;
        return $this;
    }
    /**
     * Get hqmatchsm value
     * @return string
     */
    public function getHqmatchsm()
    {
        return $this->hqmatchsm;
    }
    /**
     * Set hqmatchsm value
     * @param string $hqmatchsm
     * @return \StructType\Orderer_1
     */
    public function setHqmatchsm($hqmatchsm = null)
    {
        // validation for constraint: string
        if (!is_null($hqmatchsm) && !is_string($hqmatchsm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hqmatchsm, true), gettype($hqmatchsm)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($hqmatchsm) && mb_strlen($hqmatchsm) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($hqmatchsm)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($hqmatchsm) && mb_strlen($hqmatchsm) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($hqmatchsm)), __LINE__);
        }
        $this->hqmatchsm = $hqmatchsm;
        return $this;
    }
    /**
     * Get matchcode value
     * @return string
     */
    public function getMatchcode()
    {
        return $this->matchcode;
    }
    /**
     * Set matchcode value
     * @param string $matchcode
     * @return \StructType\Orderer_1
     */
    public function setMatchcode($matchcode = null)
    {
        // validation for constraint: string
        if (!is_null($matchcode) && !is_string($matchcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matchcode, true), gettype($matchcode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($matchcode) && mb_strlen($matchcode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($matchcode)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($matchcode) && mb_strlen($matchcode) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($matchcode)), __LINE__);
        }
        $this->matchcode = $matchcode;
        return $this;
    }
    /**
     * Get iata value
     * @return string
     */
    public function getIata()
    {
        return $this->iata;
    }
    /**
     * Set iata value
     * @param string $iata
     * @return \StructType\Orderer_1
     */
    public function setIata($iata = null)
    {
        // validation for constraint: string
        if (!is_null($iata) && !is_string($iata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iata, true), gettype($iata)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($iata) && mb_strlen($iata) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($iata)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($iata) && mb_strlen($iata) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($iata)), __LINE__);
        }
        $this->iata = $iata;
        return $this;
    }
    /**
     * Get phone value
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\Orderer_1
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($phone) && mb_strlen($phone) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($phone)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($phone) && mb_strlen($phone) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get email1 value
     * @return string
     */
    public function getEmail1()
    {
        return $this->email1;
    }
    /**
     * Set email1 value
     * @param string $email1
     * @return \StructType\Orderer_1
     */
    public function setEmail1($email1 = null)
    {
        // validation for constraint: string
        if (!is_null($email1) && !is_string($email1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email1, true), gettype($email1)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($email1) && mb_strlen($email1) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($email1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($email1) && mb_strlen($email1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($email1)), __LINE__);
        }
        $this->email1 = $email1;
        return $this;
    }
    /**
     * Get mobile1 value
     * @return string
     */
    public function getMobile1()
    {
        return $this->mobile1;
    }
    /**
     * Set mobile1 value
     * @param string $mobile1
     * @return \StructType\Orderer_1
     */
    public function setMobile1($mobile1 = null)
    {
        // validation for constraint: string
        if (!is_null($mobile1) && !is_string($mobile1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile1, true), gettype($mobile1)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($mobile1) && mb_strlen($mobile1) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($mobile1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($mobile1) && mb_strlen($mobile1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($mobile1)), __LINE__);
        }
        $this->mobile1 = $mobile1;
        return $this;
    }
}
